/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class ErrorMessages
extends VTITemplate
implements VTICosting,
PrivilegedAction {
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SQL_STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MESSAGE", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("SEVERITY", 4, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);
    private Properties p;
    private Enumeration keys;
    private String k;
    private String SQLState;
    private String message;
    private int severity;
    private int msgFile;

    public boolean next() {
        boolean bl = true;
        if (!this.keys.hasMoreElements()) {
            this.close();
            bl = false;
            return bl;
        }
        this.k = (String)this.keys.nextElement();
        if (this.notAnException()) {
            bl = this.next();
        }
        if (bl) {
            this.SQLState = StandardException.getSQLStateFromIdentifier(this.k);
            this.message = MessageService.getTextMessage(this.k);
            this.message = StringUtil.truncate(this.message, 32672);
        }
        return bl;
    }

    public void close() {
        this.p = null;
        this.k = null;
        this.keys = null;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public String getString(int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.SQLState;
            }
            case 2: {
                return this.message;
            }
        }
        return super.getString(n);
    }

    public int getInt(int n) throws SQLException {
        switch (n) {
            case 3: {
                return this.severity;
            }
        }
        return super.getInt(n);
    }

    private void loadProperties() throws IOException {
        this.p = new Properties();
        int n = 0;
        while (n < 50) {
            this.msgFile = n;
            InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
            if (inputStream != null) {
                try {
                    this.p.load(inputStream);
                }
                finally {
                    Object var4_3 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n;
        }
        this.keys = ((Hashtable)this.p).keys();
    }

    private boolean notAnException() {
        if (this.k.length() < 5) {
            return true;
        }
        int n = StandardException.getSeverityFromIdentifier(this.k);
        if (n < 1) {
            return true;
        }
        this.severity = n;
        return false;
    }

    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 1000.0;
    }

    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 5000.0;
    }

    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return true;
    }

    public final Object run() {
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/loc/m" + this.msgFile + "_en.properties");
        this.msgFile = 0;
        return inputStream;
    }

    public ErrorMessages() throws IOException {
        this.loadProperties();
    }
}

