/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.MemberTableHash;

class MemberTable {
    protected Vector entries;
    private Hashtable hashtable;
    private MemberTableHash mutableMTH = null;

    void addEntry(ClassMember classMember) {
        MemberTableHash memberTableHash = new MemberTableHash(classMember.getName(), classMember.getDescriptor(), this.entries.size());
        this.entries.addElement(classMember);
        this.hashtable.put(memberTableHash, memberTableHash);
    }

    ClassMember find(String string, String string2) {
        this.mutableMTH.name = string;
        this.mutableMTH.descriptor = string2;
        this.mutableMTH.setHashCode();
        MemberTableHash memberTableHash = (MemberTableHash)this.hashtable.get(this.mutableMTH);
        if (memberTableHash == null) {
            return null;
        }
        return (ClassMember)this.entries.elementAt(memberTableHash.index);
    }

    void put(ClassFormatOutput classFormatOutput) throws IOException {
        Vector vector = this.entries;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((ClassMember)vector.elementAt(n2)).put(classFormatOutput);
            ++n2;
        }
    }

    int size() {
        return this.entries.size();
    }

    int classFileSize() {
        int n = 0;
        Vector vector = this.entries;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            n += ((ClassMember)vector.elementAt(n3)).classFileSize();
            ++n3;
        }
        return n;
    }

    public MemberTable(int n) {
        this.entries = new Vector(n);
        this.hashtable = new Hashtable(n > 50 ? n : 50);
        this.mutableMTH = new MemberTableHash(null, null);
    }
}

