/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.io.FormatableLongHolder;

public class FormatableHashtable
extends Hashtable
implements Formatable {
    public Object put(Object object, Object object2) {
        if (object2 == null) {
            return this.remove(object);
        }
        return super.put(object, object2);
    }

    public void putInt(Object object, int n) {
        super.put(object, new FormatableIntHolder(n));
    }

    public int getInt(Object object) {
        return ((FormatableIntHolder)this.get(object)).getInt();
    }

    public void putLong(Object object, long l) {
        super.put(object, new FormatableLongHolder(l));
    }

    public long getLong(Object object) {
        return ((FormatableLongHolder)this.get(object)).getLong();
    }

    public void putBoolean(Object object, boolean bl) {
        this.putInt(object, bl ? 1 : 0);
    }

    public boolean getBoolean(Object object) {
        return this.getInt(object) != 0;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectOutput.writeObject(k);
            objectOutput.writeObject(this.get(k));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        while (n > 0) {
            super.put(objectInput.readObject(), objectInput.readObject());
            --n;
        }
    }

    public void readExternal(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        int n = arrayInputStream.readInt();
        while (n > 0) {
            super.put(arrayInputStream.readObject(), arrayInputStream.readObject());
            --n;
        }
    }

    public int getTypeFormatId() {
        return 313;
    }
}

