/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDecimal;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    public NumberDataValue absolute(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNegative()) {
            return this.minus(numberDataValue);
        }
        if (numberDataValue == null) {
            numberDataValue = (NumberDataType)this.getNewNull();
        }
        numberDataValue.setValue(this.getObject());
        return numberDataValue;
    }

    public NumberDataValue sqrt(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        double d = this.getDouble();
        if (this.isNegative()) {
            if (new Double(d).equals(new Double(-0.0))) {
                d = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        numberDataValue.setValue(Math.sqrt(d));
        return numberDataValue;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        return null;
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return null;
    }

    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(dataValueDescriptor);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    public final boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    protected abstract boolean isNegative();

    public final void setValue(Byte by) throws StandardException {
        if (!this.objectNull(by)) {
            this.setValue((byte)by);
        }
    }

    public final void setValue(Short s) throws StandardException {
        if (!this.objectNull(s)) {
            this.setValue((short)s);
        }
    }

    public final void setValue(Integer n) throws StandardException {
        if (!this.objectNull(n)) {
            this.setValue((int)n);
        }
    }

    public final void setValue(Long l) throws StandardException {
        if (!this.objectNull(l)) {
            this.setValue((long)l);
        }
    }

    public final void setValue(Double d) throws StandardException {
        if (!this.objectNull(d)) {
            this.setValue((double)d);
        }
    }

    public void setValue(BigDecimal bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        if (bigDecimal.compareTo(SQLDecimal.MINLONG_MINUS_ONE) != 1 || bigDecimal.compareTo(SQLDecimal.MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", this.getTypeName());
        }
        this.setValue(bigDecimal.longValue());
    }

    public final void setValue(Float f) throws StandardException {
        if (!this.objectNull(f)) {
            this.setValue(f.floatValue());
        }
    }

    public final void setValue(Boolean bl) throws StandardException {
        if (!this.objectNull(bl)) {
            this.setValue((boolean)bl);
        }
    }

    protected final boolean objectNull(Object object) {
        if (object == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float f) throws StandardException {
        if (Float.isNaN(f) || Float.isInfinite(f) || f < -3.402E38f || f > 3.402E38f || f > 0.0f && f < 1.175E-37f || f < 0.0f && f > -1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (f == 0.0f) {
            f = 0.0f;
        }
        return f;
    }

    public static float normalizeREAL(double d) throws StandardException {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < (double)-3.402E38f || d > (double)3.402E38f || d > 0.0 && d < (double)1.175E-37f || d < 0.0 && d > (double)-1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (d == 0.0) {
            d = 0.0;
        }
        return (float)d;
    }

    public static double normalizeDOUBLE(double d) throws StandardException {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < -1.79769E308 || d > 1.79769E308 || d > 0.0 && d < 2.225E-307 || d < 0.0 && d > -2.225E-307) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        if (d == 0.0) {
            d = 0.0;
        }
        return d;
    }

    public abstract int getLength() throws StandardException;

    public abstract String getString() throws StandardException;

    public abstract DataValueDescriptor getClone();

    public abstract DataValueDescriptor getNewNull();

    public abstract void setValueFromResultSet(ResultSet var1, int var2, boolean var3) throws StandardException, SQLException;

    public abstract String getTypeName();

    public abstract void readExternalFromArray(ArrayInputStream var1) throws IOException, ClassNotFoundException;

    public abstract int estimateMemoryUsage();

    public abstract boolean isNull();

    public abstract void restoreToNull();

    public abstract void readExternal(ObjectInput var1) throws IOException, ClassNotFoundException;

    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    public abstract int getTypeFormatId();

    public abstract NumberDataValue plus(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue minus(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue times(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue divide(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue minus(NumberDataValue var1) throws StandardException;
}

