/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public int getColumnCount() {
        return this.columnInfo == null ? 0 : this.columnInfo.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.isAutoincrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(n));
    }

    public boolean isSearchable(int n) throws SQLException {
        this.validColumnNumber(n);
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return DataTypeUtilities.isCurrency(this.getColumnTypeDescriptor(n));
    }

    public int isNullable(int n) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(n));
    }

    public boolean isSigned(int n) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(n));
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(n));
    }

    public String getColumnLabel(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "Column" + Integer.toString(n) : string;
    }

    public String getColumnName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "" : string;
    }

    public String getSchemaName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getSchemaName();
        return string == null ? "" : string;
    }

    public int getPrecision(int n) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(n));
    }

    public int getScale(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getScale();
    }

    public String getTableName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string = resultColumnDescriptor.getSourceTableName();
        return string == null ? "" : string;
    }

    public String getCatalogName(int n) throws SQLException {
        this.validColumnNumber(n);
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getJDBCTypeId();
    }

    public String getColumnTypeName(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getSQLTypeName();
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    private void validColumnNumber(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", new Integer(n));
        }
    }

    public DataTypeDescriptor getColumnTypeDescriptor(int n) throws SQLException {
        this.validColumnNumber(n);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.getType();
    }

    public String getColumnClassName(int n) throws SQLException {
        return this.getColumnTypeDescriptor(n).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n, boolean bl) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n, boolean bl, int n2) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl, n2));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, DataTypeDescriptor dataTypeDescriptor) {
        return new GenericColumnDescriptor(string, dataTypeDescriptor);
    }

    public EmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        this.columnInfo = resultColumnDescriptorArray;
    }
}

