/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;

public abstract class JNDIAuthenticationSchemeBase
implements UserAuthenticator {
    protected final JNDIAuthenticationService authenticationService;
    protected String providerURL;
    private AccessFactory store;
    protected Properties initDirContextEnv;

    protected abstract void setJNDIProviderProperties();

    private void setInitDirContextEnv(Properties properties) {
        this.initDirContextEnv = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("java.naming.")) continue;
            ((Hashtable)this.initDirContextEnv).put(string, properties.getProperty(string));
        }
    }

    protected static final SQLException getLoginSQLException(Exception exception) {
        String string = MessageService.getTextMessage("08004", exception);
        SQLException sQLException = new SQLException(string, "08004", 40000);
        return sQLException;
    }

    public abstract boolean authenticateUser(String var1, String var2, String var3, Properties var4) throws SQLException;

    public JNDIAuthenticationSchemeBase(JNDIAuthenticationService jNDIAuthenticationService, Properties properties) {
        this.authenticationService = jNDIAuthenticationService;
        this.setInitDirContextEnv(properties);
        this.setJNDIProviderProperties();
    }
}

