/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.Timeout;

public final class LockSet
extends Hashtable {
    private final SinglePool factory;
    protected int deadlockTimeout = 20000;
    protected int waitTimeout = 60000;
    private boolean deadlockTrace;
    private Hashtable lockTraces;
    protected int blockCount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lock lockObject(Object object, Lockable lockable, Object object2, int n, Latch latch) throws StandardException {
        int n2;
        Lock lock;
        LockControl lockControl;
        Object var9_6 = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(lockable);
            if (control == null) {
                Lock lock2 = new Lock(object, lockable, object2);
                lock2.grant();
                this.put(lockable, lock2);
                return lock2;
            }
            lockControl = control.getLockControl();
            if (lockControl != control) {
                this.put(lockable, lockControl);
            }
            if ((lock = lockControl.addLock(this, object, object2)).getCount() != 0) {
                return lock;
            }
            if (n == 0) {
                lockControl.giveUpWait(lock, this);
                return null;
            }
            if (latch != null) {
                this.unlock(latch, 1);
            }
        }
        boolean bl = false;
        if (n == -1) {
            bl = true;
            n2 = this.deadlockTimeout;
            if (n2 == -1) {
                n2 = 20000;
            }
        } else {
            if (n == -2) {
                n = n2 = this.waitTimeout;
            } else {
                n2 = n;
            }
            if (this.deadlockTimeout >= 0) {
                if (n2 < 0) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                } else if (this.deadlockTimeout < n2) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                    n -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock activeLock = (ActiveLock)lock;
        lock = null;
        if (this.deadlockTrace) {
            this.lockTraces.put(activeLock, new Throwable());
        }
        int n3 = 0;
        long l = 0L;
        try {
            while (true) {
                Object var23_30;
                long l2;
                ActiveLock activeLock2;
                byte by;
                block44: {
                    ActiveLock activeLock3;
                    block43: {
                        by = activeLock.waitForGrant(n2);
                        activeLock2 = null;
                        Object[] objectArray = null;
                        try {
                            StandardException standardException;
                            boolean bl2;
                            Enumeration enumeration;
                            block42: {
                                ActiveLock activeLock4;
                                block41: {
                                    enumeration = null;
                                    l2 = 0L;
                                    LockSet lockSet2 = this;
                                    synchronized (lockSet2) {
                                        if (lockControl.isGrantable(lockControl.firstWaiter() == activeLock, object, object2)) {
                                            lockControl.grant(activeLock);
                                            activeLock2 = lockControl.getNextWaiter(activeLock, true, this);
                                            if (latch != null) {
                                                this.lockObject(object, latch.getLockable(), latch.getQualifier(), -1, null);
                                            }
                                            activeLock4 = activeLock;
                                            Object var30_38 = null;
                                            break block41;
                                        }
                                        activeLock.clearPotentiallyGranted();
                                        bl2 = by != 1;
                                        standardException = null;
                                        if (by == 0 && bl || by == 2) {
                                            objectArray = Deadlock.look(this.factory, this, lockControl, activeLock, by);
                                            if (objectArray == null) {
                                                bl = false;
                                                n2 = n;
                                                l = 0L;
                                                bl2 = false;
                                            } else {
                                                bl2 = true;
                                            }
                                        }
                                        activeLock2 = lockControl.getNextWaiter(activeLock, bl2, this);
                                        if (bl2) {
                                            if (latch != null) {
                                                this.lockObject(object, latch.getLockable(), latch.getQualifier(), -1, null);
                                            }
                                            if (!bl && this.deadlockTrace) {
                                                l2 = System.currentTimeMillis();
                                                enumeration = this.factory.makeVirtualLockTable();
                                            }
                                        }
                                        break block42;
                                    }
                                }
                                ActiveLock activeLock5 = activeLock4;
                                var23_30 = null;
                                if (activeLock2 != null) {
                                    activeLock2.wakeUp((byte)1);
                                    activeLock2 = null;
                                }
                                activeLock3 = activeLock5;
                                break block43;
                            }
                            if (!bl2) break block44;
                            if (!bl) {
                                if (this.deadlockTrace) {
                                    throw Timeout.buildException(activeLock, enumeration, l2);
                                }
                                standardException = StandardException.newException("40XL1");
                                throw standardException;
                            }
                            if (objectArray != null) {
                                throw Deadlock.buildException(this.factory, objectArray);
                            }
                            break block44;
                        }
                        catch (Throwable throwable) {
                            var23_30 = null;
                            if (activeLock2 == null) throw throwable;
                            activeLock2.wakeUp((byte)1);
                            activeLock2 = null;
                            throw throwable;
                        }
                    }
                    Object var11_19 = null;
                    if (!this.deadlockTrace) return activeLock3;
                    this.lockTraces.remove(activeLock);
                    return activeLock3;
                }
                var23_30 = null;
                if (activeLock2 != null) {
                    activeLock2.wakeUp((byte)1);
                    activeLock2 = null;
                }
                if (n2 == -1) continue;
                if (by != 0) {
                    ++n3;
                }
                if (n3 <= 5) continue;
                long l3 = System.currentTimeMillis();
                if (l != 0L) {
                    l2 = l3 - l;
                    n2 = (int)((long)n2 - l2);
                }
                l = l3;
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (!this.deadlockTrace) throw throwable;
            this.lockTraces.remove(activeLock);
            throw throwable;
        }
    }

    void unlock(Latch latch, int n) {
        boolean bl = false;
        ActiveLock activeLock = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(latch.getLockable());
            bl = control.unlock(latch, n);
            latch = null;
            boolean bl2 = true;
            if (bl && (activeLock = control.firstWaiter()) != null) {
                bl2 = false;
                if (!activeLock.setPotentiallyGranted()) {
                    activeLock = null;
                }
            }
            if (bl2) {
                if (control.isEmpty()) {
                    this.remove(control.getLockable());
                }
                Object var6_8 = null;
                return;
            }
        }
        if (bl && activeLock != null) {
            activeLock.wakeUp((byte)1);
        }
    }

    void setDeadlockTrace(boolean bl) {
        this.deadlockTrace = bl;
        if (bl && this.lockTraces == null) {
            this.lockTraces = new Hashtable();
        } else if (!bl && this.lockTraces != null) {
            this.lockTraces = null;
        }
    }

    public String toDebugString() {
        return null;
    }

    synchronized LockSet shallowClone() {
        LockSet lockSet = new LockSet(this.factory);
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Lockable lockable = (Lockable)enumeration.nextElement();
            Control control = this.getControl(lockable);
            lockSet.put(lockable, control.shallowClone());
        }
        return lockSet;
    }

    void oneMoreWaiter() {
        ++this.blockCount;
    }

    void oneLessWaiter() {
        --this.blockCount;
    }

    boolean anyoneBlocked() {
        return this.blockCount != 0;
    }

    public final Control getControl(Lockable lockable) {
        return (Control)this.get(lockable);
    }

    protected LockSet(SinglePool singlePool) {
        this.factory = singlePool;
    }
}

