/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockList;
import org.apache.derby.impl.services.locks.LockSet;

class LockSpace
extends Hashtable {
    private final Object compatSpace;
    private final Dictionary holder;
    private HashMap[] spareGroups = new HashMap[3];
    private Object callbackGroup;
    private int limit;
    private int nextLimitCall;
    private Limit callback;
    private boolean inLimit;

    protected synchronized void addLock(Object object, Lock lock) throws StandardException {
        Lock lock2 = null;
        HashMap hashMap = (HashMap)this.get(object);
        if (hashMap == null) {
            hashMap = this.getGroupMap(object);
        } else if (lock.getCount() != 1) {
            lock2 = (Lock)hashMap.get(lock);
        }
        if (lock2 == null) {
            lock2 = lock.copy();
            hashMap.put(lock2, lock2);
        }
        ++lock2.count;
        if (this.inLimit) {
            return;
        }
        if (!object.equals(this.callbackGroup)) {
            return;
        }
        int n = hashMap.size();
        if (n > this.nextLimitCall) {
            this.inLimit = true;
            this.callback.reached(this.compatSpace, object, this.limit, new LockList(Collections.enumeration(hashMap.keySet())), n);
            this.inLimit = false;
            int n2 = hashMap.size();
            this.nextLimitCall = n2 < this.limit / 2 ? this.limit : (n2 < this.nextLimitCall / 2 ? (this.nextLimitCall -= this.limit) : (this.nextLimitCall += this.limit));
        }
    }

    synchronized void unlockGroup(LockSet lockSet, Object object) {
        HashMap hashMap = (HashMap)this.remove(object);
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            lockSet.unlock((Lock)iterator.next(), 0);
        }
        if (this.callbackGroup == null && this.isEmpty()) {
            this.holder.remove(this.compatSpace);
        } else if (object.equals(this.callbackGroup)) {
            this.nextLimitCall = this.limit;
        }
        this.saveGroup(hashMap);
    }

    private HashMap getGroupMap(Object object) {
        HashMap[] hashMapArray = this.spareGroups;
        HashMap hashMap = null;
        int n = 0;
        while (n < 3) {
            hashMap = hashMapArray[n];
            if (hashMap != null) {
                hashMapArray[n] = null;
                break;
            }
            ++n;
        }
        if (hashMap == null) {
            hashMap = new HashMap(5, 0.8f);
        }
        this.put(object, hashMap);
        return hashMap;
    }

    private void saveGroup(HashMap hashMap) {
        HashMap[] hashMapArray = this.spareGroups;
        int n = 0;
        while (n < 3) {
            if (hashMapArray[n] == null) {
                hashMapArray[n] = hashMap;
                hashMap.clear();
                break;
            }
            ++n;
        }
    }

    synchronized void unlockGroup(LockSet lockSet, Object object, Matchable matchable) {
        HashMap hashMap = (HashMap)this.get(object);
        if (hashMap == null) {
            return;
        }
        boolean bl = true;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Lock lock = (Lock)iterator.next();
            if (!matchable.match(lock.getLockable())) {
                bl = false;
                continue;
            }
            lockSet.unlock(lock, 0);
            iterator.remove();
        }
        if (bl) {
            this.remove(object);
            this.saveGroup(hashMap);
            if (this.callbackGroup == null && this.isEmpty()) {
                this.holder.remove(this.compatSpace);
            } else if (object.equals(this.callbackGroup)) {
                this.nextLimitCall = this.limit;
            }
        }
    }

    synchronized void transfer(Object object, Object object2) {
        HashMap hashMap = (HashMap)this.get(object);
        if (hashMap == null) {
            return;
        }
        HashMap hashMap2 = (HashMap)this.get(object2);
        if (hashMap2 == null) {
            this.put(object2, hashMap);
            this.clearLimit(object);
            this.remove(object);
            return;
        }
        if (hashMap2.size() < hashMap.size()) {
            this.mergeGroups(hashMap2, hashMap);
            HashMap hashMap3 = this.put(object2, hashMap);
        } else {
            this.mergeGroups(hashMap, hashMap2);
        }
        this.clearLimit(object);
        this.remove(object);
    }

    private void mergeGroups(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = hashMap2.get(k);
            if (v == null) {
                hashMap2.put(k, k);
                continue;
            }
            Lock lock = (Lock)k;
            Lock lock2 = (Lock)v;
            lock2.count += lock.getCount();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized int unlockReference(LockSet lockSet, Lockable lockable, Object object, Object object2) {
        Lock lock;
        HashMap hashMap = (HashMap)this.get(object2);
        if (hashMap == null) {
            return 0;
        }
        LockSet lockSet2 = lockSet;
        synchronized (lockSet2) {
            Control control = lockSet.getControl(lockable);
            if (control == null) {
                return 0;
            }
            Lock lock2 = control.getLock(this.compatSpace, object);
            if (lock2 == null) {
                return 0;
            }
            lock = (Lock)hashMap.remove(lock2);
            if (lock == null) {
                return 0;
            }
            lock2 = null;
            lockSet.unlock(lock, 1);
        }
        if (lock.getCount() == 1) {
            if (!hashMap.isEmpty()) return 1;
            this.remove(object2);
            this.saveGroup(hashMap);
            if (this.callbackGroup == null && this.isEmpty()) {
                this.holder.remove(this.compatSpace);
                return 1;
            } else {
                if (!object2.equals(this.callbackGroup)) return 1;
                this.nextLimitCall = this.limit;
            }
            return 1;
        }
        --lock.count;
        hashMap.put(lock, lock);
        return 1;
    }

    synchronized boolean areLocksHeld(Object object) {
        return this.get(object) != null;
    }

    synchronized boolean isLockHeld(Object object, Lockable lockable, Object object2) {
        HashMap hashMap = (HashMap)this.get(object);
        if (hashMap == null) {
            return false;
        }
        Object v = hashMap.get(new Lock(this.compatSpace, lockable, object2));
        return v != null;
    }

    synchronized void setLimit(Object object, int n, Limit limit) {
        this.callbackGroup = object;
        this.nextLimitCall = this.limit = n;
        this.callback = limit;
    }

    synchronized void clearLimit(Object object) {
        if (object.equals(this.callbackGroup)) {
            this.callbackGroup = null;
            this.limit = Integer.MAX_VALUE;
            this.nextLimitCall = Integer.MAX_VALUE;
            this.callback = null;
            if (this.isEmpty()) {
                this.holder.remove(this.compatSpace);
            }
        }
    }

    synchronized int deadlockCount(int n) {
        int n2 = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            HashMap hashMap = (HashMap)enumeration.nextElement();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Lock lock = (Lock)iterator.next();
                if ((n2 += lock.getCount()) <= n) continue;
                return n2;
            }
        }
        return n2;
    }

    LockSpace(Dictionary dictionary, Object object) {
        this.compatSpace = object;
        this.holder = dictionary;
    }
}

