/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockSet;

class LockTableVTI
implements Enumeration {
    private final LockSet clonedLockTable;
    private final Enumeration outerControl;
    private Control control;
    private ListIterator grantedList;
    private ListIterator waitingList;
    private Latch nextLock;

    public boolean hasMoreElements() {
        if (this.nextLock != null) {
            return true;
        }
        while (true) {
            if (this.control == null) {
                List list;
                if (!this.outerControl.hasMoreElements()) {
                    return false;
                }
                this.control = (Control)this.outerControl.nextElement();
                List list2 = this.control.getGranted();
                if (list2 != null) {
                    this.grantedList = list2.listIterator();
                }
                if ((list = this.control.getWaiting()) != null) {
                    this.waitingList = list.listIterator();
                }
                this.nextLock = this.control.getFirstGrant();
                if (this.nextLock == null) {
                    this.nextLock = this.getNextLock(this.control);
                }
            } else {
                this.nextLock = this.getNextLock(this.control);
            }
            if (this.nextLock != null) {
                return true;
            }
            this.control = null;
        }
    }

    private Latch getNextLock(Control control) {
        Lock lock = null;
        if (this.grantedList != null) {
            if (this.grantedList.hasNext()) {
                lock = (Lock)this.grantedList.next();
            } else {
                this.grantedList = null;
            }
        }
        if (lock == null && this.waitingList != null) {
            if (this.waitingList.hasNext()) {
                lock = (Lock)this.waitingList.next();
            } else {
                this.waitingList = null;
            }
        }
        return lock;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Latch latch = this.nextLock;
        this.nextLock = null;
        return latch;
    }

    LockTableVTI(LockSet lockSet) {
        this.clonedLockTable = lockSet;
        this.outerControl = lockSet.elements();
    }
}

