/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.impl.services.reflect.JarFile;
import org.apache.derby.impl.services.reflect.UpdateLoader;

public class JarLoader
extends ClassLoader {
    private static final JarFile jarFileFactory;
    private UpdateLoader updateLoader;
    private JarFile jf;
    private HeaderPrintWriter vs;

    void initialize() {
        block5: {
            Object object = this.load();
            try {
                if (object instanceof File) {
                    this.jf.initialize((File)object);
                    return;
                }
                if (!(object instanceof InputStream)) break block5;
                this.jf.isStream = true;
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException iOException) {
                if (this.vs == null) break block5;
                this.vs.println(MessageService.getTextMessage("C003", this.getJarName(), iOException));
            }
        }
        this.setInvalid(false);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.updateLoader == null) {
                throw new ClassNotFoundException(MessageService.getTextMessage("C004", string));
            }
            Class clazz = this.updateLoader.loadClass(string, bl);
            if (clazz == null) {
                throw classNotFoundException;
            }
            return clazz;
        }
    }

    public InputStream getResourceAsStream(String string) {
        if (this.updateLoader == null) {
            return null;
        }
        return this.updateLoader.getResourceAsStream(string);
    }

    final String getJarName() {
        return this.jf.getJarName();
    }

    Class loadClassData(String string, String string2, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        try {
            if (this.jf.isZip()) {
                return this.loadClassDataFromJar(string, string2, bl);
            }
            if (this.jf.isStream) {
                return this.loadClassData((InputStream)this.load(), string, string2, bl);
            }
            return null;
        }
        catch (IOException iOException) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage("C007", string, this.getJarName(), iOException));
            }
            return null;
        }
    }

    InputStream getStream(String string) {
        if (this.updateLoader == null) {
            return null;
        }
        if (this.jf.isZip()) {
            return this.getRawStream(this.jf.getZip(), string);
        }
        if (this.jf.isStream) {
            return this.getRawStream((InputStream)this.load(), string);
        }
        return null;
    }

    private Class loadClassDataFromJar(String string, String string2, boolean bl) throws IOException {
        Class clazz;
        ZipEntry zipEntry = this.jf.getEntry(string2);
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = this.jf.getZip().getInputStream(zipEntry);
        try {
            clazz = this.loadClassData(zipEntry, inputStream, string, bl);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return clazz;
    }

    private Class loadClassData(InputStream inputStream, String string, String string2, boolean bl) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = this.jf.getZipOnStream(inputStream);
        do {
            if ((zipEntry = this.jf.getNextEntry(zipInputStream)) != null) continue;
            zipInputStream.close();
            return null;
        } while (!zipEntry.getName().equals(string2));
        Class clazz = this.loadClassData(zipEntry, zipInputStream, string, bl);
        zipInputStream.close();
        return clazz;
    }

    private Class loadClassData(ZipEntry zipEntry, InputStream inputStream, String string, boolean bl) throws IOException {
        byte[] byArray = this.jf.readData(zipEntry, inputStream, string);
        Object[] objectArray = this.jf.getSigners(string, zipEntry);
        UpdateLoader updateLoader = this.updateLoader;
        synchronized (updateLoader) {
            Class<?> clazz = this.updateLoader.checkLoaded(string, bl);
            if (clazz == null) {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (objectArray != null) {
                    this.setSigners(clazz, objectArray);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
            }
            Class<?> clazz2 = clazz;
            Object var8_10 = null;
            return clazz2;
        }
    }

    Class checkLoaded(String string, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Object load() {
        String[] stringArray = this.jf.name;
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            return this.updateLoader.getJarReader().readJarFile(string, string2);
        }
        catch (StandardException standardException) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage("C003", this.jf.getJarName(), standardException));
            }
            return null;
        }
    }

    JarFile setInvalid(boolean bl) {
        this.jf.setInvalid();
        this.updateLoader = null;
        return bl ? jarFileFactory.newJarFile(this.jf.name) : null;
    }

    private InputStream getRawStream(ZipFile zipFile, String string) {
        try {
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private InputStream getRawStream(InputStream inputStream, String string) {
        block5: {
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(inputStream);
                while ((zipEntry = this.jf.getNextEntry(zipInputStream)) != null) {
                    if (!zipEntry.getName().equals(string)) continue;
                    LimitInputStream limitInputStream = new LimitInputStream(zipInputStream);
                    limitInputStream.setLimit((int)zipEntry.getSize());
                    return limitInputStream;
                }
                zipInputStream.close();
            }
            catch (IOException iOException) {
                if (zipInputStream == null) break block5;
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    JarLoader(UpdateLoader updateLoader, String[] stringArray, HeaderPrintWriter headerPrintWriter) {
        this.updateLoader = updateLoader;
        this.jf = jarFileFactory.newJarFile(stringArray);
        this.vs = headerPrintWriter;
    }

    static {
        JarFile jarFile = null;
        if (JVMInfo.JDK_ID >= 2) {
            try {
                Class<?> clazz = Class.forName("org.apache.derby.impl.services.reflect.JarFileJava2");
                jarFile = (JarFile)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        } else {
            jarFile = new JarFile();
        }
        jarFileFactory = jarFile;
    }
}

