/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCHECKSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCHECKS";
    protected static final int SYSCHECKS_COLUMN_COUNT = 3;
    protected static final int SYSCHECKS_CONSTRAINTID = 1;
    protected static final int SYSCHECKS_CHECKDEFINITION = 2;
    protected static final int SYSCHECKS_REFERENCEDCOLUMNS = 3;
    protected static final int SYSCHECKS_CONSTRAINTID_WIDTH = 36;
    protected static final int SYSCHECKS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[][] indexColumnNames = new String[][]{{"CONSTRAINTID"}};
    private static final String[] uuids = new String[]{"80000056-00d0-fd77-3ed8-000a0a0b1900", "80000059-00d0-fd77-3ed8-000a0a0b1900", "80000058-00d0-fd77-3ed8-000a0a0b1900"};

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        ReferencedColumns referencedColumns = null;
        String string = null;
        String string2 = null;
        if (tupleDescriptor != null) {
            CheckConstraintDescriptor checkConstraintDescriptor = (CheckConstraintDescriptor)tupleDescriptor;
            string2 = checkConstraintDescriptor.getUUID().toString();
            string = checkConstraintDescriptor.getConstraintText();
            referencedColumns = checkConstraintDescriptor.getReferencedColumnsDescriptor();
        }
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(3);
        execIndexRow.setColumn(1, this.dvf.getCharDataValue(string2));
        execIndexRow.setColumn(2, this.dvf.getLongvarcharDataValue(string));
        execIndexRow.setColumn(3, this.dvf.getDataValue(referencedColumns));
        return execIndexRow;
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
        }
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        SubCheckConstraintDescriptor subCheckConstraintDescriptor = null;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        ReferencedColumns referencedColumns = (ReferencedColumns)dataValueDescriptor.getObject();
        subCheckConstraintDescriptor = new SubCheckConstraintDescriptor(uUID, string2, referencedColumns);
        return subCheckConstraintDescriptor;
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        boolean bl = true;
        SystemColumn[] systemColumnArray = new SystemColumn[3];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONSTRAINTID"), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CHECKDEFINITION"), 2, 0, 0, false, "LONG VARCHAR", true, 32700);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("REFERENCEDCOLUMNS"), 3, 0, 0, false, "org.apache.derby.catalog.ReferencedColumns", false, -1);
        return systemColumnArray;
    }

    public SYSCHECKSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, indexColumnNames, uniqueness, uuids);
    }
}

