/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.RowList;
import org.apache.derby.iapi.sql.dictionary.TabInfo;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.IndexInfoImpl;

public class TabInfoImpl
implements TabInfo {
    private IndexInfoImpl[] indexes;
    private String name;
    private long heapConglomerate;
    private int numIndexesSet;
    private boolean heapSet;
    private UUID uuid;
    private CatalogRowFactory crf;
    private ExecutionFactory executionFactory;
    private boolean computedStreamStorableHeapColIds = false;
    private int[] streamStorableHeapColIds;

    public long getHeapConglomerate() {
        return this.heapConglomerate;
    }

    public void setHeapConglomerate(long l) {
        this.heapConglomerate = l;
        this.heapSet = true;
    }

    public long getIndexConglomerate(int n) {
        return this.indexes[n].getConglomerateNumber();
    }

    public void setIndexConglomerate(int n, long l) {
        this.indexes[n].setConglomerateNumber(l);
        ++this.numIndexesSet;
    }

    public void setIndexConglomerate(ConglomerateDescriptor conglomerateDescriptor) {
        String string = conglomerateDescriptor.getConglomerateName();
        int n = 0;
        while (n < this.indexes.length) {
            if (this.indexes[n].getIndexName().equals(string)) {
                this.indexes[n].setConglomerateNumber(conglomerateDescriptor.getConglomerateNumber());
                break;
            }
            ++n;
        }
        ++this.numIndexesSet;
    }

    public String getTableName() {
        return this.name;
    }

    public String getIndexName(int n) {
        return this.indexes[n].getIndexName();
    }

    public void setIndexName(int n, String string) {
        this.indexes[n].setIndexName(string);
    }

    public CatalogRowFactory getCatalogRowFactory() {
        return this.crf;
    }

    public boolean isComplete() {
        if (!this.heapSet) {
            return false;
        }
        return this.indexes == null || this.indexes.length == this.numIndexesSet;
    }

    public int getIndexColumnCount(int n) {
        return this.indexes[n].getColumnCount();
    }

    public IndexRowGenerator getIndexRowGenerator(int n) {
        return this.indexes[n].getIndexRowGenerator();
    }

    public void setIndexRowGenerator(int n, IndexRowGenerator indexRowGenerator) {
        this.indexes[n].setIndexRowGenerator(indexRowGenerator);
    }

    public int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.length;
    }

    public int getBaseColumnPosition(int n, int n2) {
        return this.indexes[n].getBaseColumnPosition(n2);
    }

    public void setBaseColumnPosition(int n, int n2, int n3) {
        this.indexes[n].setBaseColumnPosition(n2, n3);
    }

    public boolean isIndexUnique(int n) {
        return this.indexes[n].isIndexUnique();
    }

    public int insertRow(ExecRow execRow, TransactionController transactionController, boolean bl) throws StandardException {
        RowList rowList = new RowList(this);
        rowList.add(execRow);
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(rowList, transactionController, rowLocationArray, bl);
    }

    public int insertRow(ExecRow execRow, LanguageConnectionContext languageConnectionContext) throws StandardException {
        RowList rowList = new RowList(this);
        rowList.add(execRow);
        return this.insertRowList(rowList, languageConnectionContext);
    }

    public RowLocation insertRowAndFetchRowLocation(ExecRow execRow, TransactionController transactionController) throws StandardException {
        RowList rowList = new RowList(this);
        rowList.add(execRow);
        RowLocation[] rowLocationArray = new RowLocation[1];
        this.insertRowListImpl(rowList, transactionController, rowLocationArray, true);
        return rowLocationArray[0];
    }

    public int deleteRowList(RowList rowList, LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n = 0;
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        Enumeration enumeration = rowList.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = this.crf.getPrimaryKeyIndexNumber();
            ExecIndexRow execIndexRow = (ExecIndexRow)enumeration.nextElement();
            n += this.deleteRow(transactionController, execIndexRow, n2);
        }
        return n;
    }

    public int insertRowList(RowList rowList, TransactionController transactionController) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(rowList, transactionController, rowLocationArray, true);
    }

    public int insertRowList(RowList rowList, LanguageConnectionContext languageConnectionContext) throws StandardException {
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        return this.insertRowList(rowList, transactionController);
    }

    private int insertRowListImpl(RowList rowList, TransactionController transactionController, RowLocation[] rowLocationArray, boolean bl) throws StandardException {
        RowLocation rowLocation;
        int n = -1;
        int n2 = this.crf.getNumIndexes();
        ConglomerateController[] conglomerateControllerArray = new ConglomerateController[n2];
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4 | (bl ? 0 : 128), 6, 4);
        int n3 = 0;
        while (n3 < n2) {
            long l = this.getIndexConglomerate(n3);
            if (l > -1L) {
                conglomerateControllerArray[n3] = transactionController.openConglomerate(l, false, 4 | (bl ? 0 : 128), 6, 4);
            }
            ++n3;
        }
        rowLocationArray[0] = rowLocation = conglomerateController.newRowLocationTemplate();
        n3 = 0;
        Enumeration enumeration = rowList.elements();
        while (enumeration.hasMoreElements()) {
            ExecRow execRow = (ExecRow)enumeration.nextElement();
            conglomerateController.insertAndFetchLocation(execRow.getRowArray(), rowLocation);
            int n4 = 0;
            while (n4 < n2) {
                ExecIndexRow execIndexRow;
                int n5;
                if (conglomerateControllerArray[n4] != null && (n5 = conglomerateControllerArray[n4].insert((execIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n4), rowLocation, execRow)).getRowArray())) == 1) {
                    n = n3;
                }
                ++n4;
            }
            ++n3;
        }
        int n6 = 0;
        while (n6 < n2) {
            if (conglomerateControllerArray[n6] != null) {
                conglomerateControllerArray[n6].close();
            }
            ++n6;
        }
        conglomerateController.close();
        return n;
    }

    public int truncate(TransactionController transactionController) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        RowChanger rowChanger = this.getRowChanger(transactionController, null, execRow);
        rowChanger.open(7);
        int n = 0;
        ScanController scanController = transactionController.openScan(this.getHeapConglomerate(), false, 4, 7, 4, null, null, 0, null, null, 0);
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, 7, 4);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        while (scanController.next()) {
            ++n;
            scanController.fetchLocation(rowLocation);
            boolean bl = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            rowChanger.deleteRow(execRow, rowLocation);
        }
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
        return n;
    }

    public int deleteRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, 1, null, null, execIndexRow, -1, n);
    }

    public int deleteRows(TransactionController transactionController, ExecIndexRow execIndexRow, int n, Qualifier[][] qualifierArray, TupleFilter tupleFilter, ExecIndexRow execIndexRow2, int n2, int n3) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        int n4 = 0;
        boolean bl = true;
        RowChanger rowChanger = this.getRowChanger(transactionController, null, execRow);
        int n5 = execIndexRow != null && execIndexRow2 != null ? TransactionController.MODE_RECORD : TransactionController.MODE_TABLE;
        int n6 = execIndexRow != null && execIndexRow2 != null && execIndexRow == execIndexRow2 ? 4 : 5;
        rowChanger.open(n5);
        DataValueDescriptor[] dataValueDescriptorArray = execIndexRow == null ? null : execIndexRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow2 == null ? null : execIndexRow2.getRowArray();
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, n5, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n3), false, 4, n5, n6, null, dataValueDescriptorArray, n, qualifierArray, dataValueDescriptorArray2, n2);
        ExecIndexRow execIndexRow3 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n3), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        while (scanController.next()) {
            scanController.fetch(execIndexRow3.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow3.getColumn(execIndexRow3.nColumns());
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            if (tupleFilter != null) {
                bl = tupleFilter.execute(execRow).equals(true);
            }
            if (!bl) continue;
            rowChanger.deleteRow(execRow, rowLocation);
            ++n4;
        }
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
        return n4;
    }

    public ExecRow getRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        ExecRow execRow;
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);
        try {
            execRow = this.getRow(transactionController, conglomerateController, execIndexRow, n);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            conglomerateController.close();
            throw throwable;
        }
        conglomerateController.close();
        return execRow;
    }

    public RowLocation getRowLocation(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        RowLocation rowLocation;
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);
        try {
            RowLocation[] rowLocationArray = new RowLocation[1];
            ExecRow execRow = this.getRowInternal(transactionController, conglomerateController, execIndexRow, n, rowLocationArray);
            rowLocation = rowLocationArray[0];
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            conglomerateController.close();
            throw throwable;
        }
        conglomerateController.close();
        return rowLocation;
    }

    public ExecRow getRow(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.getRowInternal(transactionController, conglomerateController, execIndexRow, n, rowLocationArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExecRow getRowInternal(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n, RowLocation[] rowLocationArray) throws StandardException {
        ExecRow execRow;
        ScanController scanController;
        block4: {
            ExecRow execRow2;
            block3: {
                ExecRow execRow3 = this.crf.makeEmptyRow();
                scanController = transactionController.openScan(this.getIndexConglomerate(n), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
                ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
                try {
                    if (scanController.next()) {
                        RowLocation rowLocation;
                        scanController.fetch(execIndexRow2.getRowArray());
                        rowLocationArray[0] = rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                        boolean bl = conglomerateController.fetch(rowLocation, execRow3.getRowArray(), null);
                        execRow2 = execRow3;
                        Object var11_13 = null;
                        break block3;
                    }
                    execRow = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    scanController.close();
                    throw throwable;
                }
            }
            scanController.close();
            return execRow2;
        }
        Object var11_14 = null;
        scanController.close();
        return execRow;
    }

    public void updateRow(ExecIndexRow execIndexRow, ExecRow execRow, int n, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        this.updateRow(execIndexRow, execRow, n, blArray, nArray, transactionController, true);
    }

    public void updateRow(ExecIndexRow execIndexRow, ExecRow execRow, int n, boolean[] blArray, int[] nArray, TransactionController transactionController, boolean bl) throws StandardException {
        ExecRow[] execRowArray = new ExecRow[]{execRow};
        this.updateRow(execIndexRow, execRowArray, n, blArray, nArray, transactionController, bl);
    }

    public void updateRow(ExecIndexRow execIndexRow, ExecRow[] execRowArray, int n, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        this.updateRow(execIndexRow, execRowArray, n, blArray, nArray, transactionController, true);
    }

    public void updateRow(ExecIndexRow execIndexRow, ExecRow[] execRowArray, int n, boolean[] blArray, int[] nArray, TransactionController transactionController, boolean bl) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        RowChanger rowChanger = this.getRowChanger(transactionController, nArray, execRow);
        rowChanger.openForUpdate(blArray, 6, bl);
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4 | (bl ? 0 : 128), 6, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n), false, 4 | (bl ? 0 : 128), 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        int n2 = 0;
        while (scanController.next()) {
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            rowChanger.updateRow(execRow, n2 == execRowArray.length - 1 ? execRowArray[n2] : execRowArray[n2++], rowLocation);
        }
        rowChanger.finish();
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
    }

    public Properties getCreateHeapProperties() {
        return this.crf.getCreateHeapProperties();
    }

    public Properties getCreateIndexProperties(int n) {
        return this.crf.getCreateIndexProperties(n);
    }

    private RowChanger getRowChanger(TransactionController transactionController, int[] nArray, ExecRow execRow) throws StandardException {
        int n = this.crf.getNumIndexes();
        IndexRowGenerator[] indexRowGeneratorArray = new IndexRowGenerator[n];
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            indexRowGeneratorArray[n2] = this.getIndexRowGenerator(n2);
            lArray[n2] = this.getIndexConglomerate(n2);
            ++n2;
        }
        RowChanger rowChanger = this.executionFactory.getRowChanger(this.getHeapConglomerate(), null, null, indexRowGeneratorArray, lArray, null, null, this.crf.getHeapColumnCount(), transactionController, nArray, this.getStreamStorableHeapColIds(execRow), null);
        return rowChanger;
    }

    private int[] getStreamStorableHeapColIds(ExecRow execRow) throws StandardException {
        if (!this.computedStreamStorableHeapColIds) {
            int n = 0;
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            int n2 = 0;
            while (n2 < dataValueDescriptorArray.length) {
                if (dataValueDescriptorArray[n2] instanceof StreamStorable) {
                    ++n;
                }
                ++n2;
            }
            if (n > 0) {
                this.streamStorableHeapColIds = new int[n];
                n2 = 0;
                int n3 = 0;
                while (n3 < dataValueDescriptorArray.length) {
                    if (dataValueDescriptorArray[n3] instanceof StreamStorable) {
                        this.streamStorableHeapColIds[n2++] = n3;
                    }
                    ++n3;
                }
            }
            this.computedStreamStorableHeapColIds = true;
        }
        return this.streamStorableHeapColIds;
    }

    private ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    public String toString() {
        return "";
    }

    public TabInfoImpl(CatalogRowFactory catalogRowFactory) {
        this.name = catalogRowFactory.getCatalogName();
        this.heapConglomerate = -1L;
        this.crf = catalogRowFactory;
        this.executionFactory = catalogRowFactory.getExecutionFactory();
        int n = catalogRowFactory.getNumIndexes();
        if (n > 0) {
            this.indexes = new IndexInfoImpl[n];
            int n2 = 0;
            while (n2 < n) {
                this.indexes[n2] = new IndexInfoImpl(-1L, catalogRowFactory.getIndexName(n2), catalogRowFactory.getIndexColumnCount(n2), catalogRowFactory.isIndexUnique(n2), n2, catalogRowFactory);
                ++n2;
            }
        }
    }
}

