/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromList
extends QueryTreeNodeVector
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;

    public void init(Object object) {
        this.fixedJoinOrder = (Boolean)object == false;
    }

    public void init(Object object, Object object2) throws StandardException {
        this.init(object);
        this.addFromTable((FromTable)object2);
    }

    public Optimizable getOptimizable(int n) {
        return (Optimizable)((Object)this.elementAt(n));
    }

    public void setOptimizable(int n, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, n);
    }

    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((Optimizable)((Object)this.elementAt(n2))).verifyProperties(dataDictionary);
            ++n2;
        }
    }

    public void addFromTable(FromTable fromTable) throws StandardException {
        if (!(fromTable instanceof TableOperatorNode)) {
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                if (fromTable.getExposedName().equals(((FromTable)this.elementAt(n2)).getExposedName())) {
                    throw StandardException.newException("42X09", fromTable.getExposedName());
                }
                ++n2;
            }
        }
        this.addElement(fromTable);
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        boolean bl2 = false;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            if (fromTable.referencesTarget(string, bl)) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        return bl2;
    }

    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            if (fromTable.referencesSessionSchema()) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        boolean bl2 = false;
        FromTable fromTable = null;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable2 = (FromTable)this.elementAt(n2);
            fromTable = fromTable2.getFromTableByName(string, string2, bl);
            if (fromTable != null) {
                return fromTable;
            }
            ++n2;
        }
        return fromTable;
    }

    public void bindTables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        FromTable fromTable;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            fromTable = (FromTable)this.elementAt(n2);
            this.setElementAt(fromTable.bindNonVTITables(dataDictionary, fromList), n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            fromTable = (FromTable)this.elementAt(n2);
            this.setElementAt(fromTable.bindVTITables(fromList), n2);
            ++n2;
        }
    }

    public void bindExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.bindExpressions(this);
            ++n2;
        }
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        int n = fromList.size();
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            FromTable fromTable = (FromTable)this.elementAt(n3);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromList);
            }
            fromList.insertElementAt(fromTable, 0);
            ++n3;
        }
        while (fromList.size() > n) {
            fromList.removeElementAt(0);
        }
    }

    public boolean hasOuterJoins() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            if (fromTable instanceof HalfOuterJoinNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ResultColumnList expandAll(String string) throws StandardException {
        ResultColumnList resultColumnList = null;
        ResultColumnList resultColumnList2 = null;
        boolean bl = false;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.setAllColumnsProjected(true);
            resultColumnList2 = fromTable.getAllResultColumns(string);
            if (resultColumnList2 != null) {
                if (resultColumnList == null) {
                    resultColumnList = resultColumnList2;
                } else {
                    resultColumnList.nondestructiveAppend(resultColumnList2);
                }
                if (string != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (resultColumnList == null) {
            throw StandardException.newException("42X10", string);
        }
        return resultColumnList;
    }

    public ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        int n3 = this.size();
        int n4 = 0;
        while (n4 < n3) {
            FromTable fromTable = (FromTable)this.elementAt(n4);
            n = fromTable.getLevel();
            if (n2 != n && (bl || bl2)) break;
            n2 = n;
            ResultColumn resultColumn2 = fromTable.getMatchingColumn(columnReference);
            if (resultColumn2 != null) {
                if (!bl) {
                    resultColumn = resultColumn2;
                    columnReference.setSource(resultColumn2);
                    columnReference.setType(resultColumn2.getTypeServices());
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(n);
                    bl = true;
                } else {
                    throw StandardException.newException("42X03", columnReference.getFullColumnName());
                }
            }
            bl2 = bl2 || string != null && string.equals(fromTable.getExposedName());
            ++n4;
        }
        return resultColumn;
    }

    public void rejectParameters() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.rejectParameters();
            ++n2;
        }
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        boolean bl = false;
        if (this.size() > 1) {
            return bl;
        }
        FromTable fromTable = (FromTable)this.elementAt(0);
        bl = fromTable.LOJ_reorderable(n);
        return bl;
    }

    public void preprocess(int n, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            FromTable fromTable = (FromTable)this.elementAt(n3);
            fromTable = fromTable.transformOuterJoins(valueNode, n);
            this.setElementAt(fromTable.preprocess(n, groupByList, this), n3);
            ++n3;
        }
    }

    public void flattenFromTables(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList) throws StandardException {
        QueryTreeNode queryTreeNode;
        FromTable fromTable;
        int n;
        boolean bl = true;
        Vector<Integer> vector = new Vector<Integer>();
        while (bl) {
            bl = false;
            n = 0;
            while (n < this.size() && !bl) {
                fromTable = (FromTable)this.elementAt(n);
                if (fromTable instanceof FromSubquery || fromTable.isFlattenableJoinNode()) {
                    vector.addElement(new Integer(fromTable.getTableNumber()));
                    queryTreeNode = fromTable.flatten(resultColumnList, predicateList, subqueryList, groupByList);
                    if (queryTreeNode != null) {
                        this.setElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(0), n);
                        int n2 = ((QueryTreeNodeVector)queryTreeNode).size();
                        int n3 = 1;
                        while (n3 < n2) {
                            this.insertElementAt(((QueryTreeNodeVector)queryTreeNode).elementAt(n3), n + n3);
                            ++n3;
                        }
                    } else {
                        this.removeElementAt(n);
                    }
                    bl = true;
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            n = 0;
            while (n < this.size()) {
                fromTable = (FromTable)this.elementAt(n);
                if (fromTable instanceof ProjectRestrictNode && (queryTreeNode = ((ProjectRestrictNode)fromTable).getChildResult()) instanceof FromBaseTable) {
                    ((FromBaseTable)queryTreeNode).clearDependency(vector);
                }
                ++n;
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        predicateList.categorize();
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.pushExpressions(predicateList);
            ++n2;
        }
    }

    public void printSubNodes(int n) {
    }

    public void setLevel(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            FromTable fromTable = (FromTable)this.elementAt(n3);
            fromTable.setLevel(n);
            ++n3;
        }
    }

    void markStatementResultSet() {
        ((FromTable)this.elementAt(0)).markStatementResultSet();
    }

    public FromTable getFromTableByResultColumn(ResultColumn resultColumn) {
        FromTable fromTable = null;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            fromTable = (FromTable)this.elementAt(n2);
            if (fromTable.getResultColumns().indexOf(resultColumn) != -1) break;
            ++n2;
        }
        return fromTable;
    }

    public void setProperties(Properties properties) throws StandardException {
        this.properties = properties;
        Enumeration enumeration = ((Hashtable)this.properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)((Hashtable)this.properties).get(string);
            if (string.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException("42X17", string2);
            }
            if (string.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(string2, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException("42X64", string2);
            }
            throw StandardException.newException("42X41", string, (Object)string2);
        }
    }

    public void reOrder(int[] nArray) {
        FromTable[] fromTableArray = new FromTable[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            fromTableArray[n] = this.elementAt(nArray[n]);
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this.setElementAt(fromTableArray[n], n);
            ++n;
        }
    }

    public boolean useStatistics() {
        return this.useStatistics;
    }

    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    public boolean legalJoinOrder(int n) {
        JBitSet jBitSet = new JBitSet(n);
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            FromTable fromTable = (FromTable)this.elementAt(n3);
            jBitSet.or(fromTable.getReferencedTableMap());
            if (!fromTable.legalJoinOrder(jBitSet)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void initAccessPaths(Optimizer optimizer) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.initAccessPaths(optimizer);
            ++n2;
        }
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            fromTable.bindUntypedNullsToResultColumns(resultColumnList);
            ++n2;
        }
    }

    void decrementLevel(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            FromTable fromTable = (FromTable)this.elementAt(n3);
            fromTable.decrementLevel(n);
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)fromTable;
            PredicateList predicateList = projectRestrictNode.getRestrictionList();
            if (predicateList != null) {
                predicateList.decrementLevel(this, n);
            }
            ++n3;
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList resultColumnList, ValueNode valueNode, PredicateList predicateList, DataDictionary dataDictionary) throws StandardException {
        Object object;
        ResultColumn resultColumn;
        boolean bl = false;
        ColumnReference columnReference = null;
        if (resultColumnList != null && (resultColumn = (ResultColumn)resultColumnList.elementAt(0)).getExpression() instanceof ColumnReference) {
            columnReference = (ColumnReference)resultColumn.getExpression();
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            object = (FromTable)this.elementAt(n2);
            if (!(object instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)object;
            if (!(projectRestrictNode.getChildResult() instanceof FromBaseTable)) {
                return false;
            }
            ++n2;
        }
        int[] nArray = this.getTableNumbers();
        JBitSet[][] jBitSetArray = new JBitSet[n][n];
        object = new boolean[n];
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(n3);
            FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
            if (fromBaseTable.getExistsBaseTable()) {
                object[n3] = true;
            } else {
                int n4 = fromBaseTable.getTableDescriptor().getNumberOfColumns();
                boolean[] blArray = new boolean[n4 + 1];
                int n5 = fromBaseTable.getTableNumber();
                boolean bl3 = false;
                int n6 = 0;
                while (n6 < n) {
                    jBitSetArray[n3][n6] = new JBitSet(n4 + 1);
                    ++n6;
                }
                if (columnReference != null && columnReference.getTableNumber() == n5) {
                    resultColumnList.recordColumnReferences(blArray, jBitSetArray[n3], n3);
                    bl3 = true;
                }
                if (valueNode != null) {
                    valueNode.checkTopPredicatesForEqualsConditions(n5, blArray, nArray, jBitSetArray[n3], bl3);
                }
                predicateList.checkTopPredicatesForEqualsConditions(n5, blArray, nArray, jBitSetArray[n3], bl3);
                if (projectRestrictNode.getRestrictionList() != null) {
                    projectRestrictNode.getRestrictionList().checkTopPredicatesForEqualsConditions(n5, blArray, nArray, jBitSetArray[n3], bl3);
                }
                if (!fromBaseTable.supersetOfUniqueIndex(jBitSetArray[n3])) {
                    return false;
                }
                bl2 = fromBaseTable.supersetOfUniqueIndex(blArray);
                if (bl2) {
                    object[n3] = true;
                    bl = true;
                }
            }
            ++n3;
        }
        if (bl) {
            n3 = 1;
            while (n3 != 0) {
                n3 = 0;
                int n7 = 0;
                while (n7 < n) {
                    if (object[n7] != false) {
                        int n8 = 0;
                        while (n8 < n) {
                            if (object[n8] == false && jBitSetArray[n8][n7].get(0)) {
                                object[n8] = true;
                                n3 = 1;
                            }
                            ++n8;
                        }
                    }
                    ++n7;
                }
            }
            int n9 = 0;
            while (n9 < n) {
                if (object[n9] == false) {
                    bl = false;
                    break;
                }
                ++n9;
            }
        }
        return bl;
    }

    int[] getTableNumbers() {
        int n = this.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ProjectRestrictNode projectRestrictNode = (ProjectRestrictNode)this.elementAt(n2);
            if (projectRestrictNode.getChildResult() instanceof FromTable) {
                FromTable fromTable = (FromTable)projectRestrictNode.getChildResult();
                nArray[n2] = fromTable.getTableNumber();
            }
            ++n2;
        }
        return nArray;
    }

    void genExistsBaseTables(JBitSet jBitSet, FromList fromList, boolean bl) throws StandardException {
        ResultSetNode resultSetNode;
        JBitSet jBitSet2 = (JBitSet)jBitSet.clone();
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            resultSetNode = ((ProjectRestrictNode)this.elementAt(n2)).getChildResult();
            if (resultSetNode instanceof FromTable) {
                jBitSet2.clear(((FromTable)resultSetNode).getTableNumber());
            }
            ++n2;
        }
        if (jBitSet2.getFirstSetBit() == -1) {
            n2 = fromList.size();
            int n3 = 0;
            while (n3 < n2) {
                jBitSet2.or(((FromTable)fromList.elementAt(n3)).getReferencedTableMap());
                ++n3;
            }
        }
        n2 = 0;
        while (n2 < n) {
            ProjectRestrictNode projectRestrictNode;
            resultSetNode = (FromTable)this.elementAt(n2);
            if (resultSetNode instanceof ProjectRestrictNode && (projectRestrictNode = (ProjectRestrictNode)resultSetNode).getChildResult() instanceof FromBaseTable) {
                FromBaseTable fromBaseTable = (FromBaseTable)projectRestrictNode.getChildResult();
                fromBaseTable.setExistsBaseTable(true, (JBitSet)jBitSet2.clone(), bl);
            }
            ++n2;
        }
    }

    public int updateTargetLockMode() {
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            String string = fromTable.getUserSpecifiedJoinStrategy();
            if (string != null && StringUtil.SQLToUpperCase(string).equals("HASH")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            FromTable fromTable = (FromTable)this.elementAt(n2);
            this.setElementAt((QueryTreeNode)fromTable.accept(visitor), n2);
            ++n2;
        }
        return this;
    }
}

