/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;

public class GroupByNode
extends SingleChildResultSetNode {
    GroupByList groupingList;
    Vector aggregateVector;
    private AggregatorInfoList aggInfo;
    FromTable parent;
    private boolean addDistinctAggregate;
    private boolean singleInputRowOptimization;
    private int addDistinctAggregateColumnNum;
    private boolean isInSortedOrder;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$ColumnReference;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$AggregateNode;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$store$access$ColumnOrdering;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object, object4);
        this.groupingList = (GroupByList)object2;
        this.aggregateVector = (Vector)object3;
        this.parent = this;
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(resultColumnList);
        this.addAggregates();
        if (!this.addDistinctAggregate && object2 != null) {
            ColumnReference[] columnReferenceArray = new ColumnReference[this.groupingList.size()];
            int n = this.groupingList.size();
            int n2 = 0;
            while (n2 < n) {
                GroupByColumn groupByColumn = (GroupByColumn)this.groupingList.elementAt(n2);
                columnReferenceArray[n2] = groupByColumn.getColumnReference();
                ++n2;
            }
            this.isInSortedOrder = this.childResult.isOrderedOn(columnReferenceArray, true, null);
        }
    }

    boolean getIsInSortedOrder() {
        return this.isInSortedOrder;
    }

    private void addAggregates() throws StandardException {
        this.addNewPRNode();
        this.addNewColumnsForAggregation();
        this.addDistinctAggregatesToOrderBy();
    }

    private void addDistinctAggregatesToOrderBy() {
        int n = ResultSetNode.numDistinctAggregates(this.aggregateVector);
        if (n != 0) {
            AggregatorInfo aggregatorInfo = null;
            int n2 = this.aggInfo.size();
            int n3 = 0;
            while (n3 < n2) {
                aggregatorInfo = (AggregatorInfo)this.aggInfo.elementAt(n3);
                if (aggregatorInfo.isDistinct()) break;
                ++n3;
            }
            this.addDistinctAggregate = true;
            this.addDistinctAggregateColumnNum = aggregatorInfo.getInputColNum();
        }
    }

    private void addNewPRNode() throws StandardException {
        this.parent = (FromTable)this.getNodeFactory().getNode(151, this, this.resultColumns, null, null, null, null, this.tableProperties, this.getContextManager());
        this.childResult.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
    }

    private void addNewColumnsForAggregation() throws StandardException {
        ResultColumn resultColumn;
        ColumnReference columnReference;
        AggregateNode aggregateNode = null;
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.resultColumns;
        LanguageFactory languageFactory = this.getLanguageConnectionContext().getLanguageFactory();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.aggInfo = new AggregatorInfoList();
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$Lorg$apache$derby$impl$sql$compile$ColumnReference != null ? class$Lorg$apache$derby$impl$sql$compile$ColumnReference : (class$Lorg$apache$derby$impl$sql$compile$ColumnReference = GroupByNode.class$("org.apache.derby.impl.sql.compile.ColumnReference")), class$Lorg$apache$derby$impl$sql$compile$AggregateNode != null ? class$Lorg$apache$derby$impl$sql$compile$AggregateNode : (class$Lorg$apache$derby$impl$sql$compile$AggregateNode = GroupByNode.class$("org.apache.derby.impl.sql.compile.AggregateNode")));
        this.parent.getResultColumns().accept(collectNodesVisitor);
        Vector vector = collectNodesVisitor.getList();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            GroupByColumn groupByColumn;
            ColumnReference columnReference2 = (ColumnReference)vector.elementAt(n2);
            columnReference = (ColumnReference)columnReference2.getClone();
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##UnaggColumn", columnReference, this.getContextManager());
            resultColumn.setExpression(columnReference);
            resultColumnList.addElement(resultColumn);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumn.setVirtualColumnId(resultColumnList.size());
            if (this.groupingList != null && (groupByColumn = this.groupingList.containsColumnReference(columnReference)) != null) {
                groupByColumn.setColumnPosition(resultColumnList.size());
            }
            ResultColumn resultColumn2 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            columnReference2.setSource(resultColumn2);
            ++n2;
        }
        ReplaceAggregatesWithCRVisitor replaceAggregatesWithCRVisitor = new ReplaceAggregatesWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber());
        this.parent.getResultColumns().accept(replaceAggregatesWithCRVisitor);
        int n3 = this.aggregateVector.size();
        int n4 = 0;
        while (n4 < n3) {
            aggregateNode = (AggregateNode)this.aggregateVector.elementAt(n4);
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate result", aggregateNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n5 = resultColumn.getVirtualColumnId();
            columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), null, this.getContextManager());
            columnReference.setSource(resultColumn);
            columnReference.setType(resultColumn.getExpressionType());
            columnReference.setNestingLevel(this.getLevel());
            columnReference.setSourceLevel(this.getLevel());
            ResultColumn resultColumn3 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.getColumnName(), columnReference, this.getContextManager());
            resultColumn3.markGenerated();
            resultColumn3.bindResultColumnToExpression();
            resultColumnList2.addElement(resultColumn3);
            resultColumn3.setVirtualColumnId(resultColumnList2.size());
            columnReference = aggregateNode.getGeneratedRef();
            columnReference.setSource(resultColumn3);
            resultColumn = aggregateNode.getNewExpressionResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n6 = resultColumn.getVirtualColumnId();
            ResultColumn resultColumn4 = resultColumn;
            resultColumn3 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn3);
            resultColumn3.setVirtualColumnId(resultColumnList2.size());
            resultColumn = aggregateNode.getNewAggregatorResultColumn(dataDictionary);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n7 = resultColumn.getVirtualColumnId();
            resultColumn3 = this.getColumnReference(resultColumn, dataDictionary);
            resultColumnList2.addElement(resultColumn3);
            resultColumn3.setVirtualColumnId(resultColumnList2.size());
            ResultColumnList resultColumnList3 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            resultColumnList3.addElement(resultColumn4);
            this.aggInfo.addElement(new AggregatorInfo(aggregateNode.getAggregateName(), aggregateNode.getAggregatorClassName(), n6 - 1, n5 - 1, n7 - 1, aggregateNode.isDistinct(), languageFactory.getResultDescription(resultColumnList3.makeResultDescriptors(), "SELECT")));
            ++n4;
        }
    }

    public FromTable getParent() {
        return this.parent;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        CostEstimate costEstimate3 = super.optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        return costEstimate3;
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizer, rowOrdering);
        CostEstimate costEstimate3 = this.getCostEstimate(optimizer);
        costEstimate3.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.singleScanRowCount());
        return costEstimate3;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return ((Optimizable)((Object)this.childResult)).pushOptPredicate(optimizablePredicate);
    }

    public String toString() {
        return "";
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = (FromTable)this.childResult.optimize(dataDictionary, predicateList, d);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    ResultColumnDescriptor[] makeResultDescriptors(ExecutionContext executionContext) {
        return this.childResult.makeResultDescriptors(executionContext);
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.groupingList == null || this.groupingList.size() == 0;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = 0;
        int n2 = 0;
        this.assignResultSetNumber();
        if (this.costEstimate == null) {
            this.costEstimate = this.childResult.getFinalCostEstimate();
        }
        FormatableArrayHolder formatableArrayHolder = activationClassBuilder.getColumnOrdering(this.groupingList);
        if (this.addDistinctAggregate) {
            formatableArrayHolder = activationClassBuilder.addColumnToOrdering(formatableArrayHolder, this.addDistinctAggregateColumnNum);
        }
        n = activationClassBuilder.addItem(formatableArrayHolder);
        n2 = activationClassBuilder.addItem(this.aggInfo);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.isInSortedOrder);
        methodBuilder.push(n2);
        methodBuilder.push(n);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.resultColumns.getTotalColumnSize());
        methodBuilder.push(this.resultSetNumber);
        if (this.groupingList == null || this.groupingList.size() == 0) {
            this.genScalarAggregateResultSet(activationClassBuilder, methodBuilder);
        } else {
            this.genGroupedAggregateResultSet(activationClassBuilder, methodBuilder);
        }
    }

    private void genScalarAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) {
        String string = this.addDistinctAggregate ? "getDistinctScalarAggregateResultSet" : "getScalarAggregateResultSet";
        methodBuilder.push(this.singleInputRowOptimization);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        this.closeMethodArgument(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 12);
    }

    private void genGroupedAggregateResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.addDistinctAggregate ? "getDistinctGroupedAggregateResultSet" : "getGroupedAggregateResultSet";
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        this.closeMethodArgument(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 11);
    }

    private ResultColumn getColumnReference(ResultColumn resultColumn, DataDictionary dataDictionary) throws StandardException {
        ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), null, this.getContextManager());
        columnReference.setSource(resultColumn);
        columnReference.setType(resultColumn.getExpressionType());
        columnReference.setNestingLevel(this.getLevel());
        columnReference.setSourceLevel(this.getLevel());
        ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.getColumnName(), columnReference, this.getContextManager());
        resultColumn2.markGenerated();
        resultColumn2.bindResultColumnToExpression();
        return resultColumn2;
    }

    void considerPostOptimizeOptimizations(boolean bl) throws StandardException {
        AggregateNode aggregateNode;
        AggregateDefinition aggregateDefinition;
        if (this.groupingList == null && this.aggregateVector.size() == 1 && (aggregateDefinition = (aggregateNode = (AggregateNode)this.aggregateVector.elementAt(0)).getAggregateDefinition()) instanceof MaxMinAggregateDefinition) {
            if (aggregateNode.getOperand() instanceof ColumnReference) {
                Vector vector;
                ColumnReference[] columnReferenceArray = new ColumnReference[]{(ColumnReference)aggregateNode.getOperand()};
                boolean bl2 = this.isOrderedOn(columnReferenceArray, false, vector = new Vector());
                if (bl2) {
                    boolean bl3 = true;
                    int n = columnReferenceArray[0].getColumnNumber();
                    AccessPath accessPath = this.getTrulyTheBestAccessPath();
                    if (accessPath == null) {
                        return;
                    }
                    IndexRowGenerator indexRowGenerator = accessPath.getConglomerateDescriptor().getIndexDescriptor();
                    int[] nArray = indexRowGenerator.baseColumnPositions();
                    boolean[] blArray = indexRowGenerator.isAscending();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        if (n == nArray[n2]) {
                            if (blArray[n2]) break;
                            bl3 = false;
                            break;
                        }
                        ++n2;
                    }
                    FromBaseTable fromBaseTable = (FromBaseTable)vector.firstElement();
                    MaxMinAggregateDefinition maxMinAggregateDefinition = (MaxMinAggregateDefinition)aggregateDefinition;
                    if (!maxMinAggregateDefinition.isMax() && bl3 || maxMinAggregateDefinition.isMax() && !bl3) {
                        fromBaseTable.disableBulkFetch();
                        this.singleInputRowOptimization = true;
                    } else if (!bl && (maxMinAggregateDefinition.isMax() && bl3 || !maxMinAggregateDefinition.isMax() && !bl3)) {
                        fromBaseTable.disableBulkFetch();
                        fromBaseTable.doSpecialMaxScan();
                        this.singleInputRowOptimization = true;
                    }
                }
            } else if (aggregateNode.getOperand() instanceof ConstantNode) {
                this.singleInputRowOptimization = true;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

