/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;

class RowOrderingImpl
implements RowOrdering {
    Vector ordering = new Vector();
    ColumnOrdering columnsAlwaysOrdered;
    Vector alwaysOrderedOptimizables;
    ColumnOrdering currentColumnOrdering;
    Vector unorderedOptimizables = new Vector();

    public boolean orderedOnColumn(int n, int n2, int n3, int n4) throws StandardException {
        if (this.vectorContainsOptimizable(n3, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n3, n4)) {
            return true;
        }
        if (n2 >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n2);
        return columnOrdering.ordered(n, n3, n4);
    }

    public boolean orderedOnColumn(int n, int n2, int n3) throws StandardException {
        if (this.vectorContainsOptimizable(n2, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n2, n3)) {
            return true;
        }
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.ordering.size()) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n4);
            boolean bl2 = columnOrdering.ordered(n, n2, n3);
            if (bl2) {
                bl = true;
                break;
            }
            ++n4;
        }
        return bl;
    }

    private boolean vectorContainsOptimizable(int n, Vector vector) {
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            Optimizable optimizable = (Optimizable)vector.elementAt(n2);
            if (optimizable.hasTableNumber() && optimizable.getTableNumber() == n) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public void addOrderedColumn(int n, int n2, int n3) {
        ColumnOrdering columnOrdering;
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        if (this.ordering.size() == 0) {
            columnOrdering = new ColumnOrdering(n);
            this.ordering.addElement(columnOrdering);
        } else {
            columnOrdering = (ColumnOrdering)this.ordering.elementAt(this.ordering.size() - 1);
        }
        columnOrdering.addColumn(n2, n3);
    }

    public void nextOrderPosition(int n) {
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(n);
        this.ordering.addElement(this.currentColumnOrdering);
    }

    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int n;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean bl = optimizable.hasTableNumber();
        int n2 = n = bl ? optimizable.getTableNumber() : 0;
        if ((this.ordering.size() == 0 || bl && ((ColumnOrdering)this.ordering.elementAt(0)).hasTable(n)) && bl && !this.columnsAlwaysOrdered.hasAnyOtherTable(n)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.addElement(optimizable);
        }
    }

    public void columnAlwaysOrdered(Optimizable optimizable, int n) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), n);
    }

    public boolean alwaysOrdered(int n) {
        return this.vectorContainsOptimizable(n, this.alwaysOrderedOptimizables);
    }

    public void removeOptimizable(int n) {
        int n2 = this.ordering.size() - 1;
        while (n2 >= 0) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n2);
            columnOrdering.removeColumns(n);
            if (columnOrdering.empty()) {
                this.ordering.removeElementAt(n2);
            }
            --n2;
        }
        this.columnsAlwaysOrdered.removeColumns(n);
        this.removeOptimizableFromVector(n, this.unorderedOptimizables);
        this.removeOptimizableFromVector(n, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizableFromVector(int n, Vector vector) {
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            Optimizable optimizable = (Optimizable)vector.elementAt(n2);
            if (optimizable.hasTableNumber() && optimizable.getTableNumber() == n) {
                vector.removeElementAt(n2);
            }
            --n2;
        }
    }

    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.addElement(optimizable);
    }

    public void copy(RowOrdering rowOrdering) {
        RowOrderingImpl rowOrderingImpl = (RowOrderingImpl)rowOrdering;
        rowOrderingImpl.ordering.removeAllElements();
        rowOrderingImpl.currentColumnOrdering = null;
        rowOrderingImpl.unorderedOptimizables.removeAllElements();
        int n = 0;
        while (n < this.unorderedOptimizables.size()) {
            rowOrderingImpl.unorderedOptimizables.addElement(this.unorderedOptimizables.elementAt(n));
            ++n;
        }
        rowOrderingImpl.alwaysOrderedOptimizables.removeAllElements();
        n = 0;
        while (n < this.alwaysOrderedOptimizables.size()) {
            rowOrderingImpl.alwaysOrderedOptimizables.addElement(this.alwaysOrderedOptimizables.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < this.ordering.size()) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n);
            rowOrderingImpl.ordering.addElement(columnOrdering.cloneMe());
            if (columnOrdering == this.currentColumnOrdering) {
                rowOrderingImpl.rememberCurrentColumnOrdering(n);
            }
            ++n;
        }
        rowOrderingImpl.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            rowOrderingImpl.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int n) {
        this.currentColumnOrdering = (ColumnOrdering)this.ordering.elementAt(n);
    }

    public String toString() {
        String string = null;
        return string;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        int n = 0;
        while (n < this.unorderedOptimizables.size()) {
            Optimizable optimizable2 = (Optimizable)this.unorderedOptimizables.elementAt(n);
            if (optimizable2 != optimizable) {
                return true;
            }
            ++n;
        }
        return false;
    }

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
        this.alwaysOrderedOptimizables = new Vector();
    }
}

