/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;

public class UnionNode
extends TableOperatorNode {
    boolean all;
    boolean tableConstructor;
    boolean topTableConstructor;
    private boolean addNewNodesCalled;
    private OrderByList orderByList;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        super.init(object, object2, object5);
        this.all = (Boolean)object3;
        this.tableConstructor = (Boolean)object4;
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
    }

    public void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    public void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        if (this.tableConstructor()) {
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof UnionNode) {
                UnionNode unionNode = resultSetNode;
                ((RowResultSetNode)unionNode.rightResultSet).setTableConstructorTypes(resultColumnList);
                resultSetNode = unionNode.leftResultSet;
            }
            ((RowResultSetNode)resultSetNode).setTableConstructorTypes(resultColumnList);
        }
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, null, costEstimate);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, null, costEstimate);
        CostEstimate costEstimate2 = this.getCostEstimate(optimizer);
        costEstimate2.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEstimate2.add(this.rightResultSet.costEstimate, costEstimate2);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, costEstimate2);
        optimizer.considerCost(this, optimizablePredicateList, costEstimate2, costEstimate);
        return costEstimate2;
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        Optimizable optimizable = super.modifyAccessPath(jBitSet);
        if (this.addNewNodesCalled) {
            return optimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return resultSetNode;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        ResultSetNode resultSetNode = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                resultSetNode = this.genNormalizeResultSetNode(this, false);
            }
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(124, resultSetNode.genProjectRestrict(), Boolean.FALSE, this.tableProperties, this.getContextManager());
            ((FromTable)resultSetNode).setTableNumber(this.tableNumber);
            resultSetNode.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
            this.all = true;
        }
        if (this.orderByList != null) {
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return resultSetNode;
    }

    public String toString() {
        return "";
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        super.bindExpressions(fromList);
        if (this.topTableConstructor && !this.insertSource) {
            RowResultSetNode rowResultSetNode;
            UnionNode unionNode;
            DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int n = 0;
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof UnionNode) {
                unionNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)unionNode.rightResultSet;
                n += this.getParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = unionNode.leftResultSet;
            }
            if ((n += this.getParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode)) < dataTypeDescriptorArray.length) {
                throw StandardException.newException("42Y10");
            }
            resultSetNode = this;
            while (resultSetNode instanceof UnionNode) {
                unionNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)unionNode.rightResultSet;
                this.setParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = unionNode.leftResultSet;
            }
            this.setParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode);
        }
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        super.bindResultColumns(fromList);
        this.buildRCL();
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().size() != this.rightResultSet.getResultColumns().size()) {
            throw StandardException.newException("42X58");
        }
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
        this.resultColumns.setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            ResultColumnList resultColumnList2 = this.rightResultSet.getResultColumns();
            ResultColumnList resultColumnList3 = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList3);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList2);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    int getParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) {
        int n = 0;
        int n2 = 0;
        while (n2 < dataTypeDescriptorArray.length) {
            ResultColumn resultColumn;
            if (dataTypeDescriptorArray[n2] == null && !(resultColumn = (ResultColumn)rowResultSetNode.getResultColumns().elementAt(n2)).getExpression().isParameterNode()) {
                dataTypeDescriptorArray[n2] = resultColumn.getExpressionType();
                ++n;
            }
            ++n2;
        }
        return n;
    }

    void setParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) throws StandardException {
        ResultColumnList resultColumnList = rowResultSetNode.getResultColumns();
        int n = resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            if (resultColumn.getExpression().isParameterNode()) {
                ((ParameterNode)resultColumn.getExpression()).setDescriptor(dataTypeDescriptorArray[n2]);
            }
            ++n2;
        }
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromList);
        this.rightResultSet.bindTargetExpressions(fromList);
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        UnionNode unionNode = this;
        this.leftResultSet = this.leftResultSet.preprocess(n, groupByList, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(n, groupByList, fromList);
        this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
        this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        if (!this.all && this.orderByList != null && this.orderByList.allAscending() && this.orderByList.isInOrderPrefix(this.resultColumns)) {
            this.orderByList = null;
        }
        return unionNode;
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this.genProjectRestrict(n);
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(fromList, n);
        this.rightResultSet.verifySelectStarSubquery(fromList, n);
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.leftResultSet.getFromTableByName(string, string2, bl);
    }

    public void setResultToBooleanTrueNode(boolean bl) throws StandardException {
        super.setResultToBooleanTrueNode(bl);
        this.leftResultSet.setResultToBooleanTrueNode(bl);
        this.rightResultSet.setResultToBooleanTrueNode(bl);
    }

    public ResultSetNode enhanceRCLForInsert(int n, int[] nArray, DataDictionary dataDictionary, TableDescriptor tableDescriptor, FromVTI fromVTI) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n2 = this.resultColumns.size();
        int n3 = 0;
        while (n3 < n) {
            ResultColumn resultColumn;
            if (nArray[n3] != -1) {
                ResultColumn resultColumn2 = this.resultColumns.getResultColumn(nArray[n3] + 1);
                ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn2.getName(), null, this.getContextManager());
                columnReference.setSource(resultColumn2);
                columnReference.setType(resultColumn2.getExpressionType());
                columnReference.setNestingLevel(0);
                columnReference.setSourceLevel(0);
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn2.getType(), columnReference, this.getContextManager());
            } else {
                resultColumn = this.genNewRCForInsert(tableDescriptor, fromVTI, n3 + 1, dataDictionary);
            }
            resultColumnList.addResultColumn(resultColumn);
            ++n3;
        }
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.leftResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        this.closeMethodArgument(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getUnionResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }
}

