/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;

abstract class DMLVTIResultSet
extends DMLWriteResultSet {
    protected NoPutResultSet sourceResultSet;
    public NoPutResultSet savedSource;
    public UpdatableVTIConstantAction constants;
    public TransactionController tc;
    public LanguageConnectionContext lcc;
    public ResultDescription resultDescription;
    private int numOpens;
    protected boolean firstExecute;
    public ExecRow row;

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void open() throws StandardException {
        this.firstExecute = this.numOpens == 0;
        this.rowCount = 0;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        this.openCore();
        this.row = null;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.cleanUp();
        this.endTime = this.getCurrentTimeMillis();
    }

    protected abstract void openCore() throws StandardException;

    public void cleanUp() throws StandardException {
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        this.numOpens = 0;
        super.close();
    }

    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }

    public DMLVTIResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = noPutResultSet;
        this.constants = (UpdatableVTIConstantAction)this.constantAction;
        this.lcc = activation.getLanguageConnectionContext();
        this.tc = activation.getTransactionController();
        this.resultDescription = this.sourceResultSet.getResultDescription();
    }
}

