/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected ExecRow deferredSparseRow;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public int rowCount;

    public final int modifiedRowCount() {
        return this.rowCount;
    }

    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (this.needToObjectifyStream) {
            this.objectifyStreams(execRow);
        }
        return execRow;
    }

    private void objectifyStreams(ExecRow execRow) throws StandardException {
        if (execRow != null && this.streamStorableHeapColIds != null) {
            int n = 0;
            while (n < this.streamStorableHeapColIds.length) {
                int n2 = this.streamStorableHeapColIds[n];
                int n3 = this.baseRowReadMap == null ? n2 : this.baseRowReadMap[n2];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n3 + 1);
                ((StreamStorable)((Object)dataValueDescriptor)).loadStream();
                ++n;
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow execRow, FormatableBitSet formatableBitSet, LanguageConnectionContext languageConnectionContext) throws StandardException {
        ExecRow execRow2;
        if (formatableBitSet == null) {
            execRow2 = execRow;
        } else {
            execRow2 = RowUtil.getEmptyValueRow(formatableBitSet.getLength() - 1, languageConnectionContext);
            int n = 1;
            int n2 = 1;
            while (n2 <= execRow2.nColumns()) {
                if (formatableBitSet.isSet(n2)) {
                    execRow2.setColumn(n2, execRow.getColumn(n++));
                }
                ++n2;
            }
        }
        return execRow2;
    }

    String getIndexNameFromCID(long l) {
        return this.constantAction.getIndexNameFromCID(l);
    }

    public abstract void open() throws StandardException;

    public abstract void cleanUp() throws StandardException;

    protected DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    protected DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController transactionController = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = transactionController.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                int n = 0;
                while (n < this.constantAction.indexCIDS.length) {
                    this.indexDCOCIs[n] = transactionController.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[n]);
                    ++n;
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo(activation.getLanguageConnectionContext().getExecutionContext()) != null;
    }
}

