/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class DropTriggerConstantAction
extends DDLSingleTableConstantAction {
    private final String triggerName;
    private final SchemaDescriptor sd;

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), true);
        tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        TriggerDescriptor triggerDescriptor = dataDictionary.getTriggerDescriptor(this.triggerName, this.sd);
        if (triggerDescriptor == null) {
            throw StandardException.newException("X0X81.S", "TRIGGER", (Object)(this.sd.getSchemaName() + "." + this.triggerName));
        }
        DropTriggerConstantAction.dropTriggerDescriptor(languageConnectionContext, dependencyManager, dataDictionary, transactionController, triggerDescriptor, activation);
    }

    static void dropTriggerDescriptor(LanguageConnectionContext languageConnectionContext, DependencyManager dependencyManager, DataDictionary dataDictionary, TransactionController transactionController, TriggerDescriptor triggerDescriptor, Activation activation) throws StandardException {
        dependencyManager.invalidateFor(triggerDescriptor, 27, languageConnectionContext);
        dataDictionary.dropTriggerDescriptor(triggerDescriptor, transactionController);
        dependencyManager.clearDependencies(languageConnectionContext, triggerDescriptor);
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(triggerDescriptor.getActionId());
        dependencyManager.invalidateFor(sPSDescriptor, 27, languageConnectionContext);
        dependencyManager.clearDependencies(languageConnectionContext, sPSDescriptor);
        dataDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
        if (triggerDescriptor.getWhenClauseId() != null) {
            sPSDescriptor = dataDictionary.getSPSDescriptor(triggerDescriptor.getWhenClauseId());
            dependencyManager.invalidateFor(sPSDescriptor, 27, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, sPSDescriptor);
            dataDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
        }
    }

    public String toString() {
        return "DROP TRIGGER " + this.triggerName;
    }

    DropTriggerConstantAction(SchemaDescriptor schemaDescriptor, String string, UUID uUID) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.triggerName = string;
    }
}

