/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class RenameConstantAction
extends DDLSingleTableConstantAction {
    private String fullTableName;
    private String tableName;
    private String newTableName;
    private String oldObjectName;
    private String newObjectName;
    private UUID schemaId;
    private SchemaDescriptor sd;
    private boolean usedAlterTable;
    private int renamingWhat;

    public String toString() {
        String string = this.usedAlterTable ? "ALTER TABLE " : "RENAME ";
        switch (this.renamingWhat) {
            case 1: {
                if (this.usedAlterTable) {
                    string = string + this.fullTableName + " RENAME TO " + this.newTableName;
                    break;
                }
                string = string + " TABLE " + this.fullTableName + " TO " + this.newTableName;
                break;
            }
            case 2: {
                if (this.usedAlterTable) {
                    string = string + this.fullTableName + " RENAME " + this.oldObjectName + " TO " + this.newObjectName;
                    break;
                }
                string = string + " COLUMN " + this.fullTableName + "." + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
            case 3: {
                string = string + " INDEX " + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
        }
        return string;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        if (this.sd == null) {
            this.sd = DDLConstantAction.getAndCheckSchemaDescriptor(dataDictionary, this.schemaId, "RENAME TABLE");
        }
        long l = tableDescriptor.getHeapConglomerateId();
        this.lockTableForDDL(transactionController, l, true);
        tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        switch (this.renamingWhat) {
            case 1: {
                this.execGutsRenameTable(tableDescriptor, activation);
                break;
            }
            case 2: {
                this.execGutsRenameColumn(tableDescriptor, activation);
                break;
            }
            case 3: {
                this.execGutsRenameIndex(tableDescriptor, activation);
                break;
            }
        }
    }

    private void execGutsRenameTable(TableDescriptor tableDescriptor, Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dependencyManager.invalidateFor(tableDescriptor, 34, languageConnectionContext);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n = 0;
        while (n < constraintDescriptorList.size()) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n);
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                dependencyManager.invalidateFor(constraintDescriptor, 34, languageConnectionContext);
            }
            ++n;
        }
        dataDictionary.dropTableDescriptor(tableDescriptor, this.sd, transactionController);
        tableDescriptor.setTableName(this.newTableName);
        dataDictionary.addDescriptor(tableDescriptor, this.sd, 1, false, transactionController);
    }

    private void execGutsRenameColumn(TableDescriptor tableDescriptor, Activation activation) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        int n = 0;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        columnDescriptor = tableDescriptor.getColumnDescriptor(this.oldObjectName);
        n = columnDescriptor.getPosition();
        FormatableBitSet formatableBitSet = new FormatableBitSet(tableDescriptor.getColumnDescriptorList().size() + 1);
        formatableBitSet.set(n);
        tableDescriptor.setReferencedColumnMap(formatableBitSet);
        dependencyManager.invalidateFor(tableDescriptor, 34, languageConnectionContext);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n2 = 0;
        while (n2 < constraintDescriptorList.size()) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n2);
            int[] nArray = constraintDescriptor.getReferencedColumns();
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                if (nArray[n4] == n && constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                    dependencyManager.invalidateFor(constraintDescriptor, 34, languageConnectionContext);
                }
                ++n4;
            }
            ++n2;
        }
        dataDictionary.dropColumnDescriptor(tableDescriptor.getUUID(), this.oldObjectName, transactionController);
        columnDescriptor.setColumnName(this.newObjectName);
        dataDictionary.addDescriptor(columnDescriptor, tableDescriptor, 2, false, transactionController);
        tableDescriptor = dataDictionary.getTableDescriptor(tableDescriptor.getObjectID());
    }

    private void execGutsRenameIndex(TableDescriptor tableDescriptor, Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dependencyManager.invalidateFor(tableDescriptor, 41, languageConnectionContext);
        ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.oldObjectName, this.sd, true);
        if (conglomerateDescriptor == null) {
            throw StandardException.newException("X0X99.S", this.oldObjectName);
        }
        dataDictionary.dropConglomerateDescriptor(conglomerateDescriptor, transactionController);
        conglomerateDescriptor.setConglomerateName(this.newObjectName);
        dataDictionary.addDescriptor(conglomerateDescriptor, this.sd, 0, false, transactionController);
    }

    public String getTableName() {
        return this.tableName;
    }

    public RenameConstantAction(String string, String string2, String string3, String string4, SchemaDescriptor schemaDescriptor, UUID uUID, boolean bl, int n) {
        super(uUID);
        this.fullTableName = string;
        this.tableName = string2;
        this.sd = schemaDescriptor;
        this.usedAlterTable = bl;
        this.renamingWhat = n;
        switch (this.renamingWhat) {
            case 1: {
                this.newTableName = string4;
                this.oldObjectName = null;
                this.newObjectName = string4;
                break;
            }
            case 2: 
            case 3: {
                this.oldObjectName = string3;
                this.newObjectName = string4;
                break;
            }
        }
    }
}

