/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UpdateConstantAction;
import org.apache.derby.impl.sql.execute.ValueRow;

public class UpdateResultSet
extends DMLWriteResultSet {
    public TransactionController tc;
    public ExecRow newBaseRow;
    public ExecRow row;
    public ExecRow deferredSparseRow;
    public UpdateConstantAction constants;
    private ResultDescription resultDescription;
    private NoPutResultSet source;
    public NoPutResultSet savedSource;
    private RowChanger rowChanger;
    protected ConglomerateController deferredBaseCC;
    protected long[] deferredUniqueCIDs;
    protected boolean[] deferredUniqueCreated;
    protected ConglomerateController[] deferredUniqueCC;
    protected ScanController[] deferredUniqueScans;
    public LanguageConnectionContext lcc;
    private TemporaryRowHolderImpl deletedRowHolder;
    private TemporaryRowHolderImpl insertedRowHolder;
    private RISetChecker riChecker;
    private TriggerInfo triggerInfo;
    private TriggerEventActivator triggerActivator;
    private boolean updatingReferencedKey;
    private boolean updatingForeignKey;
    private int numOpens;
    private long heapConglom;
    private FKInfo[] fkInfoArray;
    private FormatableBitSet baseRowReadList;
    private GeneratedMethod checkGM;
    private int resultWidth;
    private int numberOfBaseColumns;
    private ExecRow deferredTempRow;
    private ExecRow deferredBaseRow;
    private ExecRow oldDeletedRow;
    private ResultDescription triggerResultDescription;
    int lockMode;
    boolean deferred;
    boolean beforeUpdateCopyRequired = false;

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void open() throws StandardException {
        this.setup();
        this.collectAffectedRows();
        if (this.deferred) {
            this.runChecker(true);
            this.fireBeforeTriggers();
            this.updateDeferredRows();
            this.rowChanger.finish();
            this.runChecker(false);
            this.fireAfterTriggers();
        } else {
            this.rowChanger.finish();
        }
        this.cleanUp();
    }

    void setup() throws StandardException {
        boolean bl = this.rowChanger == null;
        this.rowCount = 0;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        if (bl) {
            this.rowChanger = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, this.constants.changedColumnIds, this.constants.getBaseRowReadList(), this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        } else {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        this.rowChanger.open(this.lockMode);
        if (this.numOpens++ == 0) {
            this.source.openCore();
        } else {
            this.source.reopenCore();
        }
        if (this.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.riChecker == null) {
                this.riChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.riChecker.reopen();
            }
        }
        if (this.deferred) {
            if (bl) {
                this.deferredTempRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns + 1, this.lcc);
                this.oldDeletedRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                this.triggerResultDescription = this.resultDescription != null ? this.resultDescription.truncateColumns(this.numberOfBaseColumns + 1) : null;
            }
            Properties properties = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            if (this.beforeUpdateCopyRequired) {
                this.deletedRowHolder = new TemporaryRowHolderImpl(this.tc, properties, this.triggerResultDescription);
            }
            this.insertedRowHolder = new TemporaryRowHolderImpl(this.tc, properties, this.triggerResultDescription);
            this.rowChanger.setRowHolder(this.insertedRowHolder);
        }
    }

    private FormatableBitSet checkStreamCols() {
        DataValueDescriptor[] dataValueDescriptorArray = this.row.getRowArray();
        FormatableBitSet formatableBitSet = null;
        int n = 0;
        while (n < this.numberOfBaseColumns) {
            if (dataValueDescriptorArray[n + this.numberOfBaseColumns] instanceof StreamStorable) {
                if (formatableBitSet == null) {
                    formatableBitSet = new FormatableBitSet(this.numberOfBaseColumns);
                }
                formatableBitSet.set(n);
            }
            ++n;
        }
        return formatableBitSet;
    }

    private void objectifyStream(ExecRow execRow, FormatableBitSet formatableBitSet) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        int n = 0;
        while (n < this.numberOfBaseColumns) {
            if (dataValueDescriptorArray[n] != null && formatableBitSet.get(n)) {
                ((StreamStorable)((Object)dataValueDescriptorArray[n])).loadStream();
            }
            ++n;
        }
    }

    public boolean collectAffectedRows() throws StandardException {
        boolean bl = false;
        this.row = this.getNextRowCore(this.source);
        if (this.row != null) {
            bl = true;
        } else {
            this.activation.addWarning(StandardException.newWarning("02000"));
        }
        TableScanResultSet tableScanResultSet = (TableScanResultSet)this.activation.getForUpdateIndexScan();
        boolean bl2 = tableScanResultSet != null && !tableScanResultSet.sourceDrained;
        boolean bl3 = this.deferred && bl && !this.constants.singleRowSource;
        FormatableBitSet formatableBitSet = bl3 ? this.checkStreamCols() : null;
        bl3 = formatableBitSet != null;
        while (this.row != null) {
            if (this.deferred) {
                if (this.triggerInfo == null) {
                    NoRowsResultSetImpl.evaluateCheckConstraints(this.checkGM, this.activation);
                }
                RowUtil.copyRefColumns(this.deferredTempRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns + 1);
                if (bl3) {
                    this.objectifyStream(this.deferredTempRow, formatableBitSet);
                }
                this.insertedRowHolder.insert(this.deferredTempRow);
                if (this.beforeUpdateCopyRequired) {
                    RowUtil.copyRefColumns(this.oldDeletedRow, this.row, this.numberOfBaseColumns);
                    this.deletedRowHolder.insert(this.oldDeletedRow);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                NoRowsResultSetImpl.evaluateCheckConstraints(this.checkGM, this.activation);
                RowLocation rowLocation = (RowLocation)this.row.getColumn(this.resultWidth).getObject();
                RowUtil.copyRefColumns(this.newBaseRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns);
                if (this.riChecker != null) {
                    this.riChecker.doFKCheck(this.newBaseRow);
                }
                this.rowChanger.updateRow(this.row, this.newBaseRow, rowLocation);
                if (bl2) {
                    this.notifyForUpdateCursor(this.row.getRowArray(), this.newBaseRow.getRowArray(), rowLocation, tableScanResultSet);
                }
            }
            ++this.rowCount;
            this.row = this.constants.singleRowSource ? null : this.getNextRowCore(this.source);
        }
        return bl;
    }

    private void notifyForUpdateCursor(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, RowLocation rowLocation, TableScanResultSet tableScanResultSet) throws StandardException {
        Object object;
        int[] nArray = tableScanResultSet.indexCols;
        int[] nArray2 = this.constants.changedColumnIds;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < nArray.length) {
            boolean bl4;
            int n2 = nArray[n];
            if (n2 > 0) {
                bl4 = true;
            } else {
                bl4 = false;
                n2 = -n2;
            }
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (n2 == nArray2[n3]) {
                    bl2 = true;
                    object = this.constants.getBaseRowReadMap();
                    Object object2 = object == null ? n2 - 1 : (Object)object[n2 - 1];
                    DataValueDescriptor dataValueDescriptor = tableScanResultSet.compareToLastKey ? tableScanResultSet.lastCursorKey.getColumn(n + 1) : dataValueDescriptorArray[object2];
                    if (bl4 && dataValueDescriptor.greaterThan(dataValueDescriptorArray2[object2], dataValueDescriptor).equals(true) || !bl4 && dataValueDescriptor.lessThan(dataValueDescriptorArray2[object2], dataValueDescriptor).equals(true)) {
                        bl = true;
                        break;
                    }
                    if (!dataValueDescriptor.equals(dataValueDescriptorArray2[object2], dataValueDescriptor).equals(true)) break;
                    bl2 = false;
                    bl3 = true;
                    break;
                }
                ++n3;
            }
            if (bl2) break;
            ++n;
        }
        if (bl3 && !bl2) {
            bl = true;
        }
        if (bl) {
            n = this.lcc.getOptimizerFactory().getMaxMemoryPerTable() / 16;
            if (n < 100) {
                n = 100;
            }
            if (tableScanResultSet.past2FutureTbl == null) {
                double d = tableScanResultSet.getEstimatedRowCount();
                int n4 = 32768;
                if (d > 0.0 && (d = d / 0.75 + 1.0) < (double)n4) {
                    n4 = (int)d;
                }
                if (n < n4) {
                    n4 = n;
                }
                tableScanResultSet.past2FutureTbl = new Hashtable(n4);
            }
            Hashtable hashtable = tableScanResultSet.past2FutureTbl;
            object = (RowLocation)rowLocation.getClone();
            if (hashtable.size() < n) {
                hashtable.put(object, object);
            } else {
                block18: {
                    ExecRow execRow;
                    tableScanResultSet.skipFutureRowHolder = true;
                    ValueRow valueRow = new ValueRow(1);
                    do {
                        if ((execRow = tableScanResultSet.getNextRowCore()) == null) {
                            tableScanResultSet.sourceDrained = true;
                            tableScanResultSet.past2FutureTbl = null;
                            break block18;
                        }
                        RowLocation rowLocation2 = (RowLocation)execRow.getColumn(execRow.nColumns());
                        if (object.equals(rowLocation2)) {
                            this.saveLastCusorKey(tableScanResultSet, execRow);
                            break block18;
                        }
                        if (tableScanResultSet.futureForUpdateRows == null) {
                            tableScanResultSet.futureForUpdateRows = new TemporaryRowHolderImpl(this.tc, null, null, 100, false, true);
                        }
                        valueRow.setColumn(1, rowLocation2);
                        tableScanResultSet.futureForUpdateRows.insert(valueRow);
                    } while (hashtable.size() >= n);
                    hashtable.put(object, object);
                    this.saveLastCusorKey(tableScanResultSet, execRow);
                }
                tableScanResultSet.skipFutureRowHolder = false;
            }
        }
    }

    private void saveLastCusorKey(TableScanResultSet tableScanResultSet, ExecRow execRow) throws StandardException {
        if (tableScanResultSet.lastCursorKey == null) {
            tableScanResultSet.lastCursorKey = new ValueRow(execRow.nColumns() - 1);
        }
        int n = 1;
        while (n <= tableScanResultSet.lastCursorKey.nColumns()) {
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(n);
            if (dataValueDescriptor != null) {
                tableScanResultSet.lastCursorKey.setColumn(n, dataValueDescriptor.getClone());
            }
            ++n;
        }
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.deferred && this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 1, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.deferred && this.triggerActivator != null) {
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    void updateDeferredRows() throws StandardException {
        if (this.deferred) {
            this.deferredBaseCC = this.tc.openCompiledConglomerate(false, TransactionController.OPENMODE_FORUPDATE | TransactionController.OPENMODE_SECONDARY_LOCKED, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
            CursorResultSet cursorResultSet = this.insertedRowHolder.getResultSet();
            try {
                ExecRow execRow;
                FormatableBitSet formatableBitSet = RowUtil.shift(this.baseRowReadList, 1);
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    if (this.triggerInfo != null) {
                        this.source.setCurrentRow(this.deferredTempRow);
                        NoRowsResultSetImpl.evaluateCheckConstraints(this.checkGM, this.activation);
                    }
                    DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.numberOfBaseColumns + 1);
                    RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
                    boolean bl = this.deferredBaseCC.fetch(rowLocation, this.deferredSparseRow.getRowArray(), formatableBitSet);
                    RowUtil.copyRefColumns(this.newBaseRow, execRow, this.numberOfBaseColumns);
                    this.rowChanger.updateRow(this.deferredBaseRow, this.newBaseRow, rowLocation);
                }
            }
            finally {
                Object var3_7 = null;
                this.source.clearCurrentRow();
                cursorResultSet.close();
            }
        }
    }

    void runChecker(boolean bl) throws StandardException {
        Object var6_5;
        ExecRow execRow;
        CursorResultSet cursorResultSet;
        int n;
        if (this.deferred && this.updatingReferencedKey) {
            n = 0;
            while (n < this.fkInfoArray.length) {
                if (this.fkInfoArray[n].type != 1) {
                    cursorResultSet = this.deletedRowHolder.getResultSet();
                    try {
                        cursorResultSet.open();
                        while ((execRow = cursorResultSet.getNextRow()) != null) {
                            if (UpdateResultSet.foundRow(execRow, this.fkInfoArray[n].colArray, this.insertedRowHolder)) continue;
                            this.riChecker.doRICheck(n, execRow, bl);
                        }
                    }
                    finally {
                        var6_5 = null;
                        cursorResultSet.close();
                    }
                }
                ++n;
            }
        }
        if (this.deferred && this.updatingForeignKey) {
            n = 0;
            while (n < this.fkInfoArray.length) {
                if (this.fkInfoArray[n].type != 2) {
                    cursorResultSet = this.insertedRowHolder.getResultSet();
                    try {
                        cursorResultSet.open();
                        while ((execRow = cursorResultSet.getNextRow()) != null) {
                            if (UpdateResultSet.foundRow(execRow, this.fkInfoArray[n].colArray, this.deletedRowHolder)) continue;
                            this.riChecker.doRICheck(n, execRow, bl);
                        }
                    }
                    finally {
                        var6_5 = null;
                        cursorResultSet.close();
                    }
                }
                ++n;
            }
        }
    }

    public static boolean foundRow(ExecRow execRow, int[] nArray, TemporaryRowHolderImpl temporaryRowHolderImpl) throws StandardException {
        boolean bl = false;
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        CursorResultSet cursorResultSet = temporaryRowHolderImpl.getResultSet();
        try {
            ExecRow execRow2;
            cursorResultSet.open();
            while ((execRow2 = cursorResultSet.getNextRow()) != null) {
                DataValueDescriptor[] dataValueDescriptorArray2 = execRow2.getRowArray();
                int n = 0;
                while (n < nArray.length) {
                    DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[nArray[n] - 1];
                    DataValueDescriptor dataValueDescriptor2 = dataValueDescriptorArray2[nArray[n] - 1];
                    BooleanDataValue booleanDataValue = dataValueDescriptor.equals(dataValueDescriptor2, dataValueDescriptor);
                    if (!booleanDataValue.getBoolean()) break;
                    ++n;
                }
                if (n != nArray.length) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            cursorResultSet.close();
            throw throwable;
        }
        Object var10_12 = null;
        cursorResultSet.close();
        return bl;
    }

    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.source != null) {
            this.source.close();
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.insertedRowHolder != null) {
            this.insertedRowHolder.close();
        }
        if (this.deletedRowHolder != null) {
            this.deletedRowHolder.close();
        }
        if (this.riChecker != null) {
            this.riChecker.close();
        }
        super.close();
        this.endTime = this.getCurrentTimeMillis();
    }

    protected static int decodeLockMode(LanguageConnectionContext languageConnectionContext, int n) {
        if (n >>> 16 != 0) {
            int n2 = languageConnectionContext.getCurrentIsolationLevel();
            n = n2 != 4 ? (n &= 0xFF) : (n >>>= 16);
        }
        return n;
    }

    void rowChangerFinish() throws StandardException {
        this.rowChanger.finish();
    }

    public UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, Activation activation) throws StandardException {
        this(noPutResultSet, generatedMethod, activation, activation.getConstantAction(), null);
    }

    public UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, Activation activation, int n, int n2) throws StandardException {
        this(noPutResultSet, generatedMethod, activation, (ConstantAction)activation.getPreparedStatement().getSavedObject(n), (ResultDescription)activation.getPreparedStatement().getSavedObject(n2));
        this.deferred = true;
    }

    public UpdateResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, Activation activation, ConstantAction constantAction, ResultDescription resultDescription) throws StandardException {
        super(activation, constantAction);
        this.lcc = activation.getLanguageConnectionContext();
        this.tc = activation.getTransactionController();
        this.source = noPutResultSet;
        this.checkGM = generatedMethod;
        this.constants = (UpdateConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo(this.lcc.getExecutionContext());
        this.triggerInfo = this.constants.getTriggerInfo(this.lcc.getExecutionContext());
        this.heapConglom = this.constants.conglomId;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = resultDescription == null ? noPutResultSet.getResultDescription() : resultDescription;
        if (this.fkInfoArray != null) {
            int n = 0;
            while (n < this.fkInfoArray.length) {
                if (this.fkInfoArray[n].type == 2) {
                    this.updatingReferencedKey = true;
                } else {
                    this.updatingForeignKey = true;
                }
                ++n;
            }
        }
        this.resultWidth = this.resultDescription.getColumnCount();
        this.numberOfBaseColumns = (this.resultWidth - 1) / 2;
        this.newBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
        this.lockMode = UpdateResultSet.decodeLockMode(this.lcc, this.constants.lockMode);
        this.deferred = this.constants.deferred;
        if (this.triggerInfo != null || this.fkInfoArray != null) {
            this.beforeUpdateCopyRequired = true;
        }
    }
}

