/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.index.B2IController;
import org.apache.derby.impl.store.access.btree.index.B2ICostController;
import org.apache.derby.impl.store.access.btree.index.B2IForwardScan;
import org.apache.derby.impl.store.access.btree.index.B2IMaxScan;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking1;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking2;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IRowLockingRR;
import org.apache.derby.impl.store.access.btree.index.B2IStaticCompiledInfo;
import org.apache.derby.impl.store.access.btree.index.B2ITableLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;

public class B2I
extends BTree {
    public static final String PROPERTY_BASECONGLOMID = "baseConglomerateId";
    public static final String PROPERTY_ROWLOCCOLUMN = "rowLocationColumn";
    public static final int FORMAT_NUMBER = 388;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$Lorg$apache$derby$impl$store$access$btree$index$B2I != null ? class$Lorg$apache$derby$impl$store$access$btree$index$B2I : (class$Lorg$apache$derby$impl$store$access$btree$index$B2I = B2I.class$("org.apache.derby.impl.store.access.btree.index.B2I")));
    protected long baseConglomerateId;
    protected int rowLocationColumn;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$store$access$btree$index$B2I;

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    protected BTreeLockingPolicy getBtreeLockingPolicy(Transaction transaction, int n, int n2, int n3, ConglomerateController conglomerateController, OpenBTree openBTree) throws StandardException {
        BTreeLockingPolicy bTreeLockingPolicy = null;
        if (n == 7) {
            bTreeLockingPolicy = new B2ITableLocking3(transaction, n, transaction.newLockingPolicy(2, n3, true), conglomerateController, openBTree);
        } else if (n == 6) {
            if (n3 == 5) {
                bTreeLockingPolicy = new B2IRowLocking3(transaction, n, transaction.newLockingPolicy(1, n3, true), conglomerateController, openBTree);
            } else if (n3 == 4) {
                bTreeLockingPolicy = new B2IRowLockingRR(transaction, n, transaction.newLockingPolicy(1, n3, true), conglomerateController, openBTree);
            } else if (n3 == 2 || n3 == 3) {
                bTreeLockingPolicy = new B2IRowLocking2(transaction, n, transaction.newLockingPolicy(1, n3, true), conglomerateController, openBTree);
            } else if (n3 == 1) {
                bTreeLockingPolicy = new B2IRowLocking1(transaction, n, transaction.newLockingPolicy(1, n3, true), conglomerateController, openBTree);
            }
        }
        return bTreeLockingPolicy;
    }

    public final ConglomerateController lockTable(TransactionManager transactionManager, int n, int n2, int n3) throws StandardException {
        ConglomerateController conglomerateController = transactionManager.openConglomerate(this.baseConglomerateId, false, n |= 0x40, n2, n3);
        return conglomerateController;
    }

    private void traverseRight() {
    }

    public void create(TransactionManager transactionManager, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, Properties properties, int n2) throws StandardException {
        String string = null;
        Transaction transaction = transactionManager.getRawStoreXact();
        if (properties == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        string = properties.getProperty(PROPERTY_BASECONGLOMID);
        if (string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.baseConglomerateId = Long.parseLong(string);
        string = properties.getProperty(PROPERTY_ROWLOCCOLUMN);
        if (string == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.rowLocationColumn = Integer.parseInt(string);
        this.ascDescInfo = new boolean[dataValueDescriptorArray.length];
        int n3 = 0;
        while (n3 < this.ascDescInfo.length) {
            this.ascDescInfo[n3] = columnOrderingArray != null && n3 < columnOrderingArray.length ? columnOrderingArray[n3].getIsAscending() : true;
            ++n3;
        }
        super.create(transaction, n, l, dataValueDescriptorArray, properties, this.getTypeFormatId(), n2);
        ConglomerateController conglomerateController = transactionManager.openConglomerate(this.baseConglomerateId, false, 64, 7, 5);
        OpenBTree openBTree = new OpenBTree();
        B2ITableLocking3 b2ITableLocking3 = new B2ITableLocking3(transaction, 7, transaction.newLockingPolicy(2, 5, true), conglomerateController, openBTree);
        openBTree.init(transactionManager, transactionManager, null, transaction, false, 4, 7, b2ITableLocking3, this, null, null);
        LeafControlRow.initEmptyBtree(openBTree);
        openBTree.close();
        conglomerateController.close();
    }

    public boolean fetchMaxOnBTree(TransactionManager transactionManager, Transaction transaction, long l, int n, int n2, LockingPolicy lockingPolicy, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        B2IMaxScan b2IMaxScan = new B2IMaxScan();
        b2IMaxScan.init(transactionManager, transaction, n, n2, lockingPolicy, n3, true, formatableBitSet, this, new B2IUndo());
        boolean bl = b2IMaxScan.fetchMax(dataValueDescriptorArray);
        b2IMaxScan.close();
        return bl;
    }

    public long load(TransactionManager transactionManager, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        long l = 0L;
        B2IController b2IController = new B2IController();
        try {
            int n = 4;
            if (bl) {
                n |= 3;
            }
            b2IController.init(transactionManager, transactionManager.getRawStoreXact(), n, 7, transactionManager.getRawStoreXact().newLockingPolicy(2, 5, true), true, this, new B2IUndo(), null, null);
            l = b2IController.load(transactionManager, bl, rowLocationRetRowSource);
        }
        finally {
            Object var8_7 = null;
            b2IController.close();
        }
        return l;
    }

    public ConglomerateController open(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        B2IController b2IController = new B2IController();
        b2IController.init(transactionManager, transaction, n, n2, lockingPolicy, true, this, new B2IUndo(), (B2IStaticCompiledInfo)staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        return b2IController;
    }

    public ScanManager openScan(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        B2IForwardScan b2IForwardScan = new B2IForwardScan();
        b2IForwardScan.init(transactionManager, transaction, bl, n, n2, lockingPolicy, n3, true, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, this, new B2IUndo(), (B2IStaticCompiledInfo)staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        return b2IForwardScan;
    }

    public StoreCostController openStoreCost(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        B2ICostController b2ICostController = new B2ICostController();
        b2ICostController.init(transactionManager, this, transaction);
        return b2ICostController;
    }

    public void drop(TransactionManager transactionManager) throws StandardException {
        ConglomerateController conglomerateController = null;
        conglomerateController = this.lockTable(transactionManager, 4, 7, 4);
        transactionManager.getRawStoreXact().dropContainer(this.id);
        if (conglomerateController != null) {
            conglomerateController.close();
        }
    }

    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController transactionController, long l) throws StandardException {
        return new B2IStaticCompiledInfo(transactionController, this);
    }

    public int getTypeFormatId() {
        return 388;
    }

    public void writeExternal_v36(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.baseConglomerateId);
        objectOutput.writeInt(this.rowLocationColumn);
    }

    public void readExternal_v36(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.baseConglomerateId = objectInput.readLong();
        this.rowLocationColumn = objectInput.readInt();
        this.ascDescInfo = new boolean[this.nKeyFields];
        int n = 0;
        while (n < this.ascDescInfo.length) {
            this.ascDescInfo[n] = true;
            ++n;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.baseConglomerateId);
        objectOutput.writeInt(this.rowLocationColumn);
        if (this.conglom_format_id != 92) {
            FormatableBitSet formatableBitSet = new FormatableBitSet(this.ascDescInfo.length);
            int n = 0;
            while (n < this.ascDescInfo.length) {
                if (this.ascDescInfo[n]) {
                    formatableBitSet.set(n);
                }
                ++n;
            }
            formatableBitSet.writeExternal(objectOutput);
        }
    }

    private final void localReadExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.baseConglomerateId = objectInput.readLong();
        this.rowLocationColumn = objectInput.readInt();
        if (this.conglom_format_id != 92) {
            FormatableBitSet formatableBitSet = new FormatableBitSet();
            formatableBitSet.readExternal(objectInput);
            this.ascDescInfo = new boolean[formatableBitSet.getLength()];
            int n = 0;
            while (n < formatableBitSet.getLength()) {
                this.ascDescInfo[n] = formatableBitSet.isSet(n);
                ++n;
            }
        } else {
            this.ascDescInfo = new boolean[this.nKeyFields];
            int n = 0;
            while (n < this.ascDescInfo.length) {
                this.ascDescInfo[n] = true;
                ++n;
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.localReadExternal(objectInput);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.localReadExternal(arrayInputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

