/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.ContainerBasicOperation;
import org.apache.derby.impl.store.raw.data.ContainerUndoOperation;

public class ContainerOperation
extends ContainerBasicOperation
implements Undoable {
    protected static final byte CREATE = 1;
    protected static final byte DROP = 2;
    protected static final byte REMOVE = 4;
    protected byte operation;
    protected transient boolean hasCreateByteArray = true;
    protected ByteArray createByteArray;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(this.operation);
        if (this.operation == 1) {
            try {
                this.createByteArray = this.containerHdl.logCreateContainerInfo();
            }
            catch (StandardException standardException) {
                throw new IOException(standardException.toString());
            }
            this.createByteArray.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.operation = objectInput.readByte();
        if (this.operation == 1 && this.hasCreateByteArray) {
            this.createByteArray = new ByteArray();
            this.createByteArray.readExternal(objectInput);
        }
    }

    public int getTypeFormatId() {
        return 242;
    }

    protected RawContainerHandle findContainerForLoadTran(RawTransaction rawTransaction) throws StandardException {
        long l = this.containerId.getSegmentId();
        long l2 = this.containerId.getContainerId();
        rawTransaction.reCreateContainerForLoadTran(l, l2, this.createByteArray);
        return rawTransaction.openDroppedContainer(this.containerId, null);
    }

    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        switch (this.operation) {
            case 2: {
                this.containerHdl.dropContainer(logInstant, true);
                break;
            }
            case 4: {
                this.containerHdl.removeContainer(logInstant);
                break;
            }
            case 1: {
                break;
            }
        }
        this.releaseResource(transaction);
    }

    public void undoMe(Transaction transaction, RawContainerHandle rawContainerHandle, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        switch (this.operation) {
            case 2: {
                rawContainerHandle.dropContainer(logInstant, false);
                break;
            }
            case 1: {
                rawContainerHandle.removeContainer(logInstant);
                break;
            }
            case 4: {
                break;
            }
        }
        this.releaseResource(transaction);
    }

    public Compensation generateUndo(Transaction transaction, LimitObjectInput limitObjectInput) throws StandardException {
        if (this.operation == 4) {
            return null;
        }
        RawContainerHandle rawContainerHandle = this.findContainer(transaction);
        return new ContainerUndoOperation(rawContainerHandle, this);
    }

    public String toString() {
        return null;
    }

    protected ContainerOperation(RawContainerHandle rawContainerHandle, byte by) throws StandardException {
        super(rawContainerHandle);
        this.operation = by;
    }

    public ContainerOperation() {
    }
}

