/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package pat2021;

import static java.awt.Dialog.ModalityType.APPLICATION_MODAL;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

/**
 * Generates an AdminGUI form and manages the accompanying functionality
 * @author bee.ntsimane
 * 
 */
public class AdminGUI extends javax.swing.JFrame {
    
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private StudentSQL sSQL = new StudentSQL();
    private MarkSQL mSQL = new MarkSQL();
    private int row;
    private int recordID;
    private String subject;
    private String timeOfYear;
    private String yearOfStudy;
    private int mark;
   
    /**
     * Creates new form AdminGUI
     */
    public AdminGUI() {
        initComponents();
        
        //centre the GUI on the screen
        this.setLocation(dim.width/2-this.getSize().width/2, dim.height/2-this.getSize().height/2);
      
       //populate the yearOfStudy combo box
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);    
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jMenuBar2 = new javax.swing.JMenuBar();
        jMenu3 = new javax.swing.JMenu();
        jMenu4 = new javax.swing.JMenu();
        dlgAddNewStudent = new javax.swing.JDialog();
        pnlAddNewStudent = new javax.swing.JPanel();
        lblNewStudentHeader = new javax.swing.JLabel();
        txtUsername = new javax.swing.JTextField();
        txtEmail = new javax.swing.JTextField();
        txtMatriculationYear = new javax.swing.JTextField();
        pswdStudentPassword = new javax.swing.JPasswordField();
        pswdConfirmPassword = new javax.swing.JPasswordField();
        lblUsername = new javax.swing.JLabel();
        lblEmail = new javax.swing.JLabel();
        lblMatriculationYear = new javax.swing.JLabel();
        lblStudentPassword = new javax.swing.JLabel();
        lblConfirmPassword = new javax.swing.JLabel();
        btnSave = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        dlgDeleteStudent = new javax.swing.JDialog();
        pnlDeleteStudent = new javax.swing.JPanel();
        lblDeleteStudentMessage = new javax.swing.JLabel();
        btnConfirmDeletion = new javax.swing.JButton();
        btnDeleteStudentCancel = new javax.swing.JButton();
        dlgDeleteMark = new javax.swing.JDialog();
        jPanel1 = new javax.swing.JPanel();
        lblConfirmMarkDeletion = new javax.swing.JLabel();
        btnConfirmMarkDeletion = new javax.swing.JButton();
        btnCancelMarkDeletion = new javax.swing.JButton();
        dlgAddNewMark = new javax.swing.JDialog();
        pnlAddNewMark = new javax.swing.JPanel();
        lblNewMarkHeader = new javax.swing.JLabel();
        btnAddNewMarkSave = new javax.swing.JButton();
        btnAddNewMarkCancel = new javax.swing.JButton();
        lblAddMarkUsername = new javax.swing.JLabel();
        lblAddMarkSubject = new javax.swing.JLabel();
        lblAddMarkTOY = new javax.swing.JLabel();
        lblAddMarkYOS = new javax.swing.JLabel();
        lblAddNewMarkMark = new javax.swing.JLabel();
        txtAddNewMarkUsername = new javax.swing.JTextField();
        txtAddNewMarkSubject = new javax.swing.JTextField();
        txtAddNewMarkTOY = new javax.swing.JTextField();
        txtAddNewMarkYOS = new javax.swing.JTextField();
        txtAddNewMarkMark = new javax.swing.JTextField();
        dlgHelp = new javax.swing.JDialog();
        jPanel3 = new javax.swing.JPanel();
        lblHelpHeader = new javax.swing.JLabel();
        lblP1 = new javax.swing.JLabel();
        lblP2 = new javax.swing.JLabel();
        lblP3 = new javax.swing.JLabel();
        lblP4 = new javax.swing.JLabel();
        lblP5 = new javax.swing.JLabel();
        lblP6 = new javax.swing.JLabel();
        lblP7 = new javax.swing.JLabel();
        lblP8 = new javax.swing.JLabel();
        lblP9 = new javax.swing.JLabel();
        btnCloseHelp = new javax.swing.JButton();
        lblP10 = new javax.swing.JLabel();
        dlgConfirmLogOff = new javax.swing.JDialog();
        jPanel2 = new javax.swing.JPanel();
        lblLogOffHeader = new javax.swing.JLabel();
        btnLogOff = new javax.swing.JButton();
        btnCancelLogOff = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        pnlMainPanel = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        pnlStudents = new javax.swing.JPanel();
        btnAddStudent = new javax.swing.JButton();
        btnDeleteStudent = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblStudentList = new javax.swing.JTable();
        jLabel4 = new javax.swing.JLabel();
        txtStudentSearch = new javax.swing.JTextField();
        lblStudentSearch = new javax.swing.JLabel();
        btnStudentSearch = new javax.swing.JButton();
        btnViewAllStudents = new javax.swing.JButton();
        pnlMarks = new javax.swing.JPanel();
        btnAddMark = new javax.swing.JButton();
        btnDeleteMark = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        tblStudentSubjectMarks = new javax.swing.JTable();
        cmbSubject = new javax.swing.JComboBox<>();
        cmbTimeOfYear = new javax.swing.JComboBox<>();
        cmbYearOfStudy = new javax.swing.JComboBox<>();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        cmbMatricYear = new javax.swing.JComboBox<>();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        mnuHelp = new javax.swing.JMenuItem();
        mnuLogOff = new javax.swing.JMenuItem();

        jMenu3.setText("File");
        jMenuBar2.add(jMenu3);

        jMenu4.setText("Edit");
        jMenuBar2.add(jMenu4);

        pnlAddNewStudent.setBackground(new java.awt.Color(247, 235, 248));
        pnlAddNewStudent.setMaximumSize(new java.awt.Dimension(400, 443));
        pnlAddNewStudent.setSize(new java.awt.Dimension(400, 400));
        pnlAddNewStudent.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                pnlAddNewStudentComponentShown(evt);
            }
        });

        lblNewStudentHeader.setFont(new java.awt.Font("Skia", 3, 20)); // NOI18N
        lblNewStudentHeader.setText("<html><center>New Student<center>");

        txtUsername.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        txtUsername.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtUsernameActionPerformed(evt);
            }
        });

        txtEmail.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        txtMatriculationYear.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        pswdStudentPassword.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        pswdConfirmPassword.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        lblUsername.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblUsername.setText("Student Username:");

        lblEmail.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblEmail.setText("Student Email:");

        lblMatriculationYear.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblMatriculationYear.setText("Student Matriculation Year:");

        lblStudentPassword.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblStudentPassword.setText("Student Password:");

        lblConfirmPassword.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblConfirmPassword.setText("Confirm Password:");

        btnSave.setFont(new java.awt.Font("Skia", 2, 20)); // NOI18N
        btnSave.setText("Save");
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });

        btnCancel.setFont(new java.awt.Font("Skia", 2, 20)); // NOI18N
        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlAddNewStudentLayout = new javax.swing.GroupLayout(pnlAddNewStudent);
        pnlAddNewStudent.setLayout(pnlAddNewStudentLayout);
        pnlAddNewStudentLayout.setHorizontalGroup(
            pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlAddNewStudentLayout.createSequentialGroup()
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlAddNewStudentLayout.createSequentialGroup()
                                .addComponent(lblMatriculationYear)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlAddNewStudentLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(lblUsername, javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(lblEmail, javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(lblConfirmPassword, javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(lblStudentPassword, javax.swing.GroupLayout.Alignment.TRAILING))))
                        .addGap(18, 18, 18)
                        .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(txtEmail)
                            .addComponent(txtMatriculationYear, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(pswdStudentPassword, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                                .addComponent(pswdConfirmPassword, javax.swing.GroupLayout.PREFERRED_SIZE, 127, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(txtUsername)))
                    .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                        .addGap(75, 75, 75)
                        .addComponent(btnCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnSave, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(138, 138, 138))
            .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                .addGap(144, 144, 144)
                .addComponent(lblNewStudentHeader, javax.swing.GroupLayout.PREFERRED_SIZE, 169, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pnlAddNewStudentLayout.setVerticalGroup(
            pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addComponent(lblNewStudentHeader, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtUsername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblUsername, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(27, 27, 27)
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblEmail)
                    .addComponent(txtEmail, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtMatriculationYear, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblMatriculationYear))
                .addGap(6, 6, 6)
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                        .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(pswdStudentPassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblStudentPassword))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(pnlAddNewStudentLayout.createSequentialGroup()
                        .addGap(0, 52, Short.MAX_VALUE)
                        .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(lblConfirmPassword)
                            .addComponent(pswdConfirmPassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(49, 49, 49)))
                .addGroup(pnlAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnSave, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(56, 56, 56))
        );

        javax.swing.GroupLayout dlgAddNewStudentLayout = new javax.swing.GroupLayout(dlgAddNewStudent.getContentPane());
        dlgAddNewStudent.getContentPane().setLayout(dlgAddNewStudentLayout);
        dlgAddNewStudentLayout.setHorizontalGroup(
            dlgAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnlAddNewStudent, javax.swing.GroupLayout.PREFERRED_SIZE, 423, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        dlgAddNewStudentLayout.setVerticalGroup(
            dlgAddNewStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, dlgAddNewStudentLayout.createSequentialGroup()
                .addComponent(pnlAddNewStudent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pnlDeleteStudent.setBackground(new java.awt.Color(247, 235, 248));

        lblDeleteStudentMessage.setFont(new java.awt.Font("Skia", 3, 18)); // NOI18N
        lblDeleteStudentMessage.setText("<html><center>Are you sure you want to delete the student?<center>");

        btnConfirmDeletion.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnConfirmDeletion.setText("Delete");
        btnConfirmDeletion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnConfirmDeletionActionPerformed(evt);
            }
        });

        btnDeleteStudentCancel.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnDeleteStudentCancel.setText("Cancel");
        btnDeleteStudentCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteStudentCancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlDeleteStudentLayout = new javax.swing.GroupLayout(pnlDeleteStudent);
        pnlDeleteStudent.setLayout(pnlDeleteStudentLayout);
        pnlDeleteStudentLayout.setHorizontalGroup(
            pnlDeleteStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlDeleteStudentLayout.createSequentialGroup()
                .addContainerGap(45, Short.MAX_VALUE)
                .addComponent(btnDeleteStudentCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 101, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(48, 48, 48)
                .addComponent(btnConfirmDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(45, Short.MAX_VALUE))
            .addGroup(pnlDeleteStudentLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblDeleteStudentMessage, javax.swing.GroupLayout.PREFERRED_SIZE, 313, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pnlDeleteStudentLayout.setVerticalGroup(
            pnlDeleteStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlDeleteStudentLayout.createSequentialGroup()
                .addContainerGap(21, Short.MAX_VALUE)
                .addComponent(lblDeleteStudentMessage, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(pnlDeleteStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnConfirmDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnDeleteStudentCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(55, 55, 55))
        );

        javax.swing.GroupLayout dlgDeleteStudentLayout = new javax.swing.GroupLayout(dlgDeleteStudent.getContentPane());
        dlgDeleteStudent.getContentPane().setLayout(dlgDeleteStudentLayout);
        dlgDeleteStudentLayout.setHorizontalGroup(
            dlgDeleteStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnlDeleteStudent, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        dlgDeleteStudentLayout.setVerticalGroup(
            dlgDeleteStudentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnlDeleteStudent, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jPanel1.setBackground(new java.awt.Color(247, 235, 248));
        jPanel1.setPreferredSize(new java.awt.Dimension(354, 179));

        lblConfirmMarkDeletion.setFont(new java.awt.Font("Skia", 3, 18)); // NOI18N
        lblConfirmMarkDeletion.setText("<html><center>Are you sure you want<br>to delete the selected record?<center>");

        btnConfirmMarkDeletion.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnConfirmMarkDeletion.setText("Delete");
        btnConfirmMarkDeletion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnConfirmMarkDeletionActionPerformed(evt);
            }
        });

        btnCancelMarkDeletion.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnCancelMarkDeletion.setText("Cancel");
        btnCancelMarkDeletion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelMarkDeletionActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(lblConfirmMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(42, 42, 42)
                        .addComponent(btnCancelMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 114, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE)
                        .addComponent(btnConfirmMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 104, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(49, 49, 49))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(26, 26, 26)
                .addComponent(lblConfirmMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(36, 36, 36)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnConfirmMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCancelMarkDeletion, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(44, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout dlgDeleteMarkLayout = new javax.swing.GroupLayout(dlgDeleteMark.getContentPane());
        dlgDeleteMark.getContentPane().setLayout(dlgDeleteMarkLayout);
        dlgDeleteMarkLayout.setHorizontalGroup(
            dlgDeleteMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgDeleteMarkLayout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 352, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        dlgDeleteMarkLayout.setVerticalGroup(
            dlgDeleteMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgDeleteMarkLayout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 190, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pnlAddNewMark.setBackground(new java.awt.Color(247, 235, 248));

        lblNewMarkHeader.setFont(new java.awt.Font("Skia", 3, 20)); // NOI18N
        lblNewMarkHeader.setText("<html><center>New Mark Record<center>");

        btnAddNewMarkSave.setFont(new java.awt.Font("Skia", 2, 18)); // NOI18N
        btnAddNewMarkSave.setText("Save");
        btnAddNewMarkSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddNewMarkSaveActionPerformed(evt);
            }
        });

        btnAddNewMarkCancel.setFont(new java.awt.Font("Skia", 2, 18)); // NOI18N
        btnAddNewMarkCancel.setText("Cancel");
        btnAddNewMarkCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddNewMarkCancelActionPerformed(evt);
            }
        });

        lblAddMarkUsername.setFont(new java.awt.Font("Skia", 3, 16)); // NOI18N
        lblAddMarkUsername.setText("Username:");

        lblAddMarkSubject.setFont(new java.awt.Font("Skia", 3, 16)); // NOI18N
        lblAddMarkSubject.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lblAddMarkSubject.setText("<html><right>Subject: <br>(Please enter in all caps) <right>");

        lblAddMarkTOY.setFont(new java.awt.Font("Skia", 3, 16)); // NOI18N
        lblAddMarkTOY.setText("<html><center>Time of Year<br>(MID or END):<center>");

        lblAddMarkYOS.setFont(new java.awt.Font("Skia", 3, 16)); // NOI18N
        lblAddMarkYOS.setText("Year of Study:");

        lblAddNewMarkMark.setFont(new java.awt.Font("Skia", 3, 16)); // NOI18N
        lblAddNewMarkMark.setText("Mark:");

        txtAddNewMarkUsername.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        txtAddNewMarkUsername.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtAddNewMarkUsernameActionPerformed(evt);
            }
        });

        txtAddNewMarkSubject.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        txtAddNewMarkSubject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtAddNewMarkSubjectActionPerformed(evt);
            }
        });

        txtAddNewMarkTOY.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        txtAddNewMarkTOY.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtAddNewMarkTOYActionPerformed(evt);
            }
        });

        txtAddNewMarkYOS.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N

        txtAddNewMarkMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        txtAddNewMarkMark.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtAddNewMarkMarkActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlAddNewMarkLayout = new javax.swing.GroupLayout(pnlAddNewMark);
        pnlAddNewMark.setLayout(pnlAddNewMarkLayout);
        pnlAddNewMarkLayout.setHorizontalGroup(
            pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAddNewMarkLayout.createSequentialGroup()
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlAddNewMarkLayout.createSequentialGroup()
                        .addGap(63, 63, 63)
                        .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblAddMarkUsername)
                            .addComponent(btnAddNewMarkCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblAddMarkSubject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblAddMarkTOY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblAddMarkYOS)
                            .addComponent(lblAddNewMarkMark))
                        .addGap(40, 40, 40)
                        .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(txtAddNewMarkSubject, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(txtAddNewMarkUsername, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(txtAddNewMarkTOY, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(txtAddNewMarkYOS, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(txtAddNewMarkMark, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnAddNewMarkSave, javax.swing.GroupLayout.PREFERRED_SIZE, 118, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(pnlAddNewMarkLayout.createSequentialGroup()
                        .addGap(156, 156, 156)
                        .addComponent(lblNewMarkHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(50, Short.MAX_VALUE))
        );
        pnlAddNewMarkLayout.setVerticalGroup(
            pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAddNewMarkLayout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addComponent(lblNewMarkHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(26, 26, 26)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblAddMarkUsername)
                    .addComponent(txtAddNewMarkUsername, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lblAddMarkSubject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtAddNewMarkSubject, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblAddMarkTOY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtAddNewMarkTOY, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(11, 11, 11)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(txtAddNewMarkYOS, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblAddMarkYOS))
                .addGap(30, 30, 30)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblAddNewMarkMark)
                    .addComponent(txtAddNewMarkMark, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 71, Short.MAX_VALUE)
                .addGroup(pnlAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnAddNewMarkSave, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnAddNewMarkCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(56, 56, 56))
        );

        javax.swing.GroupLayout dlgAddNewMarkLayout = new javax.swing.GroupLayout(dlgAddNewMark.getContentPane());
        dlgAddNewMark.getContentPane().setLayout(dlgAddNewMarkLayout);
        dlgAddNewMarkLayout.setHorizontalGroup(
            dlgAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnlAddNewMark, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        dlgAddNewMarkLayout.setVerticalGroup(
            dlgAddNewMarkLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgAddNewMarkLayout.createSequentialGroup()
                .addComponent(pnlAddNewMark, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        dlgHelp.setBackground(new java.awt.Color(247, 235, 248));

        jPanel3.setBackground(new java.awt.Color(247, 235, 248));

        lblHelpHeader.setFont(new java.awt.Font("Skia", 1, 18)); // NOI18N
        lblHelpHeader.setText("Need Help?");

        lblP1.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP1.setText("<html>The details of all students are displayed in the table in the Students tab and the mark records are displayed in the table in the Marks tab<html>");

        lblP2.setFont(new java.awt.Font("Skia", 1, 16)); // NOI18N
        lblP2.setText("In the Students tab:");

        lblP3.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP3.setText("<html>To search for a student, enter the student's name in the box marked \"student search\" and press the search button. The specific student's details will be displayed in the table<html>\n");

        lblP4.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP4.setText("<html>To add a new student, press the \"Add New Student\" button and enter the student's details in the dialog before pressing \"Save\" to save the student's details in the database<html>");

        lblP5.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP5.setText("<html>To delete a student, select the student's record and then select the \"Delete Student\" button to confirm deletion.<html>");

        lblP6.setFont(new java.awt.Font("Skia", 1, 16)); // NOI18N
        lblP6.setText("In the Marks tab:");

        lblP7.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP7.setText("<html>You can select specific details including specific subjects, time of year, year of study and matric year of the records you want to view by selecting the respective details in the combo boxes above the table<html>");

        lblP8.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP8.setText("<html>To add a new mark record, press the \"Add Mark\" button and enter the mark record details in the dialog before pressing \"Save\" to save the details in the database<html>");

        lblP9.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP9.setText("<html>To delete a mark record, select the record and then select the \"Delete Mark\" button to confirm deletion.<html>");

        btnCloseHelp.setFont(new java.awt.Font("Skia", 0, 16)); // NOI18N
        btnCloseHelp.setText("Close");
        btnCloseHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCloseHelpActionPerformed(evt);
            }
        });

        lblP10.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP10.setText("<html>To log off, select \"options\" and then \"Log off\", or press shift L<html>");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(27, 27, 27)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblP2)
                            .addComponent(lblP1, javax.swing.GroupLayout.PREFERRED_SIZE, 354, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP3, javax.swing.GroupLayout.PREFERRED_SIZE, 378, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP6)
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(lblP8, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                                .addComponent(lblP7, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                                .addComponent(lblP5, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE))
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addComponent(lblP9, javax.swing.GroupLayout.PREFERRED_SIZE, 310, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btnCloseHelp))
                            .addComponent(lblP4, javax.swing.GroupLayout.PREFERRED_SIZE, 390, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP10, javax.swing.GroupLayout.PREFERRED_SIZE, 310, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(169, 169, 169)
                        .addComponent(lblHelpHeader)))
                .addContainerGap(18, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addComponent(lblHelpHeader)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP1, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblP2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(lblP4, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(12, 12, 12)
                .addComponent(lblP5, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(lblP6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblP7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(lblP8, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(16, 16, 16)
                        .addComponent(lblP9, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(lblP10, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(80, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnCloseHelp, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(27, 27, 27))))
        );

        javax.swing.GroupLayout dlgHelpLayout = new javax.swing.GroupLayout(dlgHelp.getContentPane());
        dlgHelp.getContentPane().setLayout(dlgHelpLayout);
        dlgHelpLayout.setHorizontalGroup(
            dlgHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        dlgHelpLayout.setVerticalGroup(
            dlgHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jPanel2.setBackground(new java.awt.Color(247, 235, 248));

        lblLogOffHeader.setFont(new java.awt.Font("Skia", 1, 18)); // NOI18N
        lblLogOffHeader.setText("<html><center>Are you sure you want to<br>log off?<center>");

        btnLogOff.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        btnLogOff.setText("Log Off");
        btnLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLogOffActionPerformed(evt);
            }
        });

        btnCancelLogOff.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        btnCancelLogOff.setText("Cancel");
        btnCancelLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelLogOffActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(11, Short.MAX_VALUE)
                .addComponent(btnLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 113, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE)
                .addComponent(btnCancelLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(33, 33, 33))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lblLogOffHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(53, 53, 53))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(42, 42, 42)
                .addComponent(lblLogOffHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(45, 45, 45)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCancelLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(37, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout dlgConfirmLogOffLayout = new javax.swing.GroupLayout(dlgConfirmLogOff.getContentPane());
        dlgConfirmLogOff.getContentPane().setLayout(dlgConfirmLogOffLayout);
        dlgConfirmLogOffLayout.setHorizontalGroup(
            dlgConfirmLogOffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        dlgConfirmLogOffLayout.setVerticalGroup(
            dlgConfirmLogOffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jLabel7.setText("jLabel7");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBackground(new java.awt.Color(247, 235, 248));

        pnlMainPanel.setBackground(new java.awt.Color(247, 235, 248));
        pnlMainPanel.setMinimumSize(new java.awt.Dimension(1030, 670));
        pnlMainPanel.setPreferredSize(new java.awt.Dimension(1030, 670));
        pnlMainPanel.setSize(new java.awt.Dimension(1030, 670));

        jTabbedPane1.setBackground(new java.awt.Color(247, 235, 248));
        jTabbedPane1.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        jTabbedPane1.setMinimumSize(new java.awt.Dimension(990, 640));
        jTabbedPane1.setPreferredSize(new java.awt.Dimension(990, 640));
        jTabbedPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTabbedPane1MouseClicked(evt);
            }
        });

        pnlStudents.setBackground(new java.awt.Color(255, 255, 255));
        pnlStudents.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        pnlStudents.setPreferredSize(new java.awt.Dimension(750, 450));
        pnlStudents.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                pnlStudentsComponentShown(evt);
            }
        });

        btnAddStudent.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        btnAddStudent.setText("<html><center>ADD NEW<br>STUDENT<center>");
        btnAddStudent.setActionCommand("");
        btnAddStudent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddStudentActionPerformed(evt);
            }
        });

        btnDeleteStudent.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        btnDeleteStudent.setText("<html><center>DELETE<br>STUDENT<center>");
        btnDeleteStudent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteStudentActionPerformed(evt);
            }
        });

        tblStudentList.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        tblStudentList.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        tblStudentList.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                tblStudentListComponentShown(evt);
            }
        });
        jScrollPane1.setViewportView(tblStudentList);

        jLabel4.setFont(new java.awt.Font("Skia", 1, 28)); // NOI18N
        jLabel4.setText("Students");

        lblStudentSearch.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        lblStudentSearch.setText("Student Search:");

        btnStudentSearch.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        btnStudentSearch.setText("SEARCH");
        btnStudentSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStudentSearchActionPerformed(evt);
            }
        });

        btnViewAllStudents.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        btnViewAllStudents.setText("<html><center>VIEW ALL<br>STUDENTS<html>");
        btnViewAllStudents.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewAllStudentsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlStudentsLayout = new javax.swing.GroupLayout(pnlStudents);
        pnlStudents.setLayout(pnlStudentsLayout);
        pnlStudentsLayout.setHorizontalGroup(
            pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlStudentsLayout.createSequentialGroup()
                .addGap(13, 13, 13)
                .addGroup(pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, pnlStudentsLayout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addGap(140, 140, 140)
                        .addComponent(lblStudentSearch)
                        .addGap(18, 18, 18)
                        .addComponent(txtStudentSearch, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(27, 27, 27)
                        .addComponent(btnStudentSearch, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 773, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(27, 27, 27)
                .addGroup(pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(btnDeleteStudent)
                    .addComponent(btnAddStudent, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
                    .addComponent(btnViewAllStudents))
                .addGap(563, 563, 563))
        );

        pnlStudentsLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {btnAddStudent, btnDeleteStudent, btnStudentSearch});

        pnlStudentsLayout.setVerticalGroup(
            pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlStudentsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(txtStudentSearch, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(lblStudentSearch)
                        .addComponent(btnStudentSearch, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlStudentsLayout.createSequentialGroup()
                        .addGap(50, 50, 50)
                        .addComponent(btnViewAllStudents, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(15, 15, 15)
                        .addComponent(btnAddStudent, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(btnDeleteStudent, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 492, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Students", pnlStudents);

        pnlMarks.setBackground(new java.awt.Color(255, 255, 255));
        pnlMarks.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        pnlMarks.setPreferredSize(new java.awt.Dimension(750, 450));
        pnlMarks.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                pnlMarksComponentShown(evt);
            }
        });

        btnAddMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnAddMark.setText("<html><center> ADD <br>MARK<center>");
        btnAddMark.setToolTipText("");
        btnAddMark.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddMarkActionPerformed(evt);
            }
        });

        btnDeleteMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnDeleteMark.setText("<html><center>DELETE<br>MARK<center>");
        btnDeleteMark.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteMarkActionPerformed(evt);
            }
        });

        tblStudentSubjectMarks.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        tblStudentSubjectMarks.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        tblStudentSubjectMarks.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                tblStudentSubjectMarksComponentShown(evt);
            }
        });
        jScrollPane2.setViewportView(tblStudentSubjectMarks);

        cmbSubject.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        cmbSubject.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "ALL SUBJECTS", "ENGLISH HL", "AFRIKAANS HL", "MATHEMATICS", "MATHEMATICAL LITERACY", "AFRIKAANS FAL", "ISIZULU FAL", "SESOTHO FAL", "LIFE ORIENTATION", "ACCOUNTING", "AP MATHEMATICS", "AP ENGLISH", "AP AFRIKAANS", "DRAMATIC ARTS", "DESIGN", "FRENCH", "GEOGRAPHY", "GERMAN", "SPANISH ", "HISTORY", "INFORMATION TECHNOLOGY", "ITALIAN", "LIFE SCIENCES ", "MUSIC ", "PHYSICAL SCIENCES", "SPANISH ", "VISUAL ARTS", " " }));
        cmbSubject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbSubjectActionPerformed(evt);
            }
        });

        cmbTimeOfYear.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        cmbTimeOfYear.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "ALL", "MID", "END" }));
        cmbTimeOfYear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbTimeOfYearActionPerformed(evt);
            }
        });

        cmbYearOfStudy.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        cmbYearOfStudy.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        cmbYearOfStudy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbYearOfStudyActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        jLabel1.setText("Subject:");

        jLabel2.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        jLabel2.setText("<html><center>Time of Year:<center>");

        jLabel3.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        jLabel3.setText("Year of Study:");

        jLabel5.setFont(new java.awt.Font("Skia", 1, 28)); // NOI18N
        jLabel5.setText("Marks");

        jLabel6.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        jLabel6.setText("Matric Year:");

        cmbMatricYear.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        cmbMatricYear.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "ALL", "2020", "2021", "2022", "2023", "2024", "2025", "2026" }));
        cmbMatricYear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbMatricYearActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlMarksLayout = new javax.swing.GroupLayout(pnlMarks);
        pnlMarks.setLayout(pnlMarksLayout);
        pnlMarksLayout.setHorizontalGroup(
            pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMarksLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addGroup(pnlMarksLayout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbSubject, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbTimeOfYear, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbYearOfStudy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbMatricYear, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(pnlMarksLayout.createSequentialGroup()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 808, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(btnAddMark, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnDeleteMark, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlMarksLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {btnAddMark, btnDeleteMark});

        pnlMarksLayout.setVerticalGroup(
            pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlMarksLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(cmbSubject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbTimeOfYear, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3)
                    .addComponent(cmbYearOfStudy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6)
                    .addComponent(cmbMatricYear, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlMarksLayout.createSequentialGroup()
                        .addComponent(btnAddMark, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(btnDeleteMark, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 494, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlMarksLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {btnAddMark, btnDeleteMark});

        jTabbedPane1.addTab("Marks", pnlMarks);

        javax.swing.GroupLayout pnlMainPanelLayout = new javax.swing.GroupLayout(pnlMainPanel);
        pnlMainPanel.setLayout(pnlMainPanelLayout);
        pnlMainPanelLayout.setHorizontalGroup(
            pnlMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMainPanelLayout.createSequentialGroup()
                .addGap(49, 49, 49)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(39, Short.MAX_VALUE))
        );
        pnlMainPanelLayout.setVerticalGroup(
            pnlMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMainPanelLayout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(16, Short.MAX_VALUE))
        );

        jMenu1.setText("Options");
        jMenu1.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        mnuHelp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_H, java.awt.event.InputEvent.SHIFT_MASK));
        mnuHelp.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuHelp.setText("Help");
        mnuHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuHelpActionPerformed(evt);
            }
        });
        jMenu1.add(mnuHelp);

        mnuLogOff.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.SHIFT_MASK));
        mnuLogOff.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuLogOff.setText("Log Off");
        mnuLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuLogOffActionPerformed(evt);
            }
        });
        jMenu1.add(mnuLogOff);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnlMainPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 1078, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(pnlMainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        dlgAddNewStudent.setVisible(false);
        this.setVisible(true);
        

        // TODO add your handling code here:
    }//GEN-LAST:event_btnCancelActionPerformed

    /**
     *A Helper method which populates a specified table with a previously 
     *determined ResultSet
     * @param rs - The resultSet used to populate the table
     * @param table - The table to be populated
     */
    public void resultSetToTableModel(ResultSet rs, JTable table)
    {
        //create a new table
        DefaultTableModel tabMod = new DefaultTableModel();
        
        try {
            //retrieve meta data from resultSet
            ResultSetMetaData metaData = rs.getMetaData();
            
            //get the number of columns from the metaData
            int numColumn = metaData.getColumnCount();
            
            //get all column names from the meta data and add columns to the table model
            for(int columnIndex = 1; columnIndex <= numColumn; columnIndex++)
            {
               tabMod.addColumn(metaData.getColumnLabel(columnIndex));
            }
            
        //Create array of Objects with size of column count from meta data
        Object[] row = new Object[numColumn];

        //Scroll through result set
        while (rs.next()){
            //Get object from column with specific index of result set to array of objects
            for (int i = 0; i < numColumn; i++){
                row[i] = rs.getObject(i+1);
            }
            //Now add row to table model with that array of objects as an argument
            tabMod.addRow(row);
        }

        //Now add that table model to your table and you are done :D
        table.setModel(tabMod);
        } catch (SQLException ex) {
            System.out.println("Error! " + ex); 
        }
    }
    
    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
       
        
        //Insert a new record into the database if all data is valid
        boolean valid = true;
        String uname = txtUsername.getText();
        char [] pswd = pswdStudentPassword.getPassword();
        char [] conPswd = pswdConfirmPassword.getPassword();
        String matric = txtMatriculationYear.getText();
        String email = txtEmail.getText();
        
         
         
        //Checks that the password in the student password box matches the password in the confirm box
        String pw = "";
        
        for(char ch : pswd)
        {
            pw = pw + ch;
        }
        
        String pw2 ="";
        
        for(char ch: conPswd)
        {
            pw2 = pw2 + ch;
        }
        
        if(!pw.equals(pw2))
        {
            JOptionPane.showMessageDialog(this, "Passwords do not match");
            valid = false;
        }
        
        if(valid)
        {
            String result = sSQL.addStudent(uname, pw, matric, email);
           
            
            if(result.equals("Successful!"))
            {
                JOptionPane.showMessageDialog(pnlMainPanel, "Record successfully added");
                ResultSet rs = sSQL.getAllStudents2();
                resultSetToTableModel(rs,tblStudentList);
                dlgAddNewStudent.setVisible(false);
                this.setVisible(true);
                
                //clearing the inputted data from the text fields
                txtUsername.setText("");
                txtEmail.setText("");
                txtMatriculationYear.setText("");
                pswdStudentPassword.setText(null);
                pswdConfirmPassword.setText(null);
                
            }
            else
            {
               
                JOptionPane.showMessageDialog(pnlMainPanel,"Error adding record to the database");
                
            }
                    
                   
        }

       
    }//GEN-LAST:event_btnSaveActionPerformed

    /**
     *A helper method which removes a specified row from the table
     * @param table - the table from which the row will be removed
     * @param row - the selected row to be removed
     */
    public void removeRowFromTable(JTable table, int row)
    {
            DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
            if (row >= 0) {

                tableModel.removeRow(row);
            }
        
    }
    
    /**
     * Helper method that opens the specified dialog. 
     * @param dialog -The dialog to be opened
     * @param width -The width of the dialog
     * @param height -The height of the dialog
     */
    private void openDialog(JDialog dialog, int width, int height)
    {
        dialog.setSize(width, height);
        dialog.setLocation(dim.width/2-dialog.getSize().width/2, dim.height/2-dialog.getSize().height/2);
        dialog.setVisible(true);
    }//end openDialog
 
    
    //Helper method that opens the specified dialog and closes other open dialogs
  
    private void openDialogOnly(JDialog dialog, int width, int height)
    {
        dialog.setSize(width, height);
        dialog.setLocation(dim.width/2-dialog.getSize().width/2, dim.height/2-dialog.getSize().height/2);
        dialog.setVisible(true);
        this.setVisible(false);
    }//end openDialogOnly   
    
    /**
     * Helper method that closes the specified dialog. 
     * @param dialog -The dialog to be closed
     */
    private void closeDialog(JDialog dialog)
    {
        dialog.setVisible(false);
        this.setVisible(true);
    }//end closeDialog()
     
        
        
            
  
    
//confirm deletion of selected student
    private void btnConfirmDeletionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnConfirmDeletionActionPerformed
    closeDialog(dlgDeleteStudent);
    String deleted  = sSQL.deleteStudent(recordID);
    JOptionPane.showMessageDialog(pnlMainPanel, deleted);
    if(deleted.equalsIgnoreCase("Successful!"))
    {
        removeRowFromTable(tblStudentList,row);
    }
 
    //method to delete a mark record from the database
  
    }//GEN-LAST:event_btnConfirmDeletionActionPerformed

    private void btnDeleteMarkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteMarkActionPerformed
        row = tblStudentSubjectMarks.getSelectedRow();
        System.out.println("ROW: " + row);
        
        //checking if a mark record has been selected
        if(row <0)
        {
            JOptionPane.showMessageDialog(rootPane,"You need to select the record you want to delete");
            
        }
        else
        {
            //extract the data from the jTable
            recordID = Integer.parseInt(tblStudentSubjectMarks.getModel().getValueAt(row,0).toString());
            subject = tblStudentSubjectMarks.getModel().getValueAt(row, 1).toString();
            timeOfYear = tblStudentSubjectMarks.getModel().getValueAt(row,2).toString();
            yearOfStudy = tblStudentSubjectMarks.getModel().getValueAt(row,3).toString();
            
            System.out.println("RECORDID: " + recordID + "\nSUBJECT: " + subject + "\n"
                    + " TIMEOFYEAR: " + timeOfYear + "\nYEAROFSTUDY: " + yearOfStudy);
            
            
            SubjectMark mark = mSQL.getMark(recordID,subject,timeOfYear,yearOfStudy);
            
            openDialog(dlgDeleteMark,354,178);
             
            
        }
        
        
       
    
    
        
    }//GEN-LAST:event_btnDeleteMarkActionPerformed

    private void btnAddMarkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddMarkActionPerformed
        openDialog(dlgAddNewMark,484,503);
    }//GEN-LAST:event_btnAddMarkActionPerformed

    private void tblStudentListComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_tblStudentListComponentShown
        ResultSet rs = sSQL.getAllStudents2();
        resultSetToTableModel(rs,tblStudentList);
        

       
    }//GEN-LAST:event_tblStudentListComponentShown

    
    
    
    private void btnDeleteStudentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteStudentActionPerformed
       
        row = tblStudentList.getSelectedRow();
        System.out.println("ROW" + row);

        //checking if a student has been specified
        if(row < 0)
        {
            JOptionPane.showMessageDialog(rootPane, "You need to select the student you want to delete");

        }
        else
        {
            
            recordID = Integer.parseInt(tblStudentList.getModel().getValueAt(row, 0).toString());
            
            System.out.println("RECORD ID: " + recordID); 
            System.out.println("Student ID: " + recordID);
            
            Student student = sSQL.getStudent(recordID);
            openDialog(dlgDeleteStudent,350,250);
            lblDeleteStudentMessage.setText("<html><center>Are you sure you want to delete " +student.getUsername()  + " and all their data <br>from the database?<center>");
            
           
             
            
            

        }

  
    }//GEN-LAST:event_btnDeleteStudentActionPerformed


    private void btnAddStudentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddStudentActionPerformed
        openDialogOnly(dlgAddNewStudent,400,443);
       
    }//GEN-LAST:event_btnAddStudentActionPerformed

    private void pnlStudentsComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_pnlStudentsComponentShown
        //displays the data from TBLUSERS in the jTable
        ResultSet rs = sSQL.getAllStudents2();
        resultSetToTableModel(rs,tblStudentList);

    
    }//GEN-LAST:event_pnlStudentsComponentShown

    
    private void pnlMarksComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_pnlMarksComponentShown
       //displays the data from TBLSTUDENTSUBJECTMARKS in the jTable
        ResultSet rs = mSQL.getAllMarks();
        resultSetToTableModel(rs,tblStudentSubjectMarks);


        // TODO add your handling code here:
    }//GEN-LAST:event_pnlMarksComponentShown

    private void txtUsernameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtUsernameActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_txtUsernameActionPerformed

    private void pnlAddNewStudentComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_pnlAddNewStudentComponentShown
        // TODO add your handling code here:
    }//GEN-LAST:event_pnlAddNewStudentComponentShown

    private void btnDeleteStudentCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteStudentCancelActionPerformed
        dlgDeleteStudent.setVisible(false);
        this.setVisible(true);


        
    }//GEN-LAST:event_btnDeleteStudentCancelActionPerformed

    private void tblStudentSubjectMarksComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_tblStudentSubjectMarksComponentShown

    }//GEN-LAST:event_tblStudentSubjectMarksComponentShown

    //confirms deletion of selected mark record
    private void btnConfirmMarkDeletionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnConfirmMarkDeletionActionPerformed
     closeDialog(dlgDeleteMark);
     
     
     String deleted = mSQL.deleteSelectedMark(recordID, subject, timeOfYear, yearOfStudy);
     JOptionPane.showMessageDialog(pnlMainPanel,deleted);
     
     if(deleted.equalsIgnoreCase("Successful!"))
     {
         System.out.println("Row: " + row);
         removeRowFromTable(tblStudentSubjectMarks,row);
         
     }
        
       
        
    }//GEN-LAST:event_btnConfirmMarkDeletionActionPerformed

    private void btnCancelMarkDeletionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelMarkDeletionActionPerformed
        closeDialog(dlgDeleteMark) ;    
    }//GEN-LAST:event_btnCancelMarkDeletionActionPerformed

    private void txtAddNewMarkMarkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtAddNewMarkMarkActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_txtAddNewMarkMarkActionPerformed

    private void txtAddNewMarkUsernameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtAddNewMarkUsernameActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_txtAddNewMarkUsernameActionPerformed

    private void txtAddNewMarkSubjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtAddNewMarkSubjectActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_txtAddNewMarkSubjectActionPerformed

    private void txtAddNewMarkTOYActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtAddNewMarkTOYActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_txtAddNewMarkTOYActionPerformed

    private void btnAddNewMarkSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddNewMarkSaveActionPerformed

    
        boolean valid = true;
        String uname = txtAddNewMarkUsername.getText();
        String sub = txtAddNewMarkSubject.getText();
        String toy = txtAddNewMarkTOY.getText();
        String yos = txtAddNewMarkYOS.getText();
        int mark = Integer.parseInt(txtAddNewMarkMark.getText());
        String result = "";
        int uID = sSQL.getStudentID(uname);
        
        if(uID == -1)
        {
            valid = false; 
        }
        
        
        
        
           
        
        
        
        
        
        if(valid)
        {
          result = mSQL.addMark(uID,sub,toy,yos,mark);
        }
            if(result.equals("Successful!"))
            {
                //repopulate the table including the new record
                JOptionPane.showMessageDialog(pnlMainPanel,"Record successfully added");
                ResultSet rs= mSQL.getAllMarks();
                resultSetToTableModel(rs, tblStudentSubjectMarks);
                closeDialog(dlgAddNewMark);
                
                //clearing the inputted data from the text fields
                txtAddNewMarkUsername.setText("");
                txtAddNewMarkSubject.setText("");
                txtAddNewMarkTOY.setText("");
                txtAddNewMarkYOS.setText("");
                txtAddNewMarkMark.setText(null);

            }
            else
            {
                
                JOptionPane.showMessageDialog(pnlMainPanel, "Error adding record to the database: A record with information from that "
                        + "subject, time of year and year of study may already exist");
                        
                //clearing the inputted data from the text fields
                txtAddNewMarkUsername.setText("");
                txtAddNewMarkSubject.setText("");
                txtAddNewMarkTOY.setText("");
                txtAddNewMarkYOS.setText("");
                txtAddNewMarkMark.setText(null);            
            }
        
        
                //search for the username in the TBLUSERS table to see if the user exists. if not, output an error message
        

     
    }//GEN-LAST:event_btnAddNewMarkSaveActionPerformed

    
    private void cmbSubjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbSubjectActionPerformed
    tblSSMRefresh();
    
     
    }//GEN-LAST:event_cmbSubjectActionPerformed

    private void cmbYearOfStudyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbYearOfStudyActionPerformed
    tblSSMRefresh();        // TODO add your handling code here:
    }//GEN-LAST:event_cmbYearOfStudyActionPerformed

    private void cmbTimeOfYearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbTimeOfYearActionPerformed
        tblSSMRefresh();
        // TODO add your handling code here:
    }//GEN-LAST:event_cmbTimeOfYearActionPerformed

    private void btnStudentSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStudentSearchActionPerformed

    String student = txtStudentSearch.getText();    
    int sID = sSQL.getStudentID(student);
    ResultSet rs = sSQL.getStudentRecord(sID);
    resultSetToTableModel(rs, tblStudentList);
    txtStudentSearch.setText("");
    
        

        // TODO add your handling code here:
    }//GEN-LAST:event_btnStudentSearchActionPerformed

    private void mnuHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuHelpActionPerformed
        openDialog(dlgHelp,440,715);


        // TODO add your handling code here:
    }//GEN-LAST:event_mnuHelpActionPerformed

    private void mnuLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuLogOffActionPerformed
        openDialog(dlgConfirmLogOff,321,208);

        // TODO add your handling code here:
    }//GEN-LAST:event_mnuLogOffActionPerformed

    private void btnLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLogOffActionPerformed
        dlgConfirmLogOff.setVisible(false);
        this.setVisible(false);
        new LoginGUI().setVisible(true);        


        // TODO add your handling code here:
    }//GEN-LAST:event_btnLogOffActionPerformed

    private void btnCancelLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelLogOffActionPerformed
    dlgConfirmLogOff.setVisible(false);
        // TODO add your handling code here:
    }//GEN-LAST:event_btnCancelLogOffActionPerformed

    private void btnCloseHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCloseHelpActionPerformed
        dlgHelp.setVisible(false);
        // TODO add your handling code here:
    }//GEN-LAST:event_btnCloseHelpActionPerformed

    private void btnViewAllStudentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewAllStudentsActionPerformed
    ResultSet rs = sSQL.getAllStudents();
    resultSetToTableModel(rs, tblStudentList);
        
    }//GEN-LAST:event_btnViewAllStudentsActionPerformed

    private void cmbMatricYearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbMatricYearActionPerformed
       tblSSMRefresh();

        // TODO add your handling code here:
    }//GEN-LAST:event_cmbMatricYearActionPerformed

    private void jTabbedPane1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTabbedPane1MouseClicked
      tblSSMRefresh();


        // TODO add your handling code here:
    }//GEN-LAST:event_jTabbedPane1MouseClicked

    private void btnAddNewMarkCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddNewMarkCancelActionPerformed

        dlgAddNewMark.setVisible(false);

        // TODO add your handling code here:
    }//GEN-LAST:event_btnAddNewMarkCancelActionPerformed

    
    private void tblSSMRefresh()
    {
       String subject = cmbSubject.getSelectedItem().toString();  
       String toy = cmbTimeOfYear.getSelectedItem().toString();
       String yos = cmbYearOfStudy.getSelectedItem().toString();
       String matric = cmbMatricYear.getSelectedItem().toString();
       
       
       System.out.println(subject + " " + toy + " " + yos + " " + matric);
       ResultSet rs  = mSQL.getMarks(subject,toy,yos,matric);
       resultSetToTableModel(rs,tblStudentSubjectMarks);
       

       
       
    }
    

    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(AdminGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(AdminGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(AdminGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(AdminGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new AdminGUI().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddMark;
    private javax.swing.JButton btnAddNewMarkCancel;
    private javax.swing.JButton btnAddNewMarkSave;
    private javax.swing.JButton btnAddStudent;
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnCancelLogOff;
    private javax.swing.JButton btnCancelMarkDeletion;
    private javax.swing.JButton btnCloseHelp;
    private javax.swing.JButton btnConfirmDeletion;
    private javax.swing.JButton btnConfirmMarkDeletion;
    private javax.swing.JButton btnDeleteMark;
    private javax.swing.JButton btnDeleteStudent;
    private javax.swing.JButton btnDeleteStudentCancel;
    private javax.swing.JButton btnLogOff;
    private javax.swing.JButton btnSave;
    private javax.swing.JButton btnStudentSearch;
    private javax.swing.JButton btnViewAllStudents;
    private javax.swing.JComboBox<String> cmbMatricYear;
    private javax.swing.JComboBox<String> cmbSubject;
    private javax.swing.JComboBox<String> cmbTimeOfYear;
    private javax.swing.JComboBox<String> cmbYearOfStudy;
    private javax.swing.JDialog dlgAddNewMark;
    private javax.swing.JDialog dlgAddNewStudent;
    private javax.swing.JDialog dlgConfirmLogOff;
    private javax.swing.JDialog dlgDeleteMark;
    private javax.swing.JDialog dlgDeleteStudent;
    private javax.swing.JDialog dlgHelp;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu4;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuBar jMenuBar2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel lblAddMarkSubject;
    private javax.swing.JLabel lblAddMarkTOY;
    private javax.swing.JLabel lblAddMarkUsername;
    private javax.swing.JLabel lblAddMarkYOS;
    private javax.swing.JLabel lblAddNewMarkMark;
    private javax.swing.JLabel lblConfirmMarkDeletion;
    private javax.swing.JLabel lblConfirmPassword;
    private javax.swing.JLabel lblDeleteStudentMessage;
    private javax.swing.JLabel lblEmail;
    private javax.swing.JLabel lblHelpHeader;
    private javax.swing.JLabel lblLogOffHeader;
    private javax.swing.JLabel lblMatriculationYear;
    private javax.swing.JLabel lblNewMarkHeader;
    private javax.swing.JLabel lblNewStudentHeader;
    private javax.swing.JLabel lblP1;
    private javax.swing.JLabel lblP10;
    private javax.swing.JLabel lblP2;
    private javax.swing.JLabel lblP3;
    private javax.swing.JLabel lblP4;
    private javax.swing.JLabel lblP5;
    private javax.swing.JLabel lblP6;
    private javax.swing.JLabel lblP7;
    private javax.swing.JLabel lblP8;
    private javax.swing.JLabel lblP9;
    private javax.swing.JLabel lblStudentPassword;
    private javax.swing.JLabel lblStudentSearch;
    private javax.swing.JLabel lblUsername;
    private javax.swing.JMenuItem mnuHelp;
    private javax.swing.JMenuItem mnuLogOff;
    private javax.swing.JPanel pnlAddNewMark;
    private javax.swing.JPanel pnlAddNewStudent;
    private javax.swing.JPanel pnlDeleteStudent;
    private javax.swing.JPanel pnlMainPanel;
    private javax.swing.JPanel pnlMarks;
    private javax.swing.JPanel pnlStudents;
    private javax.swing.JPasswordField pswdConfirmPassword;
    private javax.swing.JPasswordField pswdStudentPassword;
    private javax.swing.JTable tblStudentList;
    private javax.swing.JTable tblStudentSubjectMarks;
    private javax.swing.JTextField txtAddNewMarkMark;
    private javax.swing.JTextField txtAddNewMarkSubject;
    private javax.swing.JTextField txtAddNewMarkTOY;
    private javax.swing.JTextField txtAddNewMarkUsername;
    private javax.swing.JTextField txtAddNewMarkYOS;
    private javax.swing.JTextField txtEmail;
    private javax.swing.JTextField txtMatriculationYear;
    private javax.swing.JTextField txtStudentSearch;
    private javax.swing.JTextField txtUsername;
    // End of variables declaration//GEN-END:variables
}
