/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package pat2021;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author bee.ntsimane
 */
public class MarkSQL {
    
    private DBClass db = new DBClass();
    
    private SubjectMark [] markArr = new SubjectMark [20];
    private int size = 0; 
    private StudentSQL sSQL = new StudentSQL();
    
    /**
     * Method used to retrieve all marks in the database and
     * populate the jTable tblStudentSubjectMarks 
     * @return ResultSet of all marks
     */
    public ResultSet getAllMarks()
    {
        
        String stmt = "SELECT TBLUSERS.USERID, SUBJECT, TIMEOFYEAR, YEAROFSTUDY,"
                + " MARK, MATRICYEAR FROM TBLUSERS "
                + "INNER JOIN TBLSTUDENTSUBJECTMARKS ON TBLUSERS.USERID = "
                + "TBLSTUDENTSUBJECTMARKS.USERID";
        System.out.println(stmt);
        
        try {
            ResultSet rs = db.query(stmt);
            return rs;
        } catch (SQLException ex) {
            System.out.println("Error Accessing TBLSTUDENTSUBJECTMARKS");
            return null;
        }
    }
    

    /**
     *method used to get the mark of a specific record
     * @param recordID - the ID of the specific mark record
     * @param sub - the subject of the specific mark record
     * @param toy - the time of year of the specific mark record
     * @param yos - the year of subject of the specific mark record
     * @return a SubjectMark object
     */
    public SubjectMark getMark(int recordID, String sub, String toy, String yos)
    {
        String stmt = "SELECT * FROM TBLSTUDENTSUBJECTMARKS WHERE USERID =" + recordID + "AND SUBJECT = '" + sub
                + "' AND TIMEOFYEAR = '" + toy +  "' AND YEAROFSTUDY = '" + yos + "' ";
        
        System.out.println(stmt);
        ResultSet rs;
        SubjectMark mark =  null;
        
        try {
            rs = db.query(stmt);
            if(rs.next())
            {
                //extract elements to populate the mark record
                int userID = rs.getInt("USERID");
                String subject = rs.getString("SUBJECT");
                String timeOfYear = rs.getString("TIMEOFYEAR");
                String yearOfStudy = rs.getString("YEAROFSTUDY");
                int numMark = rs.getInt("MARK");
                
                mark = new SubjectMark(userID,subject,timeOfYear,yearOfStudy,numMark);
            }
            return mark;
            
            
        } catch (SQLException ex) {
            System.out.println("Error accessing mark");
            System.out.println(ex);
            return null;
        }
    }
    

    
    /**
     * A method used to add a mark record to the TBLSTUDENTSUBJECTMARKS database
     * @param uID - the userID of the student whose mark record is being added
     * @param sub - the subject of the new mark record
     * @param toy - the time of year of the new mark record
     * @param yos - the year of study of the new mark record
     * @param mark - the mark value of the new mark record
     * @return - a string value indicating whether the record was successfully added or not
     */
    public String addMark(int uID, String sub, String toy, String yos, int mark)
    {
       String stmt = "INSERT INTO TBLSTUDENTSUBJECTMARKS (USERID, SUBJECT, TIMEOFYEAR, YEAROFSTUDY, MARK)" + 
               "VALUES (" + uID + ",'" + sub + "','" + toy + "','" + yos + "'," + mark +")";
        System.out.println(stmt);
        
        try {
            db.update(stmt);
            return "Successful!";
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubjectMarks: refer to addMark method");
            System.out.println(ex);
            return "Error";
        }
               
              
    }
    
   
    

    /**
     * method to delete a mark record from the database
     * @param recordID - the recordID of the required record
     * @param sub - the subject in the required record
     * @param toy - the time of year in the required record
     * @param yos - the year of study in the required record
     * @return - a string indicating whether the record was successfully deleted or not
     */
    public String deleteSelectedMark(int recordID, String sub, String toy, String yos)
    {
        
        String stmt = "DELETE FROM TBLSTUDENTSUBJECTMARKS WHERE USERID = " + recordID + " AND SUBJECT = '" + sub + "'\n"
                + "AND TIMEOFYEAR = '" + toy + "' AND YEAROFSTUDY = '" + yos + "' ";
        System.out.println(stmt);
        
                      
        try {
            db.update(stmt);
            return "Successful!";
            
         } catch (SQLException ex) {
            System.out.println("Error accessing marks table");
            System.out.println(ex);
            return "Error";
        }
    } 
    


    /**
     * a method that gets all the mark records of a particular student
     * @param uID - the userID of the user whose mark records are needed
     * @return a resultSet of all the mark records of the particular student
     */
    public ResultSet getStudentMarks(int uID)
    {
        ResultSet rs = null;
        try {
            
            String stmt = "SELECT SUBJECT, TIMEOFYEAR, YEAROFSTUDY, MARK, USERNAME, MATRICYEAR "
                    + "FROM TBLUSERS INNER JOIN TBLSTUDENTSUBJECTMARKS ON TBLUSERS.USERID = "
                    + "TBLSTUDENTSUBJECTMARKS.USERID WHERE TBLUSERS.USERID = "+ uID + " ORDER BY YEAROFSTUDY";
             System.out.println(stmt);
             rs = db.query(stmt);
           
            
           
            
            
          
        } catch (SQLException ex) {
            System.out.println("Error accessing tables - refer to getStudentMarks");
            System.out.println(ex);
            
        }
        return rs;
    }
    
    
    

    /**
     * a method used to obtain the final year average of student
     * @param uID - the userID of the specific user
     * @param year - the year of study of the mark records needed to obtain an average
     * @return
     */
   public int getFinalAverage(int uID,String year)
    {
        int total = 0;
        int avg = 0;
        ResultSet rs = null;
        int count = 0;
        
       
            
        try {
           
        String stmt = "SELECT MARK FROM TBLSTUDENTSUBJECTMARKS WHERE USERID =" + uID + "AND YEAROFSTUDY ='"+year+"'";
        rs = db.query(stmt);
        while(rs.next())
        {
           int mark = rs.getInt("MARK");
           total = total + mark; 
           count++;
        }
        
        //check if the selected year has no data values - null data validation
        if(count == 0)
        {
            System.out.println("no values for selected data"); 
        }
        else
        avg = total/count;
        
            System.out.println("Average: " + avg);
            
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubjectMarks: refer to getFinalAverage method " + ex);
        }
       
       return avg;
    }
   
   
 
 //method used to obtain final average of student

    /**
     *
     * @param uID
     * a method used to obtain the mid year average of student
     * @param uID - the userID of the specific user
     * @param year - the year of study of the mark records needed to obtain an average
     */
   public int getMidAverage(int uID, String year)
    {
        int total = 0;
        int avg = 0;
        ResultSet rs = null;
        int count = 0;
        
       
            
        try {
           
        String stmt = "SELECT * FROM TBLSTUDENTSUBJECTMARKS WHERE USERID =" + uID + "AND YEAROFSTUDY = '" + year + "'" + "AND TIMEOFYEAR LIKE 'MID'";
        rs = db.query(stmt);
         
        
        while(rs.next())
        {
           int mark = rs.getInt("MARK");
           
           total = total + mark; 
            System.out.println("total: " + total);
           count++;
        }
        //check if the selected year has no data values - null data validation 
        if(count == 0)
        {
            System.out.println("no values for selected data"); 
        }
        else
        avg = total/count;
        
            System.out.println("Average: " + avg);
            
            
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubjectMarks: refer to getMidAverage method" + " " + ex);
        }
       
       return avg;
    }
   
   


    /**
     *
     * a method used to obtain the end of year (term 3) average of student
     * @param uID - the userID of the specific user
     * @param year - the year of study of the mark records needed to obtain an average
     */
   public int getEndAverage(int uID,String year)
    {
        int total = 0;
        int avg = 0;
        ResultSet rs = null;
        int count = 0;
        
       
            
        try {
           
        String stmt = "SELECT MARK FROM TBLSTUDENTSUBJECTMARKS WHERE USERID =" + uID + "AND YEAROFSTUDY = '"+year+"'" + "AND TIMEOFYEAR LIKE 'END'";
        rs = db.query(stmt);
        while(rs.next())
        {
           int mark = rs.getInt("MARK");
           total = total + mark; 
           count++;
        }
        //check if the selected year has no data values - null data validation thing 
        if(count == 0)
        {
            System.out.println("no values for selected data"); 
        }
        else
        avg = total/count;
        
            System.out.println("Average: " + avg);
            
            
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubject Marks: refer to getEndAverage method" + " " + ex);
        }
       
       return avg;
    }
   
    /**
     * A method used to return the marks of a user based on selected parameters
     * @param sub - the subject of the mark records
     * @param toy - the time of year of the mark records
     * @param yos - the year of study of the mark records
     * @param matricYear - the matriculation year of the mark records
     * @return a resultSet of the mark records
     */
    public ResultSet getMarks(String sub, String toy, String yos, String matricYear)
   {
       
       ResultSet rs;
        String stmt = "SELECT TBLUSERS.USERID, SUBJECT, TIMEOFYEAR, YEAROFSTUDY,"
                + " MARK, MATRICYEAR FROM TBLUSERS INNER JOIN TBLSTUDENTSUBJECTMARKS  ON "
                + " TBLUSERS.USERID = TBLSTUDENTSUBJECTMARKS.USERID ";
        //subject
        if(!sub.equalsIgnoreCase("ALL SUBJECTS"))
        {
         stmt = stmt + "WHERE SUBJECT = '" + sub +"' ";
          
         //time of year
           if(!toy.equalsIgnoreCase("ALL")) 
           {
               stmt = stmt + "AND TIMEOFYEAR = '" + toy+"' ";
               
               //year of study
               if(!yos.equalsIgnoreCase("ALL"))
               {
                  stmt = stmt + "AND YEAROFSTUDY = '" + yos + "'";
               
               
                //matric year
                if(!matricYear.equalsIgnoreCase("ALL"))
                 {
                    stmt = stmt + " AND MATRICYEAR = '" + matricYear + "'"; 
                 }
                
               }
               


            }
           else
           {
               if(!yos.equalsIgnoreCase("ALL"))
               {
                  stmt = stmt + "AND YEAROFSTUDY = '" + yos + "'";
               
               
                  if(!matricYear.equalsIgnoreCase("ALL"))
                   {
                      stmt = stmt + " AND MATRICYEAR = '" + matricYear + "'"; 
                   }
               }
                 
           }

              
        }
        else
        {
        
          
         //time of year
           if(!toy.equalsIgnoreCase("ALL")) 
           {
               stmt = stmt + "WHERE TIMEOFYEAR = '" + toy + "' ";
               
               //year of study
               if(!yos.equalsIgnoreCase("ALL"))
               {
                  stmt = stmt + "AND YEAROFSTUDY = '" + yos + "'";
                   System.out.println("potato!");
               
                  if(!matricYear.equalsIgnoreCase("ALL"))
                   {
                      stmt = stmt + " AND MATRICYEAR = '" + matricYear + "'"; 
                   }
               }
            }
           else
               if(!yos.equalsIgnoreCase("ALL"))
               {
                  stmt = stmt + "WHERE YEAROFSTUDY = '" + yos + "'";
                  

                  if(!matricYear.equalsIgnoreCase("ALL"))
                   {
                      stmt = stmt + " AND MATRICYEAR = '" + matricYear + "'"; 
                   }
               
               }
               else
                  if(!matricYear.equalsIgnoreCase("ALL"))
                   {
                      stmt = stmt + " WHERE MATRICYEAR = '" + matricYear + "'"; 
                   }
        }
           
               
                       
     
            
            
       

       System.out.println(stmt);
       
        try {
            rs =db.query(stmt);
            return rs;

            
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubjectMarks: refer to getMarks method\n" + ex);
            return null;
        }
       
   }
   
    /**
     * A method that obtains all of the mark records from an inputted time of year 
     * @param toy - the specific time of year from which the records are to be obtained
     * @return a resultSet of all the mark records from the selected time of year
     */
    public ResultSet getMarksOfToY(String toy)
   {
        ResultSet rs;
        String stmt = "";
       if (toy.equalsIgnoreCase("ALL"))
       {
         stmt = "SELECT * FROM TBLSTUDENTSUBJECTMARKS";
       }
       else
       {
         stmt = "SELECT * FROM TBLSTUDENTSUBJECTMARKS WHERE TIMEOFYEAR = '" + toy +"'";
       }

       System.out.println(stmt);
       
        try {
            rs =db.query(stmt);
            return rs;

            
        } catch (SQLException ex) {
            System.out.println("Error accessing tblStudentSubjectMarks: refer to getMarksOfToY method");
            return null;
        }      
   }
    
    
    
    //

    /**
     * a method used to calculate a student's academic colours based on their marks
     * @param midAvg8 - the average of a student in term 2 of grade 8
     * @param endAvg8 - the average of a student in term 3 of grade 8
     * @param midAvg9 - the average of a student in term 2 of grade 9
     * @param endAvg9- the average of a student in term 3 of grade 9
     * @param midAvg10 - the average of a student in term 2 of grade 10
     * @param endAvg10 - the average of a student in term 3 of grade 10
     * @param midAvg11 - the average of a student in term 2 of grade 11
     * @param endAvg11 - the average of a student in term 3 of grade 11
     * @param midAvg12 - the average of a student in term 2 of grade 12
     * @param endAvg12 - the average of a student in term 3 of grade 12
     * @return a string of the colours award that the student will receive
     */
    public String getColours (int midAvg8, int endAvg8, int midAvg9, int endAvg9, int midAvg10, int endAvg10,
            int midAvg11, int endAvg11, int midAvg12, int endAvg12)
    {
        String colours = "No Award";

            if(midAvg8 >= 80)
            {
               colours = "HC -> Merit";
               if(endAvg8 >=80)
               {
                   colours = "Merit Certificate";
                   
                   if(midAvg9 >=80)
                   {
                       colours = "HC -> Half Colours";
                       
                       if(endAvg9 >=80)
                       {
                           colours = "Half Colours";
                       }  
                   }
                   else
                   {
                       if(endAvg9 >=80)
                       {
                           colours = "HC -> Half Colours";
                       }    
                   }
               }
               else
               {
                   //copied from here
                   if(midAvg9 >=80)
                   {
                       colours = "Merit Certificate";
                       
                       if(endAvg9 >=80)
                       {
                           colours = "HC -> Half Colours";
                       }  
                   }
                   else
                   {
                       if(endAvg9 >=80)
                       {
                           colours = "Merit Certificate";
                       }    
                   }  
                   
               }
            }
            else
            {
                
                //copied for the second round from here
               if(endAvg8 >=80)
               {
                   colours = "HC -> Merit";
                   
                   if(midAvg9 >=80)
                   {
                       colours = "Merit Certificate";
                       
                       if(endAvg9 >=80)
                       {
                           colours = "HC -> Half Colours";
                       }  
                   }
                   else
                   {
                       if(endAvg9 >=80)
                       {
                           colours = "Merit Certificate";
                       }    
                   }
               }
               else
               {
                  
                   if(midAvg9 >=80)
                   {
                       colours = "HC -> Merit";
                       
                       if(endAvg9 >=80)
                       {
                           colours = "Merit Certificate";
                       }  
                   }
                   else
                   {
                       if(endAvg9 >=80)
                       {
                           colours = "HC -> Merit";
                       }    
                   }  
                   
               }
            }
        
        //awards for grade 10 to 12
        if(colours.equalsIgnoreCase("Half Colours"))
        {
          if(midAvg10 >=75)
          {
              colours = "HC -> Full Colours";
              
              if(endAvg10>=75)
              {
                  colours = "Full Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Honours";
                      if (endAvg11 >=75)
                      {
                          colours = "Academic Honours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Honours";  
                          if(midAvg12 >=75)
                          {
                              colours = "Academic Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Academic Honours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Academic Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Honours";
                          if(midAvg12 >=75)
                          {
                              colours = "Academic Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Academic Honours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "Academic Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Academic Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }          
                  

          }
          else 
              if(endAvg10>=75)
              {
                  colours = "HC -> Full Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Honours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "Full Colours";
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }          
                  


        }
        else
            if(colours.equalsIgnoreCase("HC -> Half Colours"))
            { 
                if(midAvg10 >=75)
          if(midAvg10 >=75)
          {
              colours = "Half Colours";
              
              if(endAvg10>=75)
              {
                  colours = "HC -> Full Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Honours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "Full Colours";
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Honours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Honours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }          
                  

          }
          else 
              if(endAvg10>=75)
              {
                  colours = "Half Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "Full Colours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours"; 
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "Half Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Half Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Half Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }          
      
            }
            else
            {
               
                          
          if(midAvg10 >=75)
          {
              colours = "HC -> Half Colours";
              
              if(endAvg10>=75)
              {
                  colours = "Half Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Full Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "Full Colours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "Half Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";
                          if(midAvg12 >=75)
                          {
                              colours = "Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Half Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Half Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }          
                  

          }
          else 
              if(endAvg10>=75)
              {
                  colours = "HC -> Half Colours";
                  if(midAvg11 >= 75)
                  {
                      colours = "Half Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "HC -> Full Colours";
                      }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "Half Colours"; 
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "Half Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }    
                  
              }
              else 
                  if(midAvg11 >= 75)
                  {
                      colours = "HC -> Half Colours";
                      if (endAvg11 >=75)
                      {
                          colours = "Half Colours";
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Full Colours";
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                      }
                      else
                        if(midAvg12 >=75)
                          {
                              colours = "Half Colours";
                              
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }
                  }
                  else
                      if(endAvg11 >=75)
                      {
                          colours = "HC -> Half Colours";  
                          if(midAvg12 >=75)
                          {
                              colours = "Half Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Full Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }
                      }
                      else
                          if(midAvg12 >=75)
                          {
                              colours = "HC -> Half Colours";
                              if(endAvg12 >=75)
                              {
                                  colours = "Half Colours";
                              }
                          }
                          else
                              if(endAvg12 >=75)
                              {
                                  colours = "HC -> Half Colours";
                              }      
            }
        
 
        return colours; 
    }
    


    
    

    
    
    
        
        
}
