/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package pat2021;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;

/**
 * Generates a StudentGUI form and manages the accompanying functionality
 * @author bee.ntsimane
 */
public class StudentGUI extends javax.swing.JFrame {

        
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private StudentSQL sSQL = new StudentSQL();
    private MarkSQL mSQL = new MarkSQL();
    private int row;
    private int recordID;
    static Student student;
    private LocalDate topDate = LocalDate.now();
    private String yearOfStudy = Integer.toString(topDate.getYear());
    private String subject = "ALL";
   
    
    /**
     * Creates new form StudentGUI 
     * @param stud
     */
    public StudentGUI(Student stud) {
        initComponents();
        student = stud;
        //dlgDisplayMarks.setSize(600,600);

                
       
         //used to size image 
        String image = "Grade Mark Ladder.png";
        ImageIcon icon = new ImageIcon(image);
        ImageIcon newIcon = new ImageIcon(getScaledImage(icon.getImage(),434,776));
        lblMarksLadder.setSize(434,776);
        lblMarksLadder.setIcon(newIcon);//set image
                
    }
    
    //method to scale the image
    private Image getScaledImage(Image srcImg, int w, int h)
    {
        BufferedImage resizedImg = new BufferedImage(w,h,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }
    
    
     /**
     *A Helper method which populates a specified table with a previously 
     *determined ResultSet
     * @param rs - The resultSet used to populate the table
     * @param table - The table to be populated
     */
    public void resultSetToTableModel(ResultSet rs, JTable table)
    {
        //create a new table
        DefaultTableModel tabMod = new DefaultTableModel();
        
        try {
            //retrieve meta data from resultSet
            ResultSetMetaData metaData = rs.getMetaData();
            
            //get the number of columns from the metaData
            int numColumn = metaData.getColumnCount();
            
            //get all column names from the meta data and add columns to the table model
            for(int columnIndex = 1; columnIndex <= numColumn; columnIndex++)
            {
               tabMod.addColumn(metaData.getColumnLabel(columnIndex));
            }
            
        //Create array of Objects with size of column count from meta data
        Object[] row = new Object[numColumn];

        //Scroll through result set
        while (rs.next()){
            //Get object from column with specific index of result set to array of objects
            for (int i = 0; i < numColumn; i++){
                row[i] = rs.getObject(i+1);
            }
            //Now add row to table model with that array of objects as an argument
            tabMod.addRow(row);
        }

        //Now add that table model to your table and you are done :D
        table.setModel(tabMod);
        } catch (SQLException ex) {
            System.out.println("Error! " + ex); 
        }
    }
    
    
    
    
 /**
     * Helper method that opens the specified dialog and closes the main dialog
     * @param dialog -The dialog to be opened
     * @param width -The width of the dialog
     * @param height -The height of the dialog
     */
    private void openDialogOnly(JDialog dialog, int width, int height)
    {
        dialog.setSize(width, height);
        dialog.setLocation(dim.width/2-dialog.getSize().width/2, dim.height/2-dialog.getSize().height/2);
        dialog.setVisible(true);
        this.setVisible(false);
    }//end openDialog
     
    
   /**
     * Helper method that opens the specified dialog. 
     * @param dialog -The dialog to be opened
     * @param width -The width of the dialog
     * @param height -The height of the dialog
     */
    private void openDialog(JDialog dialog, int width, int height)
    {
        dialog.setSize(width, height);
        dialog.setLocation(dim.width/2-dialog.getSize().width/2, dim.height/2-dialog.getSize().height/2);
        dialog.setVisible(true);
       
    }//end openDialog
     
    /**
     * Helper method that closes the specified dialog. 
     * @param dialog -The dialog to be closed
     */
    private void closeDialog(JDialog dialog)
    {
        dialog.setVisible(false);
        this.setVisible(true);
    }//end closeDialog()
    
    

    
    
   
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        dlgDisplayMarks = new javax.swing.JDialog();
        jPanel1 = new javax.swing.JPanel();
        cmbSubject = new javax.swing.JComboBox<>();
        cmbYearOfStudy = new javax.swing.JComboBox<>();
        lblSelectMarksToView = new javax.swing.JLabel();
        lblSubject = new javax.swing.JLabel();
        lblYear = new javax.swing.JLabel();
        pnlChart = new javax.swing.JPanel();
        jMenuBar3 = new javax.swing.JMenuBar();
        mnuMarkOptions = new javax.swing.JMenu();
        mnuH = new javax.swing.JMenuItem();
        mnuAC = new javax.swing.JMenuItem();
        mnuMain = new javax.swing.JMenuItem();
        mnuLogOff = new javax.swing.JMenuItem();
        dlgMiniDisplayColours = new javax.swing.JDialog();
        jPanel3 = new javax.swing.JPanel();
        lblMiniDisplayColoursHeading = new javax.swing.JLabel();
        lblMidColours = new javax.swing.JLabel();
        lblMidAvg = new javax.swing.JLabel();
        btnDisplayColoursSummary = new javax.swing.JButton();
        lblEndAvg = new javax.swing.JLabel();
        lblFinalAvg = new javax.swing.JLabel();
        lblColoursValue = new javax.swing.JLabel();
        lblMidAvgMark = new javax.swing.JLabel();
        lblEndAvgMark = new javax.swing.JLabel();
        lblFinalAvgMark = new javax.swing.JLabel();
        btnCancel = new javax.swing.JButton();
        lblFinalYearColours = new javax.swing.JLabel();
        lblFinalColoursValue = new javax.swing.JLabel();
        dlgDisplayColours = new javax.swing.JDialog();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        lblMidAvgHeader = new javax.swing.JLabel();
        lblMidAvgAwardHeader = new javax.swing.JLabel();
        lblEndAvgHeader = new javax.swing.JLabel();
        lblEndAwardHeader = new javax.swing.JLabel();
        lblSubjectMarksView = new javax.swing.JLabel();
        lblMidAvgLV = new javax.swing.JLabel();
        lblMidAwardLV = new javax.swing.JLabel();
        lblEndAvgLV = new javax.swing.JLabel();
        lblEndAwardLV = new javax.swing.JLabel();
        lblMidAvgMV = new javax.swing.JLabel();
        lblMidAwardMV = new javax.swing.JLabel();
        lblEndAvgMV = new javax.swing.JLabel();
        lblEndAwardMV = new javax.swing.JLabel();
        lblMidAvgUV = new javax.swing.JLabel();
        lblMidAwardUV = new javax.swing.JLabel();
        lblEndAvgUV = new javax.swing.JLabel();
        lblEndAwardUV = new javax.swing.JLabel();
        lblEndAwardAM = new javax.swing.JLabel();
        lblEndAvgAM = new javax.swing.JLabel();
        lblMidAwardAM = new javax.swing.JLabel();
        lblMidAvgAM = new javax.swing.JLabel();
        lblMidAvgMatric = new javax.swing.JLabel();
        lblMidAwardMatric = new javax.swing.JLabel();
        lblEndAvgMatric = new javax.swing.JLabel();
        lblEndAwardMatric = new javax.swing.JLabel();
        lblDisplayColoursHeading = new javax.swing.JLabel();
        btnViewMarksLV = new javax.swing.JButton();
        btnViewMarksMV = new javax.swing.JButton();
        btnViewMarksUV = new javax.swing.JButton();
        btnViewMarksAM = new javax.swing.JButton();
        btnViewMarksMatric = new javax.swing.JButton();
        lblTable = new javax.swing.JLabel();
        jMenuBar2 = new javax.swing.JMenuBar();
        mnuOptions = new javax.swing.JMenu();
        mnuSummaryHelp = new javax.swing.JMenuItem();
        mnuSummaryLogOff = new javax.swing.JMenuItem();
        mnuSummaryAwards = new javax.swing.JMenuItem();
        mnuMainMenu = new javax.swing.JMenuItem();
        dlgHelp = new javax.swing.JDialog();
        jPanel6 = new javax.swing.JPanel();
        lblHelpHeader = new javax.swing.JLabel();
        lblP1 = new javax.swing.JLabel();
        lblP3 = new javax.swing.JLabel();
        lblP4 = new javax.swing.JLabel();
        lblP5 = new javax.swing.JLabel();
        lblP7 = new javax.swing.JLabel();
        lblP10 = new javax.swing.JLabel();
        lblP6 = new javax.swing.JLabel();
        lblP8 = new javax.swing.JLabel();
        lblP9 = new javax.swing.JLabel();
        btnClose = new javax.swing.JButton();
        dlgConfirmLogOff = new javax.swing.JDialog();
        jPanel5 = new javax.swing.JPanel();
        lblLogOffHeader = new javax.swing.JLabel();
        btnLogOff = new javax.swing.JButton();
        btnCancelLogOff = new javax.swing.JButton();
        jMenuItem2 = new javax.swing.JMenuItem();
        jButton1 = new javax.swing.JButton();
        pnlMainPanel = new javax.swing.JPanel();
        jTabbedPane2 = new javax.swing.JTabbedPane();
        pnlMarks = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        lblMatric = new javax.swing.JLabel();
        lblAnteMatric = new javax.swing.JLabel();
        lblUV = new javax.swing.JLabel();
        lblMV = new javax.swing.JLabel();
        lblLV = new javax.swing.JLabel();
        lblMarks = new javax.swing.JLabel();
        lblMarksLadder = new javax.swing.JLabel();
        pnlColoursProgress = new javax.swing.JPanel();
        lblAcademicColoursProgress = new javax.swing.JLabel();
        lblMatric2 = new javax.swing.JLabel();
        lblAnteMatric2 = new javax.swing.JLabel();
        lblUV2 = new javax.swing.JLabel();
        lblMV2 = new javax.swing.JLabel();
        lblLV2 = new javax.swing.JLabel();
        lblMarksLadder2 = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        menuOptions = new javax.swing.JMenu();
        menuItemLogoff = new javax.swing.JMenuItem();
        mnuHelp = new javax.swing.JMenuItem();
        menuItemCriteria = new javax.swing.JMenuItem();

        dlgDisplayMarks.setBackground(new java.awt.Color(247, 235, 248));

        jPanel1.setBackground(new java.awt.Color(247, 235, 248));
        jPanel1.setMaximumSize(new java.awt.Dimension(394, 294));
        jPanel1.setSize(new java.awt.Dimension(394, 294));

        cmbSubject.setBackground(new java.awt.Color(255, 255, 255));
        cmbSubject.setFont(new java.awt.Font("Skia", 1, 14)); // NOI18N
        cmbSubject.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "ALL", "AFRIKAANS HL", "AFRIKAANS FAL", "ENGLISH HL", "ISIZULU HL", "ISIZULU FAL", "SESOTHO HL", "SESOTHO FAL", "MATHEMATICAL LITERACY", "MATHEMATICS", "AP MATHEMATICS", "AP ENGLISH", "LIFE ORIENTATION", "DESIGN", "DRAMATIC ARTS", "MUSIC", "VISUAL ARTS", "ACCOUNTING", "FRENCH SAL", "INFORMATION TECHNOLOGY", "LIFE SCIENCES", "PHYSICAL SCIENCES", "GEOGRAPHY", "HISTORY" }));
        cmbSubject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbSubjectActionPerformed(evt);
            }
        });

        cmbYearOfStudy.setFont(new java.awt.Font("Skia", 1, 14)); // NOI18N
        cmbYearOfStudy.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        cmbYearOfStudy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbYearOfStudyActionPerformed(evt);
            }
        });

        lblSelectMarksToView.setFont(new java.awt.Font("Skia", 1, 14)); // NOI18N
        lblSelectMarksToView.setText("<html><center>Select the marks you <br>want to view<center>");

        lblSubject.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        lblSubject.setText("Subject:");

        lblYear.setFont(new java.awt.Font("Skia", 2, 15)); // NOI18N
        lblYear.setText("Year:");

        pnlChart.setBackground(new java.awt.Color(247, 235, 248));
        pnlChart.setMaximumSize(new java.awt.Dimension(500, 500));
        pnlChart.setSize(new java.awt.Dimension(500, 500));
        pnlChart.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                pnlChartMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout pnlChartLayout = new javax.swing.GroupLayout(pnlChart);
        pnlChart.setLayout(pnlChartLayout);
        pnlChartLayout.setHorizontalGroup(
            pnlChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 761, Short.MAX_VALUE)
        );
        pnlChartLayout.setVerticalGroup(
            pnlChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 596, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cmbSubject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbYearOfStudy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblSubject)
                            .addComponent(lblYear)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(44, 44, 44)
                        .addComponent(lblSelectMarksToView, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnlChart, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(41, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(83, 83, 83)
                        .addComponent(lblSelectMarksToView, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(43, 43, 43)
                        .addComponent(lblSubject)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbSubject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(lblYear)
                        .addGap(3, 3, 3)
                        .addComponent(cmbYearOfStudy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(14, 14, 14)
                        .addComponent(pnlChart, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(74, Short.MAX_VALUE))
        );

        mnuMarkOptions.setText("Options");
        mnuMarkOptions.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        mnuH.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_H, java.awt.event.InputEvent.SHIFT_MASK));
        mnuH.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuH.setText("Help");
        mnuH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuHActionPerformed(evt);
            }
        });
        mnuMarkOptions.add(mnuH);

        mnuAC.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.SHIFT_MASK));
        mnuAC.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuAC.setText("Academic Criteria");
        mnuAC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuACActionPerformed(evt);
            }
        });
        mnuMarkOptions.add(mnuAC);

        mnuMain.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_M, java.awt.event.InputEvent.SHIFT_MASK));
        mnuMain.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuMain.setText("Main Menu");
        mnuMain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuMainActionPerformed(evt);
            }
        });
        mnuMarkOptions.add(mnuMain);

        mnuLogOff.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.SHIFT_MASK));
        mnuLogOff.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuLogOff.setText("Log Off");
        mnuLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuLogOffActionPerformed(evt);
            }
        });
        mnuMarkOptions.add(mnuLogOff);

        jMenuBar3.add(mnuMarkOptions);

        dlgDisplayMarks.setJMenuBar(jMenuBar3);

        javax.swing.GroupLayout dlgDisplayMarksLayout = new javax.swing.GroupLayout(dlgDisplayMarks.getContentPane());
        dlgDisplayMarks.getContentPane().setLayout(dlgDisplayMarksLayout);
        dlgDisplayMarksLayout.setHorizontalGroup(
            dlgDisplayMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgDisplayMarksLayout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        dlgDisplayMarksLayout.setVerticalGroup(
            dlgDisplayMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgDisplayMarksLayout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        dlgMiniDisplayColours.setBackground(new java.awt.Color(255, 255, 255));

        jPanel3.setBackground(new java.awt.Color(247, 235, 248));

        lblMiniDisplayColoursHeading.setFont(new java.awt.Font("Skia", 3, 18)); // NOI18N
        lblMiniDisplayColoursHeading.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMiniDisplayColoursHeading.setText("Colours for grade");

        lblMidColours.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblMidColours.setText("<html><leading>Mid Year Colours:<leading>");

        lblMidAvg.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblMidAvg.setText("<html><leading>Mid Year Average:<leading>\n");

        btnDisplayColoursSummary.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnDisplayColoursSummary.setText("<html><center>See Complete <br> Colours Summary<center>");
        btnDisplayColoursSummary.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDisplayColoursSummaryActionPerformed(evt);
            }
        });

        lblEndAvg.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblEndAvg.setText("<html><leading>November Average:<leading>");

        lblFinalAvg.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblFinalAvg.setText("<html><leading>Final Year Average:<leading>");

        lblColoursValue.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblColoursValue.setText("jLabel1");

        lblMidAvgMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblMidAvgMark.setText("jLabel1");

        lblEndAvgMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblEndAvgMark.setText("jLabel1");

        lblFinalAvgMark.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblFinalAvgMark.setText("jLabel1");

        btnCancel.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        lblFinalYearColours.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblFinalYearColours.setText("End of Year Colours:");

        lblFinalColoursValue.setFont(new java.awt.Font("Skia", 2, 16)); // NOI18N
        lblFinalColoursValue.setText("jLabel7");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(17, 17, 17)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(60, 60, 60)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblMidAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblEndAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblFinalAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblMidColours, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblFinalYearColours))
                        .addGap(63, 63, 63)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(lblFinalColoursValue, javax.swing.GroupLayout.DEFAULT_SIZE, 59, Short.MAX_VALUE)
                            .addComponent(lblMidAvgMark, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(lblEndAvgMark, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(lblFinalAvgMark, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(lblColoursValue, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(btnDisplayColoursSummary, javax.swing.GroupLayout.PREFERRED_SIZE, 171, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 84, Short.MAX_VALUE)
                        .addComponent(btnCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 104, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(55, 55, 55))))
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(125, 125, 125)
                .addComponent(lblMiniDisplayColoursHeading, javax.swing.GroupLayout.PREFERRED_SIZE, 172, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(19, 19, 19)
                .addComponent(lblMiniDisplayColoursHeading)
                .addGap(37, 37, 37)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblMidAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblMidAvgMark))
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblEndAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblEndAvgMark))
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblFinalAvg, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblFinalAvgMark))
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblColoursValue)
                    .addComponent(lblMidColours, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblFinalColoursValue)
                    .addComponent(lblFinalYearColours))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(btnDisplayColoursSummary)
                    .addComponent(btnCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(64, 64, 64))
        );

        javax.swing.GroupLayout dlgMiniDisplayColoursLayout = new javax.swing.GroupLayout(dlgMiniDisplayColours.getContentPane());
        dlgMiniDisplayColours.getContentPane().setLayout(dlgMiniDisplayColoursLayout);
        dlgMiniDisplayColoursLayout.setHorizontalGroup(
            dlgMiniDisplayColoursLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        dlgMiniDisplayColoursLayout.setVerticalGroup(
            dlgMiniDisplayColoursLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        dlgDisplayColours.setBackground(new java.awt.Color(247, 235, 248));

        jPanel4.setBackground(new java.awt.Color(247, 235, 248));
        jPanel4.setLayout(null);

        jLabel2.setFont(new java.awt.Font("Skia", 1, 32)); // NOI18N
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("LV");
        jPanel4.add(jLabel2);
        jLabel2.setBounds(40, 160, 160, 80);

        jLabel1.setFont(new java.awt.Font("Skia", 1, 32)); // NOI18N
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("MV");
        jPanel4.add(jLabel1);
        jLabel1.setBounds(40, 250, 160, 90);

        jLabel3.setFont(new java.awt.Font("Skia", 1, 32)); // NOI18N
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("UV");
        jPanel4.add(jLabel3);
        jLabel3.setBounds(40, 340, 160, 90);

        jLabel4.setFont(new java.awt.Font("Skia", 1, 32)); // NOI18N
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("AM");
        jPanel4.add(jLabel4);
        jLabel4.setBounds(40, 430, 170, 90);

        jLabel5.setFont(new java.awt.Font("Skia", 1, 32)); // NOI18N
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel5.setText("Matric");
        jPanel4.add(jLabel5);
        jLabel5.setBounds(40, 530, 160, 90);

        lblMidAvgHeader.setFont(new java.awt.Font("Skia", 1, 20)); // NOI18N
        lblMidAvgHeader.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgHeader.setText("<html><center>Mid Year <br>Average<center>");
        jPanel4.add(lblMidAvgHeader);
        lblMidAvgHeader.setBounds(210, 62, 150, 90);

        lblMidAvgAwardHeader.setFont(new java.awt.Font("Skia", 1, 20)); // NOI18N
        lblMidAvgAwardHeader.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgAwardHeader.setText("<html><center>Mid Year <br>Award<center>");
        jPanel4.add(lblMidAvgAwardHeader);
        lblMidAvgAwardHeader.setBounds(370, 60, 140, 90);

        lblEndAvgHeader.setFont(new java.awt.Font("Skia", 1, 20)); // NOI18N
        lblEndAvgHeader.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgHeader.setText("<html><center>End of Year<br>Average<center>");
        jPanel4.add(lblEndAvgHeader);
        lblEndAvgHeader.setBounds(520, 60, 150, 90);

        lblEndAwardHeader.setFont(new java.awt.Font("Skia", 1, 20)); // NOI18N
        lblEndAwardHeader.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardHeader.setText("<html><center>End of Year <br>Award<center>");
        jPanel4.add(lblEndAwardHeader);
        lblEndAwardHeader.setBounds(680, 60, 150, 90);

        lblSubjectMarksView.setFont(new java.awt.Font("Skia", 1, 20)); // NOI18N
        lblSubjectMarksView.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblSubjectMarksView.setText("<html><center> View Subject Marks<center>");
        jPanel4.add(lblSubjectMarksView);
        lblSubjectMarksView.setBounds(840, 60, 140, 90);

        lblMidAvgLV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblMidAvgLV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgLV.setText("jLabel11");
        lblMidAvgLV.setToolTipText("");
        lblMidAvgLV.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        jPanel4.add(lblMidAvgLV);
        lblMidAvgLV.setBounds(210, 160, 150, 90);

        lblMidAwardLV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblMidAwardLV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAwardLV.setText("jLabel12");
        jPanel4.add(lblMidAwardLV);
        lblMidAwardLV.setBounds(373, 156, 140, 90);

        lblEndAvgLV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblEndAvgLV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgLV.setText("jLabel13");
        jPanel4.add(lblEndAvgLV);
        lblEndAvgLV.setBounds(523, 156, 150, 80);

        lblEndAwardLV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblEndAwardLV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardLV.setText("jLabel14");
        jPanel4.add(lblEndAwardLV);
        lblEndAwardLV.setBounds(683, 156, 150, 90);

        lblMidAvgMV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblMidAvgMV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgMV.setText("jLabel15");
        jPanel4.add(lblMidAvgMV);
        lblMidAvgMV.setBounds(210, 250, 160, 90);

        lblMidAwardMV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblMidAwardMV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAwardMV.setText("jLabel16");
        jPanel4.add(lblMidAwardMV);
        lblMidAwardMV.setBounds(370, 250, 160, 90);

        lblEndAvgMV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblEndAvgMV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgMV.setText("jLabel17");
        jPanel4.add(lblEndAvgMV);
        lblEndAvgMV.setBounds(523, 246, 150, 90);

        lblEndAwardMV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblEndAwardMV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardMV.setText("jLabel18");
        jPanel4.add(lblEndAwardMV);
        lblEndAwardMV.setBounds(680, 250, 150, 90);

        lblMidAvgUV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblMidAvgUV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgUV.setText("jLabel19");
        jPanel4.add(lblMidAvgUV);
        lblMidAvgUV.setBounds(203, 346, 160, 80);

        lblMidAwardUV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblMidAwardUV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAwardUV.setText("jLabel20");
        jPanel4.add(lblMidAwardUV);
        lblMidAwardUV.setBounds(363, 346, 150, 80);

        lblEndAvgUV.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblEndAvgUV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgUV.setText("jLabel21");
        jPanel4.add(lblEndAvgUV);
        lblEndAvgUV.setBounds(523, 346, 150, 80);

        lblEndAwardUV.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblEndAwardUV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardUV.setText("jLabel22");
        jPanel4.add(lblEndAwardUV);
        lblEndAwardUV.setBounds(680, 340, 150, 90);

        lblEndAwardAM.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblEndAwardAM.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardAM.setText("jLabel24");
        jPanel4.add(lblEndAwardAM);
        lblEndAwardAM.setBounds(680, 440, 150, 80);

        lblEndAvgAM.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblEndAvgAM.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgAM.setText("jLabel25");
        jPanel4.add(lblEndAvgAM);
        lblEndAvgAM.setBounds(523, 436, 150, 90);

        lblMidAwardAM.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblMidAwardAM.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAwardAM.setText("jLabel26");
        jPanel4.add(lblMidAwardAM);
        lblMidAwardAM.setBounds(363, 436, 150, 90);

        lblMidAvgAM.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblMidAvgAM.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgAM.setText("jLabel27");
        jPanel4.add(lblMidAvgAM);
        lblMidAvgAM.setBounds(213, 436, 150, 90);

        lblMidAvgMatric.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblMidAvgMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAvgMatric.setText("jLabel28");
        jPanel4.add(lblMidAvgMatric);
        lblMidAvgMatric.setBounds(213, 526, 150, 90);

        lblMidAwardMatric.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblMidAwardMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMidAwardMatric.setText("jLabel29");
        jPanel4.add(lblMidAwardMatric);
        lblMidAwardMatric.setBounds(363, 526, 150, 90);

        lblEndAvgMatric.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblEndAvgMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAvgMatric.setText("jLabel30");
        jPanel4.add(lblEndAvgMatric);
        lblEndAvgMatric.setBounds(523, 526, 150, 90);

        lblEndAwardMatric.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblEndAwardMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEndAwardMatric.setText("jLabel31");
        jPanel4.add(lblEndAwardMatric);
        lblEndAwardMatric.setBounds(680, 530, 150, 90);

        lblDisplayColoursHeading.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblDisplayColoursHeading.setText("Academic Awards Summary");
        jPanel4.add(lblDisplayColoursHeading);
        lblDisplayColoursHeading.setBounds(330, 10, 440, 30);

        btnViewMarksLV.setFont(new java.awt.Font("Skia", 2, 13)); // NOI18N
        btnViewMarksLV.setText("View LV Marks");
        btnViewMarksLV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewMarksLVActionPerformed(evt);
            }
        });
        jPanel4.add(btnViewMarksLV);
        btnViewMarksLV.setBounds(850, 170, 120, 60);

        btnViewMarksMV.setFont(new java.awt.Font("Skia", 2, 13)); // NOI18N
        btnViewMarksMV.setText("View MV Marks");
        btnViewMarksMV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewMarksMVActionPerformed(evt);
            }
        });
        jPanel4.add(btnViewMarksMV);
        btnViewMarksMV.setBounds(850, 270, 120, 60);

        btnViewMarksUV.setFont(new java.awt.Font("Skia", 2, 13)); // NOI18N
        btnViewMarksUV.setText("View UV Marks");
        btnViewMarksUV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewMarksUVActionPerformed(evt);
            }
        });
        jPanel4.add(btnViewMarksUV);
        btnViewMarksUV.setBounds(850, 350, 120, 60);

        btnViewMarksAM.setFont(new java.awt.Font("Skia", 2, 13)); // NOI18N
        btnViewMarksAM.setText("View AM Marks");
        btnViewMarksAM.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewMarksAMActionPerformed(evt);
            }
        });
        jPanel4.add(btnViewMarksAM);
        btnViewMarksAM.setBounds(850, 450, 120, 60);

        btnViewMarksMatric.setFont(new java.awt.Font("Skia", 2, 13)); // NOI18N
        btnViewMarksMatric.setText("<html><center>View Matric<br>Marks<center>\n");
        btnViewMarksMatric.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewMarksMatricActionPerformed(evt);
            }
        });
        jPanel4.add(btnViewMarksMatric);
        btnViewMarksMatric.setBounds(850, 540, 120, 60);

        lblTable.setFont(new java.awt.Font("Skia", 0, 18)); // NOI18N
        lblTable.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Data/tblScreenshot.png"))); // NOI18N
        lblTable.setSize(new java.awt.Dimension(950, 560));
        jPanel4.add(lblTable);
        lblTable.setBounds(40, 60, 950, 560);

        mnuOptions.setText("Options");
        mnuOptions.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        mnuSummaryHelp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_H, java.awt.event.InputEvent.SHIFT_MASK));
        mnuSummaryHelp.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuSummaryHelp.setText("Help");
        mnuSummaryHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuSummaryHelpActionPerformed(evt);
            }
        });
        mnuOptions.add(mnuSummaryHelp);

        mnuSummaryLogOff.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.SHIFT_MASK));
        mnuSummaryLogOff.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuSummaryLogOff.setText("Log Off");
        mnuSummaryLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuSummaryLogOffActionPerformed(evt);
            }
        });
        mnuOptions.add(mnuSummaryLogOff);

        mnuSummaryAwards.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.SHIFT_MASK));
        mnuSummaryAwards.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuSummaryAwards.setText("Academic Colours Criteria");
        mnuSummaryAwards.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuSummaryAwardsActionPerformed(evt);
            }
        });
        mnuOptions.add(mnuSummaryAwards);

        mnuMainMenu.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_M, java.awt.event.InputEvent.SHIFT_MASK));
        mnuMainMenu.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuMainMenu.setText("Main Menu");
        mnuMainMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuMainMenuActionPerformed(evt);
            }
        });
        mnuOptions.add(mnuMainMenu);

        jMenuBar2.add(mnuOptions);

        dlgDisplayColours.setJMenuBar(jMenuBar2);

        javax.swing.GroupLayout dlgDisplayColoursLayout = new javax.swing.GroupLayout(dlgDisplayColours.getContentPane());
        dlgDisplayColours.getContentPane().setLayout(dlgDisplayColoursLayout);
        dlgDisplayColoursLayout.setHorizontalGroup(
            dlgDisplayColoursLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, 1063, Short.MAX_VALUE)
        );
        dlgDisplayColoursLayout.setVerticalGroup(
            dlgDisplayColoursLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, 659, Short.MAX_VALUE)
        );

        jPanel6.setBackground(new java.awt.Color(247, 235, 248));

        lblHelpHeader.setFont(new java.awt.Font("Skia", 1, 18)); // NOI18N
        lblHelpHeader.setText("Need Help?");

        lblP1.setFont(new java.awt.Font("Skia", 1, 16)); // NOI18N
        lblP1.setText("<html>General<html>");

        lblP3.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP3.setText("<html>To view the marks of a particular grade, select the \"View grade Marks\" button in the row of the grade marks you want to view <html>");

        lblP4.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP4.setText("<html>To view the Academic Colours Criteria, select \"options\" and then \"Academic Colours Criteria\", or press shift A<html>");

        lblP5.setFont(new java.awt.Font("Skia", 1, 16)); // NOI18N
        lblP5.setText("<html>Academic Colours Tab<html>");

        lblP7.setBackground(new java.awt.Color(247, 235, 248));
        lblP7.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP7.setText("<html>To view your marks for a particular year, select the Marks tab and then select the respective year. Once in the marks dialog, you can select which marks to view by grade and/or subject by selecting the subject or grade using the drop box<html>");

        lblP10.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP10.setText("<html>To log off, select \"options\" and then \"Log off\", or press shift L<html>");

        lblP6.setFont(new java.awt.Font("Skia", 1, 16)); // NOI18N
        lblP6.setText("<html>Marks Tab<html>");

        lblP8.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP8.setText("<html>To view your academic colours progress for a particular year, select the Academic Colours Progress tab and then select the respective year.<html>");

        lblP9.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        lblP9.setText("<html>After selecting the grade and opening the marks and colours summary dialog, select the \"See full Colours Summary\" button to see your full colours and marks summary<html>");

        btnClose.setFont(new java.awt.Font("Skia", 0, 14)); // NOI18N
        btnClose.setText("Close");
        btnClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCloseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addGap(140, 140, 140)
                        .addComponent(lblHelpHeader))
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblP6, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP1, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP4, javax.swing.GroupLayout.PREFERRED_SIZE, 333, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP10, javax.swing.GroupLayout.PREFERRED_SIZE, 312, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP7, javax.swing.GroupLayout.PREFERRED_SIZE, 360, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP5, javax.swing.GroupLayout.PREFERRED_SIZE, 176, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP8, javax.swing.GroupLayout.PREFERRED_SIZE, 354, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP9, javax.swing.GroupLayout.PREFERRED_SIZE, 354, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblP3, javax.swing.GroupLayout.PREFERRED_SIZE, 354, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(22, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(btnClose, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(43, 43, 43))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblHelpHeader)
                .addGap(17, 17, 17)
                .addComponent(lblP1, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP4, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(31, 31, 31)
                .addComponent(lblP6, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP7, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(lblP5, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblP8, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblP9, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(lblP3, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnClose, javax.swing.GroupLayout.DEFAULT_SIZE, 44, Short.MAX_VALUE)
                .addGap(21, 21, 21))
        );

        javax.swing.GroupLayout dlgHelpLayout = new javax.swing.GroupLayout(dlgHelp.getContentPane());
        dlgHelp.getContentPane().setLayout(dlgHelpLayout);
        dlgHelpLayout.setHorizontalGroup(
            dlgHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        dlgHelpLayout.setVerticalGroup(
            dlgHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        jPanel5.setBackground(new java.awt.Color(247, 235, 248));

        lblLogOffHeader.setFont(new java.awt.Font("Skia", 1, 18)); // NOI18N
        lblLogOffHeader.setText("<html><center>Are you sure you want to<br>log off?<center>");

        btnLogOff.setFont(new java.awt.Font("Skia", 2, 18)); // NOI18N
        btnLogOff.setText("Log Off");
        btnLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLogOffActionPerformed(evt);
            }
        });

        btnCancelLogOff.setFont(new java.awt.Font("Skia", 2, 18)); // NOI18N
        btnCancelLogOff.setText("Cancel");
        btnCancelLogOff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelLogOffActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                .addGap(26, 26, 26)
                .addComponent(btnLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 113, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE)
                .addComponent(btnCancelLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(41, 41, 41))
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGap(54, 54, 54)
                .addComponent(lblLogOffHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGap(41, 41, 41)
                .addComponent(lblLogOffHeader, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(43, 43, 43)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCancelLogOff, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(39, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout dlgConfirmLogOffLayout = new javax.swing.GroupLayout(dlgConfirmLogOff.getContentPane());
        dlgConfirmLogOff.getContentPane().setLayout(dlgConfirmLogOffLayout);
        dlgConfirmLogOffLayout.setHorizontalGroup(
            dlgConfirmLogOffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dlgConfirmLogOffLayout.createSequentialGroup()
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        dlgConfirmLogOffLayout.setVerticalGroup(
            dlgConfirmLogOffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jMenuItem2.setText("jMenuItem2");

        jButton1.setText("jButton1");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBackground(new java.awt.Color(255, 255, 255));

        pnlMainPanel.setBackground(new java.awt.Color(255, 255, 255));

        jTabbedPane2.setBackground(new java.awt.Color(247, 235, 248));
        jTabbedPane2.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N

        pnlMarks.setBackground(new java.awt.Color(255, 255, 255));

        jPanel2.setBackground(new java.awt.Color(255, 255, 255));
        jPanel2.setLayout(null);

        lblMatric.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMatric.setText("Matric");
        lblMatric.setMaximumSize(new java.awt.Dimension(60, 30));
        lblMatric.setPreferredSize(new java.awt.Dimension(60, 18));
        lblMatric.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblMatricMouseClicked(evt);
            }
        });
        jPanel2.add(lblMatric);
        lblMatric.setBounds(150, 30, 170, 110);

        lblAnteMatric.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblAnteMatric.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblAnteMatric.setText("<html><center>Ante<br>Matric<center>");
        lblAnteMatric.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblAnteMatricMouseClicked(evt);
            }
        });
        jPanel2.add(lblAnteMatric);
        lblAnteMatric.setBounds(240, 180, 170, 110);

        lblUV.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblUV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblUV.setText("UV");
        lblUV.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblUVMouseClicked(evt);
            }
        });
        jPanel2.add(lblUV);
        lblUV.setBounds(150, 330, 170, 110);

        lblMV.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblMV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMV.setText("MV");
        lblMV.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblMVMouseClicked(evt);
            }
        });
        jPanel2.add(lblMV);
        lblMV.setBounds(240, 470, 170, 120);

        lblLV.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblLV.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblLV.setText("LV");
        lblLV.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblLVMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                lblLVMouseEntered(evt);
            }
        });
        jPanel2.add(lblLV);
        lblLV.setBounds(150, 620, 170, 110);

        lblMarks.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblMarks.setText("<html><center>Marks<center>");
        jPanel2.add(lblMarks);
        lblMarks.setBounds(520, 20, 110, 60);

        lblMarksLadder.setBackground(new java.awt.Color(255, 255, 255));
        lblMarksLadder.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Data/Grade Mark Ladder.png"))); // NOI18N
        lblMarksLadder.setMaximumSize(new java.awt.Dimension(43, 77));
        lblMarksLadder.setMinimumSize(new java.awt.Dimension(43, 77));
        lblMarksLadder.setOpaque(true);
        lblMarksLadder.setPreferredSize(new java.awt.Dimension(43, 77));
        jPanel2.add(lblMarksLadder);
        lblMarksLadder.setBounds(50, 0, 466, 780);

        javax.swing.GroupLayout pnlMarksLayout = new javax.swing.GroupLayout(pnlMarks);
        pnlMarks.setLayout(pnlMarksLayout);
        pnlMarksLayout.setHorizontalGroup(
            pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, 665, Short.MAX_VALUE)
        );
        pnlMarksLayout.setVerticalGroup(
            pnlMarksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMarksLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 779, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane2.addTab("Marks", pnlMarks);

        pnlColoursProgress.setBackground(new java.awt.Color(255, 255, 255));
        pnlColoursProgress.setLayout(null);

        lblAcademicColoursProgress.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblAcademicColoursProgress.setText("<html><center>Academic Colours<br>Progress<center>");
        pnlColoursProgress.add(lblAcademicColoursProgress);
        lblAcademicColoursProgress.setBounds(410, 10, 260, 150);

        lblMatric2.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblMatric2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMatric2.setText("<html><center>Matric<center>");
        lblMatric2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblMatric2MouseClicked(evt);
            }
        });
        pnlColoursProgress.add(lblMatric2);
        lblMatric2.setBounds(160, 40, 150, 100);

        lblAnteMatric2.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblAnteMatric2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblAnteMatric2.setText("<html><center>Ante<br>Matric<center>");
        lblAnteMatric2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblAnteMatric2MouseClicked(evt);
            }
        });
        pnlColoursProgress.add(lblAnteMatric2);
        lblAnteMatric2.setBounds(240, 180, 170, 110);

        lblUV2.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblUV2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblUV2.setText("<html><center>UV<center>");
        lblUV2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblUV2MouseClicked(evt);
            }
        });
        pnlColoursProgress.add(lblUV2);
        lblUV2.setBounds(150, 330, 170, 110);

        lblMV2.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblMV2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblMV2.setText("<html><center>MV<center>");
        lblMV2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblMV2MouseClicked(evt);
            }
        });
        pnlColoursProgress.add(lblMV2);
        lblMV2.setBounds(240, 480, 170, 110);

        lblLV2.setFont(new java.awt.Font("Skia", 1, 30)); // NOI18N
        lblLV2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblLV2.setText("<html><center>LV<center>");
        lblLV2.setToolTipText("");
        lblLV2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblLV2MouseClicked(evt);
            }
        });
        pnlColoursProgress.add(lblLV2);
        lblLV2.setBounds(150, 630, 170, 110);

        lblMarksLadder2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Data/Grade Mark Ladder.png"))); // NOI18N
        lblMarksLadder2.setText("jLabel1");
        lblMarksLadder2.setToolTipText("");
        pnlColoursProgress.add(lblMarksLadder2);
        lblMarksLadder2.setBounds(50, 0, 430, 790);

        jTabbedPane2.addTab("Academic Colours Progress", pnlColoursProgress);

        javax.swing.GroupLayout pnlMainPanelLayout = new javax.swing.GroupLayout(pnlMainPanel);
        pnlMainPanel.setLayout(pnlMainPanelLayout);
        pnlMainPanelLayout.setHorizontalGroup(
            pnlMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 686, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pnlMainPanelLayout.setVerticalGroup(
            pnlMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMainPanelLayout.createSequentialGroup()
                .addComponent(jTabbedPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 998, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        menuOptions.setText("Options");
        menuOptions.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        menuOptions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuOptionsActionPerformed(evt);
            }
        });

        menuItemLogoff.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.SHIFT_MASK));
        menuItemLogoff.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        menuItemLogoff.setText("Log Off");
        menuItemLogoff.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuItemLogoffActionPerformed(evt);
            }
        });
        menuOptions.add(menuItemLogoff);

        mnuHelp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_H, java.awt.event.InputEvent.SHIFT_MASK));
        mnuHelp.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        mnuHelp.setText("Help");
        mnuHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuHelpActionPerformed(evt);
            }
        });
        menuOptions.add(mnuHelp);

        menuItemCriteria.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.SHIFT_MASK));
        menuItemCriteria.setFont(new java.awt.Font("Skia", 2, 14)); // NOI18N
        menuItemCriteria.setText("Academic Colours Criteria");
        menuItemCriteria.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuItemCriteriaActionPerformed(evt);
            }
        });
        menuOptions.add(menuItemCriteria);

        jMenuBar1.add(menuOptions);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(pnlMainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(pnlMainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 844, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void lblLVMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblLVMouseClicked
       openDialog(dlgDisplayMarks,1020, 684);
       createDefaultBarChart(8);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      

      
    }//GEN-LAST:event_lblLVMouseClicked

    private void lblMVMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblMVMouseClicked
       openDialog(dlgDisplayMarks,1020,684);
       createDefaultBarChart(9);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      

        
    }//GEN-LAST:event_lblMVMouseClicked

    private void lblUVMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblUVMouseClicked
       openDialog(dlgDisplayMarks,1020,684);
       createDefaultBarChart(10);
      
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      
    
    }//GEN-LAST:event_lblUVMouseClicked

    private void lblAnteMatricMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblAnteMatricMouseClicked
      
       openDialog(dlgDisplayMarks,1020,684);
       createDefaultBarChart(11);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      
    }//GEN-LAST:event_lblAnteMatricMouseClicked

    private void lblMatricMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblMatricMouseClicked
       openDialog(dlgDisplayMarks,1020,684);
       createDefaultBarChart(12);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement("ALL");
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      
      
       

    }//GEN-LAST:event_lblMatricMouseClicked

    private void menuOptionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuOptionsActionPerformed

    }//GEN-LAST:event_menuOptionsActionPerformed

    private void menuItemLogoffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuItemLogoffActionPerformed
   
      //this code logs the user off and returns to the LoginGUI
     openDialog(dlgConfirmLogOff,338,207);
        
    }//GEN-LAST:event_menuItemLogoffActionPerformed

    private void menuItemCriteriaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuItemCriteriaActionPerformed
        
        String fn = "AwardsCriteria";
        openPDF(fn);

       
    }//GEN-LAST:event_menuItemCriteriaActionPerformed

    //method to open and display PDF file
    private void openPDF(String fileName)
    {
        String filePath = "/Users/bee.ntsimane/OneDrive - Roedean School/Matric 2021/IT/Prac/Java/2021 PAT/" + fileName +".pdf";
        
        //build a controller
        SwingController controller = new SwingController();
        
        //build a SwingViewerFactory configured with controller
        SwingViewBuilder factory = new SwingViewBuilder(controller);
        
        //Use the factory to build a JPanel that is preconfigured
        //with a complete active viewer UI
        JPanel viewerComponentPanel = factory.buildViewerPanel();
        
        //add copy keyboard command
        ComponentKeyBinding.install(controller,viewerComponentPanel);
        
        
        //add interactive move link annotation support via callback
        controller.getDocumentViewController().setAnnotationCallback(
        new org.icepdf.ri.common.MyAnnotationCallback(
        controller.getDocumentViewController()));
        
        //Create a JFrame to display the panel on
        JFrame window = new JFrame("Using the viewer comp");
       
        window.getContentPane().add(viewerComponentPanel);
        window.pack();
        window.setVisible(true);
        
        //open a pdf document to view
        controller.openDocument(filePath);
    }
    
    private CategoryDataset createDefaultBarDataSet(int grade)
    {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        recordID = student.getUserID();
        System.out.println( recordID);
        
        ResultSet rs = mSQL.getStudentMarks(recordID);
        
        try {
           
            
            while(rs.next())
            {

           //   System.out.println("all good here too!");
                String uname = rs.getString("USERNAME");
                String subj = rs.getString("SUBJECT");
                String toy = rs.getString("TIMEOFYEAR");
                String yos = rs.getString("YEAROFSTUDY");
                int mark = rs.getInt("MARK");
                String matric =rs.getString("MATRICYEAR");
               
                //obtain grade marks for selected grade
                int intYos = Integer.parseInt(yos);
                int intMatric = Integer.parseInt(matric);
                int selectedGrade = (intYos + 12) - intMatric;
               

                
                
                //check if grade of data value equals grade selected by user
               if(selectedGrade == grade)
                {
                    dataset.addValue(mark, subj , toy + " " + yos);
                }   

            }
        } catch (SQLException ex) {
            System.out.println("Error parsing rs: " + ex);
        }
        return dataset;
        
    }
    //create the default bar chart that displays when the grade is selected 
    private void createDefaultBarChart(int grade)
    {
             CategoryDataset dataset = createDefaultBarDataSet(grade);
       
       //prepare chart
       JFreeChart barChart = ChartFactory.createBarChart("Student Marks", "Subjects", "Marks", dataset, PlotOrientation.VERTICAL, rootPaneCheckingEnabled, rootPaneCheckingEnabled, rootPaneCheckingEnabled);
       
       //display chart in the panel
       ChartPanel chartPanel = new ChartPanel(barChart,false);
       chartPanel.setChart(barChart);
       chartPanel.setSize(761,596);
       
       //add to panel in GUI
       pnlChart.removeAll();
       pnlChart.add(chartPanel);
       pnlChart.setSize(761,596);
       pnlChart.setVisible(true);
  
    }
    

    private CategoryDataset createSelectedBarDataSet(String subject,String year)
    {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        recordID = student.getUserID();
        System.out.println(recordID);
        
        ResultSet rs = mSQL.getStudentMarks(recordID);
        
        try {
           // System.out.println("working!");
            
            while(rs.next())
            {

              //  System.out.println("all good here too!");
                String uname = rs.getString("USERNAME");
                String subj = rs.getString("SUBJECT");
                String toy = rs.getString("TIMEOFYEAR");
                String yos = rs.getString("YEAROFSTUDY");
                int mark = rs.getInt("MARK");
                String matric =rs.getString("MATRICYEAR");

                
                //check if subject in data value matches selected value from combobox
                if(subject.equalsIgnoreCase("ALL"))
                { 


                   //check if yearOfStudy in data value matches selected value from combobox
                    if(year.equalsIgnoreCase(yos))
                    {
                         dataset.addValue(mark, subj , toy + " " + yos);
                         System.out.println("dataset created!");
                    }
                }
                else
                {
                    if(subj.equalsIgnoreCase(subject))
                    {
                        if(year.equalsIgnoreCase("ALL"))
                        {
                         dataset.addValue(mark, subj , toy + " " + yos);
                         System.out.println("dataset created!");                       
                        }  
                        
                        //check if yearOfStudy in data value matches selected value from combobox
                        if(year.equalsIgnoreCase(yos))
                            {
                             dataset.addValue(mark, subj , toy + " " + yos);
                             System.out.println("dataset created!");
                            }                        
                    }
                }
                
                

            }
        } catch (SQLException ex) {
            System.out.println("Error parsing rs: " + ex);
        }
        return dataset;
        
    }
    //create the default bar chart that displays when the grade is selected 
    private void createSelectedBarChart(String subject, String year)
    {
        //pnlChart.removeAll();
        CategoryDataset dataset = createSelectedBarDataSet(subject,year);
        System.out.println("dataset used in bar chart!");
       //prepare chart
       JFreeChart barChart = ChartFactory.createBarChart("Student Marks", "Subjects", "Marks", dataset, PlotOrientation.VERTICAL, rootPaneCheckingEnabled, rootPaneCheckingEnabled, rootPaneCheckingEnabled);
       
       //display chart in the panel
       ChartPanel chartPanel = new ChartPanel(barChart,false);
       chartPanel.setChart(barChart);
       chartPanel.setSize(761,596);
       
       //add to panel in GUI
       pnlChart.removeAll();
       pnlChart.add(chartPanel);
       pnlChart.setSize(761,596);
       pnlChart.setVisible(true);
       
       
       
  
    }
    
    
    
    private void lblMatric2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblMatric2MouseClicked
        
       
        openDialog(dlgMiniDisplayColours,431,404);
        recordID = student.getUserID();
       
        //specifying to extract marks from this particular grade
        int numMatricYear = Integer.parseInt(student.getMatricYear());
        
        int numSelectedYear8 = numMatricYear - 4;
        int numSelectedYear9 = numMatricYear - 3;
        int numSelectedYear10 = numMatricYear - 2;
        int numSelectedYear11 = numMatricYear - 1;
        int numSelectedYear12 = numMatricYear;
        
        String year8 = String.valueOf(numSelectedYear8);
        String year9 = String.valueOf(numSelectedYear9);
        String year10 = String.valueOf(numSelectedYear10);
        String year11 = String.valueOf(numSelectedYear11);
        String year12 = String.valueOf(numSelectedYear12);
        
        
        
        int midAvg8 = mSQL.getMidAverage(recordID,year8);
        int endAvg8 = mSQL.getEndAverage(recordID,year8);

        int midAvg9 = mSQL.getMidAverage(recordID,year9);
        int endAvg9 = mSQL.getEndAverage(recordID,year9); 
        
        int midAvg10 = mSQL.getMidAverage(recordID,year10);
        int endAvg10 = mSQL.getEndAverage(recordID,year10);
        
        int midAvg11 = mSQL.getMidAverage(recordID,year11);
        int endAvg11 = mSQL.getEndAverage(recordID,year11);       

        int midAvg12 = mSQL.getMidAverage(recordID,year12);
        int endAvg12 = mSQL.getEndAverage(recordID,year12);    


        
        
         //obtain final average marks to display on mini dialog, combining both mid and end marks
        String finalAvg = String.valueOf(mSQL.getFinalAverage(recordID,year12));
        lblMiniDisplayColoursHeading.setText("<html><center>Colours for Matric<center>");
        lblFinalAvgMark.setText(finalAvg);

         //obtain mid average marks to display on mini dialog
        String midAvg = String.valueOf(mSQL.getMidAverage(recordID,year12));
        lblMidAvgMark.setText(midAvg); 
        
        //obtain end average marks to display on mini dialog
        String endAvg = String.valueOf(mSQL.getEndAverage(recordID,year12));
        lblEndAvgMark.setText(endAvg);
        
        
        //obtain mid year academic colours value of that year
        lblColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,endAvg10,midAvg11,endAvg11,midAvg12,0));
       
       //obtain end of year academic colours value of that year]
       lblFinalColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,endAvg10,midAvg11,endAvg11,midAvg12,endAvg12)); 
        
       
        

        // TODO add your handling code here:
    }//GEN-LAST:event_lblMatric2MouseClicked

    private void lblAnteMatric2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblAnteMatric2MouseClicked
       openDialog(dlgMiniDisplayColours,431,404);
       
       recordID = student.getUserID();
       
       lblMiniDisplayColoursHeading.setText("<html><center>Colours for Ante Matric<center>");
        
        //specifying to extract marks from this particular grade
        int numMatricYear = Integer.parseInt(student.getMatricYear());
        //subtracting to get to the selected year
        int numSelectedYear8 = numMatricYear - 4;
        int numSelectedYear9 = numMatricYear - 3;
        int numSelectedYear10 = numMatricYear - 2;
        int numSelectedYear11 = numMatricYear - 1;
        
        String year8 = String.valueOf(numSelectedYear8);
        String year9 = String.valueOf(numSelectedYear9);
        String year10 = String.valueOf(numSelectedYear10);
        String year11 = String.valueOf(numSelectedYear11);
        
        
        
        int midAvg8 = mSQL.getMidAverage(recordID,year8);
        int endAvg8 = mSQL.getEndAverage(recordID,year8);

        int midAvg9 = mSQL.getMidAverage(recordID,year9);
        int endAvg9 = mSQL.getEndAverage(recordID,year9); 
        
        int midAvg10 = mSQL.getMidAverage(recordID,year10);
        int endAvg10 = mSQL.getEndAverage(recordID,year10);
        
        int midAvg11 = mSQL.getMidAverage(recordID,year11);
        int endAvg11 = mSQL.getEndAverage(recordID,year11);       



        
        
         //obtain final average marks to display on mini dialog, combining both mid and end marks
        String finalAvg = String.valueOf(mSQL.getFinalAverage(recordID,year11));
      
        lblFinalAvgMark.setText(finalAvg);

         //obtain mid average marks to display on mini dialog
        String midAvg = String.valueOf(mSQL.getMidAverage(recordID,year11));
        lblMidAvgMark.setText(midAvg); 
        
        //obtain end average marks to display on mini dialog
        String endAvg = String.valueOf(mSQL.getEndAverage(recordID,year11));
        lblEndAvgMark.setText(endAvg);   
        
        
        //obtain mid year academic colours value of that year
        lblColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,endAvg10,midAvg11,0,0,0));
       
       //obtain end of year academic colours value of that year]
       lblFinalColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,endAvg10,midAvg11,endAvg11,0,0));        
        
        
       
    }//GEN-LAST:event_lblAnteMatric2MouseClicked

    private void lblUV2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblUV2MouseClicked
       openDialog(dlgMiniDisplayColours,431,404);
       lblMiniDisplayColoursHeading.setText("<html><center>Colours for UV<center>");
      
       recordID = student.getUserID();
        //specifying to extract marks from this particular grade
        int numMatricYear = Integer.parseInt(student.getMatricYear());
        //subtracting to get to the selected year
        
        int numSelectedYear8 = numMatricYear - 4;
        int numSelectedYear9 = numMatricYear - 3;
        int numSelectedYear10 = numMatricYear - 2;
        
        String year8 = String.valueOf(numSelectedYear8);
        String year9 = String.valueOf(numSelectedYear9);
        String year10 = String.valueOf(numSelectedYear10);
        
        
        
        
        int midAvg8 = mSQL.getMidAverage(recordID,year8);
        int endAvg8 = mSQL.getEndAverage(recordID,year8);

        int midAvg9 = mSQL.getMidAverage(recordID,year9);
        int endAvg9 = mSQL.getEndAverage(recordID,year9); 
        
        int midAvg10 = mSQL.getMidAverage(recordID,year10);
        int endAvg10 = mSQL.getEndAverage(recordID,year10);




        
         //obtain final average marks to display on mini dialog, combining both mid and end marks
        String finalAvg = String.valueOf(mSQL.getFinalAverage(recordID,year10));
      
        lblFinalAvgMark.setText(finalAvg);

         //obtain mid average marks to display on mini dialog
        String midAvg = String.valueOf(mSQL.getMidAverage(recordID,year10));
        lblMidAvgMark.setText(midAvg); 
        
        //obtain end average marks to display on mini dialog
        String endAvg = String.valueOf(mSQL.getEndAverage(recordID,year10));
        lblEndAvgMark.setText(endAvg);      
        
        
        //obtain mid year academic colours value of that year
        lblColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,0,0,0,0,0));
       
       //obtain end of year academic colours value of that year]
       lblFinalColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,midAvg10,endAvg10,0,0,0,0));
       
    }//GEN-LAST:event_lblUV2MouseClicked

    private void lblMV2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblMV2MouseClicked
        openDialog(dlgMiniDisplayColours,431,404);
        lblMiniDisplayColoursHeading.setText("<html><center>Colours for MV<center>");
        
        recordID = student.getUserID();
        
        //specifying to extract marks from this particular grade
        int numMatricYear = Integer.parseInt(student.getMatricYear());
        //subtracting to get to the selected year
        int numSelectedYear8 = numMatricYear - 4;
        int numSelectedYear9 = numMatricYear - 3;
        
        String year8 = String.valueOf(numSelectedYear8);
        String year9 = String.valueOf(numSelectedYear9);
        
        
        int midAvg8 = mSQL.getMidAverage(recordID,year8);
        int endAvg8 = mSQL.getEndAverage(recordID,year8);

        int midAvg9 = mSQL.getMidAverage(recordID,year9);
        int endAvg9 = mSQL.getEndAverage(recordID,year9);
        int finalAvg9 = mSQL.getFinalAverage(recordID,year9);
        

        //obtain final average marks to display on mini dialog, combining both mid and end marks
        String finalAvg = String.valueOf(mSQL.getFinalAverage(recordID,year9));
      
        lblFinalAvgMark.setText(finalAvg);

         //obtain mid average marks to display on mini dialog
        String midAvg = String.valueOf(mSQL.getMidAverage(recordID,year9));
        lblMidAvgMark.setText(midAvg); 
        
        //obtain end average marks to display on mini dialog
        String endAvg = String.valueOf(mSQL.getEndAverage(recordID,year9));
        lblEndAvgMark.setText(endAvg);       
 
       
        //obtain mid year academic colours value of that year
        lblColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,0,0,0,0,0,0,0));
       
       //obtain end of year academic colours value of that year]
       lblFinalColoursValue.setText(mSQL.getColours(midAvg8,endAvg8,midAvg9,endAvg9,0,0,0,0,0,0));
    }//GEN-LAST:event_lblMV2MouseClicked

    private void lblLV2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblLV2MouseClicked
       
        openDialog(dlgMiniDisplayColours,431,404);    
        lblMiniDisplayColoursHeading.setText("<html><center>Colours for LV<center>");
       
       recordID = student.getUserID();
        //specifying to extract marks from this particular grade
        int numMatricYear = Integer.parseInt(student.getMatricYear());
       
        //subtracting to get to the selected year
        int numSelectedYear = numMatricYear - 4;
        String year = String.valueOf(numSelectedYear);
        
       
        int midAvg = mSQL.getMidAverage(recordID,year);
        int endAvg = mSQL.getEndAverage(recordID,year);
        int finalAvg = mSQL.getFinalAverage(recordID,year);
        
         //obtain final average marks to display on mini dialog, combining both mid and end marks
        String finalAvgString = String.valueOf(finalAvg);
      
        lblFinalAvgMark.setText(finalAvgString);

         //obtain mid average marks to display on mini dialog
        String midAvgString = String.valueOf(midAvg);
        lblMidAvgMark.setText(midAvgString); 
        
        //obtain end average marks to display on mini dialog
        String endAvgString = String.valueOf(endAvg);
        lblEndAvgMark.setText(endAvgString);    
        
        
        //obtain mid year academic colours value of that year
        lblColoursValue.setText(mSQL.getColours(midAvg,0,0,0,0,0,0,0,0,0));
       
       //obtain end of year academic colours value of that year]
       lblFinalColoursValue.setText(mSQL.getColours(midAvg,endAvg,0,0,0,0,0,0,0,0));
       
        
    }//GEN-LAST:event_lblLV2MouseClicked

    private void cmbSubjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbSubjectActionPerformed

      pnlChart.removeAll();
      refreshGraph();
        // TODO add your handling code here:
    }//GEN-LAST:event_cmbSubjectActionPerformed

    private void cmbYearOfStudyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbYearOfStudyActionPerformed
        pnlChart.removeAll();
        refreshGraph();
        // TODO add your handling code here:
    }//GEN-LAST:event_cmbYearOfStudyActionPerformed

    
 
    private void btnDisplayColoursSummaryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDisplayColoursSummaryActionPerformed
        openDialog(dlgDisplayColours, 1063,700);
        closeDialog(dlgMiniDisplayColours);
        this.setVisible(false);
        
        //display all of the mark averages and awards in the table
        int sID = student.getUserID();
        int matricYear = Integer.parseInt(student.getMatricYear());
        //year each of grade
        String gr12 = String.valueOf(matricYear);
        String gr11 = String.valueOf(matricYear - 1);
        String gr10 = String.valueOf(matricYear - 2);
        String gr9 = String.valueOf(matricYear - 3);
        String gr8 = String.valueOf(matricYear - 4);
        
        
        
        
        //mid year averages 
        int mark8 = mSQL.getMidAverage(sID, gr8);
        lblMidAvgLV.setText(String.valueOf(mark8));
        
        int mark9 = mSQL.getMidAverage(sID, gr9);
        lblMidAvgMV.setText(String.valueOf(mark9));
        
        int mark10 = mSQL.getMidAverage(sID, gr10);
        lblMidAvgUV.setText(String.valueOf(mark10));    
    
        int mark11 = mSQL.getMidAverage(sID, gr11);
        lblMidAvgAM.setText(String.valueOf(mark11));
        
        int mark12 = mSQL.getMidAverage(sID, gr12);
        lblMidAvgMatric.setText(String.valueOf(mark12));
        
        //end of year averages (term 3)
        int eMark8 = mSQL.getEndAverage(sID, gr8);
        int eMark9 = mSQL.getEndAverage(sID, gr9);
        int eMark10 = mSQL.getEndAverage(sID, gr10);
        int eMark11 = mSQL.getEndAverage(sID, gr11);
        int eMark12 = mSQL.getEndAverage(sID, gr12);
        
        //final averages
        int fMark8 = mSQL.getFinalAverage(sID, gr8);
        lblEndAvgLV.setText(String.valueOf(fMark8));
        
        int fMark9 = mSQL.getFinalAverage(sID, gr9);
        lblEndAvgMV.setText(String.valueOf(fMark9));
        
        int fMark10 = mSQL.getFinalAverage(sID, gr10);
        lblEndAvgUV.setText(String.valueOf(fMark10));    
    
        int fMark11 = mSQL.getFinalAverage(sID, gr11);
        lblEndAvgAM.setText(String.valueOf(fMark11));
        
        int fMark12 = mSQL.getFinalAverage(sID, gr12);
        lblEndAvgMatric.setText(String.valueOf(fMark12));
        
        
        //academic awards
        String midAward8 = mSQL.getColours(mark8,0,0,0,0,0,0,0,0,0);
        lblMidAwardLV.setText(midAward8);
        
        String endAward8 = mSQL.getColours(mark8,eMark8,0,0,0,0,0,0,0,0);
        lblEndAwardLV.setText(endAward8);      
        
        String midAward9 = mSQL.getColours(mark8,eMark8,mark9,0,0,0,0,0,0,0);
        lblMidAwardMV.setText(midAward9);
        
        String endAward9 = mSQL.getColours(mark8,eMark8,mark9,eMark9,0,0,0,0,0,0);
        lblEndAwardMV.setText(endAward9);     
        
        String midAward10 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,0,0,0,0,0);
        lblMidAwardUV.setText(midAward10);          
       
        String endAward10 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,eMark10,0,0,0,0);
        lblEndAwardUV.setText(endAward10);        
        
        String midAward11 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,eMark10,mark11,0,0,0);
        lblMidAwardAM.setText(midAward11);  
        
        String endAward11 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,eMark10,mark11,eMark11,0,0);
        lblEndAwardAM.setText(endAward11);          
        
        String midAward12 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,eMark10,mark11,eMark11,mark12,0);
        lblMidAwardMatric.setText(midAward12);   
        
        String endAward12 = mSQL.getColours(mark8,eMark8,mark9,eMark9,mark10,eMark10,mark11,eMark11,mark12,eMark12);
        lblEndAwardMatric.setText(endAward12);   
        
        
        
        // TODO add your handling code here:
    }//GEN-LAST:event_btnDisplayColoursSummaryActionPerformed

    private void btnViewMarksAMActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewMarksAMActionPerformed
       openDialog(dlgDisplayMarks,1020, 684);
       createDefaultBarChart(11);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);



        // TODO add your handling code here:
    }//GEN-LAST:event_btnViewMarksAMActionPerformed

    private void btnViewMarksMatricActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewMarksMatricActionPerformed
       openDialog(dlgDisplayMarks,1020, 684);
       createDefaultBarChart(12);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);



        // TODO add your handling code here:
    }//GEN-LAST:event_btnViewMarksMatricActionPerformed

    private void btnViewMarksLVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewMarksLVActionPerformed
       //display marks of selected grade
       openDialog(dlgDisplayMarks, 1020, 684);
       createDefaultBarChart(8);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);
      

        // TODO add your handling code here:
    }//GEN-LAST:event_btnViewMarksLVActionPerformed

    private void btnViewMarksMVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewMarksMVActionPerformed
       openDialog(dlgDisplayMarks,1020, 684);
       createDefaultBarChart(9);
       
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);



        // TODO add your handling code here:
    }//GEN-LAST:event_btnViewMarksMVActionPerformed

    private void btnViewMarksUVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewMarksUVActionPerformed
       openDialog(dlgDisplayMarks,1020, 684);
       createDefaultBarChart(10);
      
       //populate the yearOfStudy combo box with the last 5 years
       DefaultComboBoxModel studyYear = new DefaultComboBoxModel();
       LocalDate date = LocalDate.now();
       int year = date.getYear();
       studyYear.addElement(year);
       studyYear.addElement(year-1);
       studyYear.addElement(year-2);
       studyYear.addElement(year-3);
       studyYear.addElement(year-4);
       studyYear.addElement(year-5);
       
       cmbYearOfStudy.setModel(studyYear);




        // TODO add your handling code here:
    }//GEN-LAST:event_btnViewMarksUVActionPerformed

    private void btnLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLogOffActionPerformed

        dlgConfirmLogOff.setVisible(false);
        this.setVisible(false);
        dlgDisplayColours.setVisible(false);
        dlgDisplayMarks.setVisible(false);
        
        new LoginGUI().setVisible(true);
        
        // TODO add your handling code here:
    }//GEN-LAST:event_btnLogOffActionPerformed

    private void btnCancelLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelLogOffActionPerformed
    dlgConfirmLogOff.setVisible(false);
        
      
        
        // TODO add your handling code here:
    }//GEN-LAST:event_btnCancelLogOffActionPerformed

    private void mnuHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuHelpActionPerformed
    openDialog(dlgHelp,400,627);  


        // TODO add your handling code here:
    }//GEN-LAST:event_mnuHelpActionPerformed

    private void mnuSummaryHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuSummaryHelpActionPerformed
    openDialog(dlgHelp,400,627);



        // TODO add your handling code here:
    }//GEN-LAST:event_mnuSummaryHelpActionPerformed

    private void mnuSummaryLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuSummaryLogOffActionPerformed
    openDialog(dlgConfirmLogOff,338,207);
    
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuSummaryLogOffActionPerformed

    private void mnuSummaryAwardsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuSummaryAwardsActionPerformed
        String fn = "AwardsCriteria";
        openPDF(fn);       
    }//GEN-LAST:event_mnuSummaryAwardsActionPerformed

    private void mnuHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuHActionPerformed
        openDialog(dlgHelp,400,624);  
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuHActionPerformed

    private void mnuMainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuMainActionPerformed
    pnlMainPanel.setVisible(true);
    dlgDisplayMarks.setVisible(false);
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuMainActionPerformed

    private void btnCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCloseActionPerformed
       dlgHelp.setVisible(false);
        // TODO add your handling code here:
    }//GEN-LAST:event_btnCloseActionPerformed

    private void mnuLogOffActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuLogOffActionPerformed
    openDialog(dlgConfirmLogOff,338,207);
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuLogOffActionPerformed

    private void mnuACActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuACActionPerformed
        String fn = "AwardsCriteria";
        openPDF(fn);
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuACActionPerformed

    private void lblLVMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblLVMouseEntered
        // TODO add your handling code here:
    }//GEN-LAST:event_lblLVMouseEntered

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        dlgMiniDisplayColours.setVisible(false);
        

        // TODO add your handling code here:
    }//GEN-LAST:event_btnCancelActionPerformed

    private void mnuMainMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuMainMenuActionPerformed
    this.setVisible(true);
    dlgDisplayColours.setVisible(false);
        // TODO add your handling code here:
    }//GEN-LAST:event_mnuMainMenuActionPerformed

    private void pnlChartMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pnlChartMouseClicked
        // TODO add your handling code here:
    }//GEN-LAST:event_pnlChartMouseClicked
//method used to refresh the data in the graph
    private void refreshGraph()
    {
        String subject = cmbSubject.getSelectedItem().toString();
        String yos = cmbYearOfStudy.getSelectedItem().toString();
        System.out.println("sub: " + subject + "\nYos: " + yos);
        pnlChart.removeAll();
        createSelectedBarChart(subject,yos);
    }
    

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(StudentGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(StudentGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(StudentGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(StudentGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new StudentGUI(student).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnCancelLogOff;
    private javax.swing.JButton btnClose;
    private javax.swing.JButton btnDisplayColoursSummary;
    private javax.swing.JButton btnLogOff;
    private javax.swing.JButton btnViewMarksAM;
    private javax.swing.JButton btnViewMarksLV;
    private javax.swing.JButton btnViewMarksMV;
    private javax.swing.JButton btnViewMarksMatric;
    private javax.swing.JButton btnViewMarksUV;
    private javax.swing.JComboBox<String> cmbSubject;
    private javax.swing.JComboBox<String> cmbYearOfStudy;
    private javax.swing.JDialog dlgConfirmLogOff;
    private javax.swing.JDialog dlgDisplayColours;
    private javax.swing.JDialog dlgDisplayMarks;
    private javax.swing.JDialog dlgHelp;
    private javax.swing.JDialog dlgMiniDisplayColours;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuBar jMenuBar2;
    private javax.swing.JMenuBar jMenuBar3;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JLabel lblAcademicColoursProgress;
    private javax.swing.JLabel lblAnteMatric;
    private javax.swing.JLabel lblAnteMatric2;
    private javax.swing.JLabel lblColoursValue;
    private javax.swing.JLabel lblDisplayColoursHeading;
    private javax.swing.JLabel lblEndAvg;
    private javax.swing.JLabel lblEndAvgAM;
    private javax.swing.JLabel lblEndAvgHeader;
    private javax.swing.JLabel lblEndAvgLV;
    private javax.swing.JLabel lblEndAvgMV;
    private javax.swing.JLabel lblEndAvgMark;
    private javax.swing.JLabel lblEndAvgMatric;
    private javax.swing.JLabel lblEndAvgUV;
    private javax.swing.JLabel lblEndAwardAM;
    private javax.swing.JLabel lblEndAwardHeader;
    private javax.swing.JLabel lblEndAwardLV;
    private javax.swing.JLabel lblEndAwardMV;
    private javax.swing.JLabel lblEndAwardMatric;
    private javax.swing.JLabel lblEndAwardUV;
    private javax.swing.JLabel lblFinalAvg;
    private javax.swing.JLabel lblFinalAvgMark;
    private javax.swing.JLabel lblFinalColoursValue;
    private javax.swing.JLabel lblFinalYearColours;
    private javax.swing.JLabel lblHelpHeader;
    private javax.swing.JLabel lblLV;
    private javax.swing.JLabel lblLV2;
    private javax.swing.JLabel lblLogOffHeader;
    private javax.swing.JLabel lblMV;
    private javax.swing.JLabel lblMV2;
    private javax.swing.JLabel lblMarks;
    private javax.swing.JLabel lblMarksLadder;
    private javax.swing.JLabel lblMarksLadder2;
    private javax.swing.JLabel lblMatric;
    private javax.swing.JLabel lblMatric2;
    private javax.swing.JLabel lblMidAvg;
    private javax.swing.JLabel lblMidAvgAM;
    private javax.swing.JLabel lblMidAvgAwardHeader;
    private javax.swing.JLabel lblMidAvgHeader;
    private javax.swing.JLabel lblMidAvgLV;
    private javax.swing.JLabel lblMidAvgMV;
    private javax.swing.JLabel lblMidAvgMark;
    private javax.swing.JLabel lblMidAvgMatric;
    private javax.swing.JLabel lblMidAvgUV;
    private javax.swing.JLabel lblMidAwardAM;
    private javax.swing.JLabel lblMidAwardLV;
    private javax.swing.JLabel lblMidAwardMV;
    private javax.swing.JLabel lblMidAwardMatric;
    private javax.swing.JLabel lblMidAwardUV;
    private javax.swing.JLabel lblMidColours;
    private javax.swing.JLabel lblMiniDisplayColoursHeading;
    private javax.swing.JLabel lblP1;
    private javax.swing.JLabel lblP10;
    private javax.swing.JLabel lblP3;
    private javax.swing.JLabel lblP4;
    private javax.swing.JLabel lblP5;
    private javax.swing.JLabel lblP6;
    private javax.swing.JLabel lblP7;
    private javax.swing.JLabel lblP8;
    private javax.swing.JLabel lblP9;
    private javax.swing.JLabel lblSelectMarksToView;
    private javax.swing.JLabel lblSubject;
    private javax.swing.JLabel lblSubjectMarksView;
    private javax.swing.JLabel lblTable;
    private javax.swing.JLabel lblUV;
    private javax.swing.JLabel lblUV2;
    private javax.swing.JLabel lblYear;
    private javax.swing.JMenuItem menuItemCriteria;
    private javax.swing.JMenuItem menuItemLogoff;
    private javax.swing.JMenu menuOptions;
    private javax.swing.JMenuItem mnuAC;
    private javax.swing.JMenuItem mnuH;
    private javax.swing.JMenuItem mnuHelp;
    private javax.swing.JMenuItem mnuLogOff;
    private javax.swing.JMenuItem mnuMain;
    private javax.swing.JMenuItem mnuMainMenu;
    private javax.swing.JMenu mnuMarkOptions;
    private javax.swing.JMenu mnuOptions;
    private javax.swing.JMenuItem mnuSummaryAwards;
    private javax.swing.JMenuItem mnuSummaryHelp;
    private javax.swing.JMenuItem mnuSummaryLogOff;
    private javax.swing.JPanel pnlChart;
    private javax.swing.JPanel pnlColoursProgress;
    private javax.swing.JPanel pnlMainPanel;
    private javax.swing.JPanel pnlMarks;
    // End of variables declaration//GEN-END:variables
}
